/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.chart;

import aw.gui.chart.Chart2D;
import aw.gui.chart.ITrace2D;
import aw.gui.chart.TracePoint2D;
import aw.util.collections.IRingBuffer;
import aw.util.collections.RingBufferArrayFast;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Trace2DLtd
implements ITrace2D {
    public static final boolean debug = true;
    protected IRingBuffer buffer;
    protected Color color;
    protected List changeListeners = new LinkedList();
    protected String label = "";
    double maxX;
    double minX;
    double maxY;
    double minY;
    private boolean firsttime = true;
    protected String name = "";
    protected String physunit = "";
    protected Object renderer = new Object();

    public Trace2DLtd() {
        this(100);
    }

    public Trace2DLtd(int maxsize) {
        this.buffer = new RingBufferArrayFast(maxsize);
    }

    public int getMaxSize() {
        return this.buffer.getBufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxSize(int amount) {
        Object object = this.renderer;
        synchronized (object) {
            Trace2DLtd trace2DLtd = this;
            synchronized (trace2DLtd) {
                this.buffer.setBufferSize(amount);
            }
        }
    }

    public int getSize() {
        return this.buffer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(TracePoint2D p) {
        Object object = this.renderer;
        synchronized (object) {
            Trace2DLtd trace2DLtd = this;
            synchronized (trace2DLtd) {
                if (this.firsttime) {
                    this.minX = this.maxX = p.getX();
                    this.minY = this.maxY = p.getY();
                    this.firsttime = false;
                    this.buffer.add(p);
                } else {
                    double tmpy;
                    double tmpx;
                    TracePoint2D removed = (TracePoint2D)this.buffer.add(p);
                    if (removed != null) {
                        tmpx = removed.getX();
                        tmpy = removed.getY();
                        if (tmpx >= this.maxX) {
                            this.maxXSearch();
                        } else if (tmpx <= this.minX) {
                            this.minXSearch();
                        }
                        if (tmpy >= this.maxY) {
                            this.maxYSearch();
                        } else if (tmpy <= this.minY) {
                            this.minYSearch();
                        }
                    }
                    tmpx = p.getX();
                    tmpy = p.getY();
                    if (tmpx > this.maxX) {
                        this.maxX = tmpx;
                    } else if (tmpx < this.minX) {
                        this.minX = tmpx;
                    }
                    if (tmpy > this.maxY) {
                        this.maxY = tmpy;
                    } else if (tmpy < this.minY) {
                        this.minY = tmpy;
                    }
                }
                this.fireTraceChanged(p);
            }
        }
    }

    public void addPoint(double x, double y) {
        this.addPoint(new TracePoint2D(this, x, y));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        Object object = this.renderer;
        synchronized (object) {
            Trace2DLtd trace2DLtd = this;
            synchronized (trace2DLtd) {
                return this.buffer.iteratorF2L();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTraceChanged(TracePoint2D changed) {
        ITrace2D.Trace2DChangeEvent fire = new ITrace2D.Trace2DChangeEvent(this, changed);
        IRingBuffer iRingBuffer = this.buffer;
        synchronized (iRingBuffer) {
            Iterator it = this.changeListeners.iterator();
            while (it.hasNext()) {
                ((ITrace2D.Trace2DListener)it.next()).traceChanged(fire);
            }
        }
    }

    public Color getColor() {
        return this.color;
    }

    public String getLabel() {
        return this.label;
    }

    public void pointChanged(TracePoint2D d) {
        this.fireTraceChanged(d);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public double getMinY() {
        return this.minY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void minYSearch() {
        Trace2DLtd trace2DLtd = this;
        synchronized (trace2DLtd) {
            double ret = Double.MAX_VALUE;
            TracePoint2D tmpoint = null;
            Iterator it = this.buffer.iteratorF2L();
            while (it.hasNext()) {
                double d;
                tmpoint = (TracePoint2D)it.next();
                double tmp = tmpoint.getY();
                if (!(d < ret)) continue;
                ret = tmp;
            }
            this.minY = ret == Double.MAX_VALUE ? 0.0 : ret;
        }
    }

    public double getMaxY() {
        return this.maxY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maxYSearch() {
        Trace2DLtd trace2DLtd = this;
        synchronized (trace2DLtd) {
            double ret = -1.7976931348623157E308;
            TracePoint2D tmpoint = null;
            Iterator it = this.buffer.iteratorF2L();
            while (it.hasNext()) {
                double d;
                tmpoint = (TracePoint2D)it.next();
                double tmp = tmpoint.getY();
                if (!(d > ret)) continue;
                ret = tmp;
            }
            this.maxY = ret == -1.7976931348623157E308 ? 0.0 : ret;
        }
    }

    public double getMinX() {
        return this.minX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void minXSearch() {
        Trace2DLtd trace2DLtd = this;
        synchronized (trace2DLtd) {
            double ret = Double.MAX_VALUE;
            TracePoint2D tmpoint = null;
            Iterator it = this.buffer.iteratorF2L();
            while (it.hasNext()) {
                double d;
                tmpoint = (TracePoint2D)it.next();
                double tmp = tmpoint.getX();
                if (!(d < ret)) continue;
                ret = tmp;
            }
            this.minX = ret == Double.MAX_VALUE ? 0.0 : ret;
        }
    }

    public double getMaxX() {
        return this.maxX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maxXSearch() {
        Trace2DLtd trace2DLtd = this;
        synchronized (trace2DLtd) {
            double ret = -1.7976931348623157E308;
            TracePoint2D tmpoint = null;
            Iterator it = this.buffer.iteratorF2L();
            while (it.hasNext()) {
                double d;
                tmpoint = (TracePoint2D)it.next();
                double tmp = tmpoint.getX();
                if (!(d > ret)) continue;
                ret = tmp;
            }
            this.maxX = ret == -1.7976931348623157E308 ? 0.0 : ret;
        }
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public void addChangeListener(ITrace2D.Trace2DListener x) {
        this.changeListeners.add(x);
        x.traceChanged(new ITrace2D.Trace2DChangeEvent(this, ALL_POINTS_CHANGED));
    }

    public void removeChangeListener(ITrace2D.Trace2DListener x) {
        this.changeListeners.remove(x);
    }

    public String getName() {
        return this.name;
    }

    public String getPhysicalUnits() {
        return this.physunit;
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setPhysicalUnits(String xunit, String yunit) {
        if (xunit == null && yunit == null) {
            return;
        }
        if (xunit == null && yunit != null) {
            this.physunit = "[x: , y: " + yunit + "]";
            return;
        }
        if (xunit != null && yunit == null) {
            this.physunit = "[x: " + xunit + ", y: ]";
            return;
        }
        this.physunit = "[x: " + xunit + ", y: " + yunit + "]";
    }

    public Chart2D getRenderer() {
        if (this.renderer instanceof Chart2D) {
            return (Chart2D)this.renderer;
        }
        return null;
    }

    public void setRenderer(Chart2D renderer) {
        this.renderer = renderer;
    }

    public static void main(String[] args) {
        try {
            Trace2DLtd test = new Trace2DLtd(10);
            System.out.println("adding 0 to 9 to size limit of 10: ");
            for (int i = 0; i < 10; ++i) {
                test.addPoint(i, i);
            }
            System.out.println("Iterator- test: ");
            Iterator it = test.iterator();
            while (it.hasNext()) {
                System.out.println("Iterator: " + it.next());
            }
            System.out.println("buffer.getYoungest(): " + test.buffer.getYoungest());
            System.out.println("buffer.getOldest(): " + test.buffer.getOldest());
            System.out.println("\nsetting size to 15.");
            test.setMaxSize(15);
            System.out.println("Iterator- test: ");
            it = test.iterator();
            while (it.hasNext()) {
                System.out.println("Iterator: " + it.next());
            }
            System.out.println("buffer.getYoungest(): " + test.buffer.getYoungest());
            System.out.println("buffer.getOldest(): " + test.buffer.getOldest());
            System.out.println("\nadding 10 to 14 to size limit of 14: ");
            for (int i = 10; i < 15; ++i) {
                test.addPoint(i, i);
            }
            System.out.println("Iterator- test: ");
            it = test.iterator();
            while (it.hasNext()) {
                System.out.println("Iterator: " + it.next());
            }
            System.out.println("buffer.getYoungest(): " + test.buffer.getYoungest());
            System.out.println("buffer.getOldest(): " + test.buffer.getOldest());
        }
        catch (Throwable f) {
            f.printStackTrace();
        }
    }
}

