/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.chart;

import aw.gui.chart.Chart2D;
import aw.gui.chart.ITrace2D;
import aw.gui.chart.TracePoint2D;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Trace2DSimple
implements ITrace2D {
    protected LinkedList points = new LinkedList();
    protected Color color;
    protected List changeListeners = new LinkedList();
    protected String label = "";
    double maxX;
    double minX;
    double maxY;
    double minY;
    protected boolean firsttime = true;
    protected String physunit = "";
    protected String name = "";
    Object renderer = new Object();

    public final int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    public final int getSize() {
        return this.points.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(TracePoint2D p) {
        Object object = this.renderer;
        synchronized (object) {
            Trace2DSimple trace2DSimple = this;
            synchronized (trace2DSimple) {
                if (this.firsttime) {
                    this.minX = this.maxX = p.getX();
                    this.minY = this.maxY = p.getY();
                    this.firsttime = false;
                    this.points.add(p);
                } else {
                    double d;
                    double d2;
                    double tmp = p.getX();
                    if (d2 > this.maxX) {
                        this.maxX = tmp;
                    }
                    if (tmp < this.minX) {
                        this.minX = tmp;
                    }
                    tmp = p.getY();
                    if (d > this.maxY) {
                        this.maxY = tmp;
                    }
                    if (tmp < this.minY) {
                        this.minY = tmp;
                    }
                    this.points.add(p);
                }
                this.fireTraceChanged(p);
            }
        }
    }

    public void addPoint(double x, double y) {
        TracePoint2D p = new TracePoint2D(this, x, y);
        this.addPoint(p);
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Iterator iterator() {
        return this.points.iterator();
    }

    public void addChangeListener(ITrace2D.Trace2DListener x) {
        this.changeListeners.add(x);
        x.traceChanged(new ITrace2D.Trace2DChangeEvent(this, ALL_POINTS_CHANGED));
    }

    public void removeChangeListener(ITrace2D.Trace2DListener x) {
        this.changeListeners.remove(x);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTraceChanged(TracePoint2D changed) {
        ITrace2D.Trace2DChangeEvent fire = new ITrace2D.Trace2DChangeEvent(this, changed);
        LinkedList linkedList = this.points;
        synchronized (linkedList) {
            Iterator it = this.changeListeners.iterator();
            while (it.hasNext()) {
                ((ITrace2D.Trace2DListener)it.next()).traceChanged(fire);
            }
        }
    }

    public void pointChanged(TracePoint2D d) {
        this.fireTraceChanged(d);
    }

    public boolean isEmpty() {
        return this.points.size() == 0;
    }

    public String getName() {
        return this.name;
    }

    public String getPhysicalUnits() {
        return this.physunit;
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setPhysicalUnits(String xunit, String yunit) {
        if (xunit == null && yunit == null) {
            return;
        }
        if (xunit == null && yunit != null) {
            this.physunit = "[x: , y: " + yunit + "]";
            return;
        }
        if (xunit != null && yunit == null) {
            this.physunit = "[x: " + xunit + ", y: ]";
            return;
        }
        this.physunit = "[x: " + xunit + ", y: " + yunit + "]";
    }

    public final Chart2D getRenderer() {
        if (this.renderer instanceof Chart2D) {
            return (Chart2D)this.renderer;
        }
        return null;
    }

    public final void setRenderer(Chart2D renderer) {
        this.renderer = renderer;
    }
}

