/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.chart;

import aw.gui.chart.Chart2D;
import aw.gui.chart.ITrace2D;
import aw.gui.chart.TracePoint2D;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class Trace2DSorted
implements ITrace2D {
    protected TreeSet points = new TreeSet();
    protected Color color;
    protected List changeListeners = new LinkedList();
    protected String label = "";
    double maxX;
    double minX;
    double maxY;
    double minY;
    protected boolean firsttime = true;
    protected String name = "";
    protected String physunit = "";
    Object renderer = new Object();

    public int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    public final int getSize() {
        return this.points.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(TracePoint2D p) {
        Object object = this.renderer;
        synchronized (object) {
            TreeSet treeSet = this.points;
            synchronized (treeSet) {
                if (this.firsttime) {
                    this.minX = this.maxX = p.getX();
                    this.minY = this.maxY = p.getY();
                    this.firsttime = false;
                } else {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    double tmp = 0.0;
                    tmp = p.getX();
                    if (d4 > this.maxX) {
                        this.maxX = tmp;
                    }
                    tmp = p.getX();
                    if (d3 < this.minX) {
                        this.minX = tmp;
                    }
                    tmp = p.getY();
                    if (d2 > this.maxY) {
                        this.maxY = tmp;
                    }
                    tmp = p.getY();
                    if (d < this.minY) {
                        this.minY = tmp;
                    }
                }
                this.points.remove(p);
                this.points.add(p);
                this.fireTraceChanged(p);
            }
        }
    }

    public void addPoint(double x, double y) {
        TracePoint2D p = new TracePoint2D(this, x, y);
        this.addPoint(p);
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public Color getColor() {
        return this.color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maxXSearch() {
        Trace2DSorted trace2DSorted = this;
        synchronized (trace2DSorted) {
            double ret = Double.MIN_VALUE;
            TracePoint2D tmpoint = null;
            Iterator it = this.points.iterator();
            while (it.hasNext()) {
                double d;
                tmpoint = (TracePoint2D)it.next();
                double tmp = tmpoint.getX();
                if (!(d > ret)) continue;
                ret = tmp;
            }
            this.maxX = ret == Double.MIN_VALUE ? 0.0 : ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void minXSearch() {
        Trace2DSorted trace2DSorted = this;
        synchronized (trace2DSorted) {
            double ret = Double.MAX_VALUE;
            TracePoint2D tmpoint = null;
            Iterator it = this.points.iterator();
            while (it.hasNext()) {
                double d;
                tmpoint = (TracePoint2D)it.next();
                double tmp = tmpoint.getX();
                if (!(d < ret)) continue;
                ret = tmp;
            }
            this.minX = ret == Double.MAX_VALUE ? 0.0 : ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maxYSearch() {
        Trace2DSorted trace2DSorted = this;
        synchronized (trace2DSorted) {
            double ret = Double.MIN_VALUE;
            TracePoint2D tmpoint = null;
            Iterator it = this.points.iterator();
            while (it.hasNext()) {
                double d;
                tmpoint = (TracePoint2D)it.next();
                double tmp = tmpoint.getY();
                if (!(d > ret)) continue;
                ret = tmp;
            }
            this.maxY = ret == Double.MIN_VALUE ? 0.0 : ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void minYSearch() {
        Trace2DSorted trace2DSorted = this;
        synchronized (trace2DSorted) {
            double ret = Double.MAX_VALUE;
            TracePoint2D tmpoint = null;
            Iterator it = this.points.iterator();
            while (it.hasNext()) {
                double d;
                tmpoint = (TracePoint2D)it.next();
                double tmp = tmpoint.getY();
                if (!(d < ret)) continue;
                ret = tmp;
            }
            this.minY = ret == Double.MAX_VALUE ? 0.0 : ret;
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Iterator iterator() {
        return this.points.iterator();
    }

    public void addChangeListener(ITrace2D.Trace2DListener x) {
        this.changeListeners.add(x);
        x.traceChanged(new ITrace2D.Trace2DChangeEvent(this, ALL_POINTS_CHANGED));
    }

    public void removeChangeListener(ITrace2D.Trace2DListener x) {
        this.changeListeners.remove(x);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTraceChanged(TracePoint2D d) {
        ITrace2D.Trace2DChangeEvent fire = new ITrace2D.Trace2DChangeEvent(this, d);
        TreeSet treeSet = this.points;
        synchronized (treeSet) {
            Iterator it = this.changeListeners.iterator();
            while (it.hasNext()) {
                ((ITrace2D.Trace2DListener)it.next()).traceChanged(fire);
            }
        }
    }

    public void pointChanged(TracePoint2D d) {
        this.fireTraceChanged(d);
    }

    public boolean isEmpty() {
        return this.points.size() == 0;
    }

    public String toString() {
        return this.points.toString();
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public String getPhysicalUnits() {
        return this.physunit;
    }

    public void setPhysicalUnits(String xunit, String yunit) {
        if (xunit == null && yunit == null) {
            return;
        }
        if (xunit == null && yunit != null) {
            this.physunit = "[x: , y: " + yunit + "]";
            return;
        }
        if (xunit != null && yunit == null) {
            this.physunit = "[x: " + xunit + ", y: ]";
            return;
        }
        this.physunit = "[x: " + xunit + ", y: " + yunit + "]";
    }

    public Chart2D getRenderer() {
        if (this.renderer instanceof Chart2D) {
            return (Chart2D)this.renderer;
        }
        return null;
    }

    public void setRenderer(Chart2D renderer) {
        this.renderer = renderer;
    }
}

