/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.chart.demo;

import aw.gui.chart.AbstractDataCollector;
import aw.gui.chart.Chart2D;
import aw.gui.chart.RandomDataCollector;
import aw.gui.chart.Trace2DLtd;
import aw.util.Range;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Chart2DApplet
extends Applet {
    Chart2D chart;
    AbstractDataCollector collector;
    Trace2DLtd trace;
    private boolean running = false;

    public void init() {
        super.init();
        this.chart = new Chart2D();
        this.chart.setGridX(true);
        this.chart.setDecimalsX(0);
        this.chart.setGridY(true);
        this.chart.setForceYRange(new Range(-20.0, 20.0));
        this.chart.setGridColor(Color.LIGHT_GRAY);
        this.trace = new Trace2DLtd(100);
        this.trace.setName("random");
        this.trace.setPhysicalUnits("Milliseconds", "random value");
        this.trace.setColor(Color.RED);
        this.chart.addTrace(this.trace);
        this.collector = new RandomDataCollector(this.trace, 60);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.chart);
        this.add(new ControlPanel());
    }

    public synchronized void startData() {
        if (!this.running) {
            new Thread(this.collector).start();
            this.running = true;
        }
    }

    public synchronized void stopData() {
        if (this.running) {
            this.collector.stop();
            this.running = false;
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container contentpane = frame.getContentPane();
        contentpane.setLayout(new GridLayout(1, 1));
        Chart2DApplet applet = new Chart2DApplet();
        applet.init();
        contentpane.add(applet);
        frame.setSize(300, 400);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.show();
        frame.invalidate();
        frame.repaint();
    }

    class ControlPanel
    extends JPanel {
        JSlider amountPointsSlider;
        JSlider latencyTimeSlider;
        JButton startStop;

        ControlPanel() {
            this.setBackground(Color.WHITE);
            this.amountPointsSlider = new JSlider(10, 410);
            this.amountPointsSlider.setBackground(Color.WHITE);
            int maxPoints = Chart2DApplet.this.trace.getMaxSize();
            this.amountPointsSlider.setValue(maxPoints);
            this.amountPointsSlider.setMajorTickSpacing(40);
            this.amountPointsSlider.setMinorTickSpacing(20);
            this.amountPointsSlider.setSnapToTicks(true);
            this.amountPointsSlider.setPaintLabels(true);
            this.amountPointsSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Amount of points.", 1, 3));
            this.amountPointsSlider.setPaintTicks(true);
            this.amountPointsSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (!source.getValueIsAdjusting()) {
                        int value = source.getValue();
                        ((ControlPanel)ControlPanel.this).Chart2DApplet.this.trace.setMaxSize(value);
                    }
                }
            });
            this.latencyTimeSlider = new JSlider(10, 210);
            this.latencyTimeSlider.setBackground(Color.WHITE);
            this.latencyTimeSlider.setValue((int)Chart2DApplet.this.collector.getLatency());
            this.latencyTimeSlider.setMajorTickSpacing(50);
            this.latencyTimeSlider.setMinorTickSpacing(10);
            this.latencyTimeSlider.setSnapToTicks(true);
            this.latencyTimeSlider.setPaintLabels(true);
            this.latencyTimeSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Latency for adding points.", 1, 3));
            this.latencyTimeSlider.setPaintTicks(true);
            this.latencyTimeSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (!source.getValueIsAdjusting()) {
                        int value = source.getValue();
                        ((ControlPanel)ControlPanel.this).Chart2DApplet.this.collector.setLatency(value);
                    }
                }
            });
            this.startStop = new JButton("start");
            this.startStop.setBackground(Color.WHITE);
            this.startStop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JButton source = (JButton)e.getSource();
                    if (Chart2DApplet.this.running) {
                        Chart2DApplet.this.stopData();
                        source.setText("start");
                    } else {
                        Chart2DApplet.this.startData();
                        source.setText("stop");
                    }
                    source.invalidate();
                    source.repaint();
                }
            });
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.amountPointsSlider);
            this.add(this.latencyTimeSlider);
            JPanel stretch = new JPanel();
            stretch.setBackground(Color.WHITE);
            stretch.setLayout(new BoxLayout(stretch, 0));
            stretch.add(Box.createHorizontalGlue());
            stretch.add(this.startStop);
            stretch.add(Box.createHorizontalGlue());
            this.add(stretch);
        }
    }
}

