/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.chart.demo;

import aw.gui.chart.demo.INameFilter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public final class FileFilterExtensions
extends FileFilter
implements INameFilter {
    private String[] extensions;
    private boolean isWindows = false;

    public FileFilterExtensions(String[] extensionsWithoutDot) throws IllegalArgumentException {
        this.verify(extensionsWithoutDot);
        this.extensions = extensionsWithoutDot;
        this.isWindows = this.isWindows();
    }

    private void verify(String[] extensions) throws IllegalArgumentException {
        StringBuffer msg = new StringBuffer();
        for (int i = extensions.length - 1; i >= 0; --i) {
            String current = extensions[i];
            if (current == null) {
                msg.append("Extension at index " + i + " is null!\n");
                continue;
            }
            if (current.indexOf(46) == -1) continue;
            msg.append("Extension \"" + current + "\" contains a dot!\n");
        }
        if (msg.length() > 0) {
            throw new IllegalArgumentException(msg.toString());
        }
    }

    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return true;
        }
        return this.acceptNoDirectory(pathname.getAbsolutePath());
    }

    public boolean accept(String urlstring) {
        if (this.isDirectory(urlstring)) {
            return true;
        }
        return this.acceptNoDirectory(urlstring);
    }

    private boolean acceptNoDirectory(String noDirFileNoURL) {
        boolean ret = false;
        StringTokenizer tokenizer = new StringTokenizer(noDirFileNoURL, ".");
        String extension = "no.txt";
        while (tokenizer.hasMoreElements()) {
            extension = tokenizer.nextToken();
        }
        for (int i = this.extensions.length - 1; i >= 0; --i) {
            if (!this.extensions[i].equals(extension)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public String getDescription() {
        StringBuffer ret = new StringBuffer();
        int len = this.extensions.length;
        for (int i = 0; i < len; ++i) {
            ret.append("*.").append(this.extensions[i]);
            if (i >= len - 1) continue;
            ret.append(",");
        }
        return ret.toString();
    }

    private boolean isDirectory(String urlstring) {
        boolean ret = false;
        boolean isURL = false;
        try {
            URL test = new URL(urlstring);
            isURL = true;
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        int lastDot = urlstring.lastIndexOf(46);
        int lastSeparator = isURL ? urlstring.lastIndexOf(47) : (this.isWindows ? urlstring.lastIndexOf(92) : urlstring.lastIndexOf(47));
        ret = lastSeparator == -1 ? lastDot == -1 : (lastDot == -1 ? true : lastDot <= lastSeparator + 1);
        return ret;
    }

    private boolean isWindows() {
        boolean ret = false;
        File[] roots = FileSystemView.getFileSystemView().getRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (roots[i].getAbsolutePath().indexOf(58) == -1) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

