/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.chart.demo;

import aw.gui.chart.Chart2D;
import aw.gui.chart.ITrace2D;
import aw.gui.chart.Trace2DSimple;
import aw.util.Range;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.JFrame;

public class MultiTracing
extends JFrame {
    protected Chart2D chart = new Chart2D();
    static final boolean debug = false;

    public MultiTracing() {
        super("MultiTracing");
        this.chart.setGridX(true);
        this.chart.setGridY(true);
        this.chart.setBackground(Color.lightGray);
        this.chart.setGridColor(new Color(221, 221, 221));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.chart, "Center");
    }

    public void addTrace(ITrace2D data) {
        this.chart.addTrace(data);
    }

    public void removeTrace(ITrace2D data) {
        this.chart.removeTrace(data);
    }

    public static void main(String[] args) {
        int i;
        final double[][] data = new double[6][150];
        final Random rand = new Random();
        long speed = 100L;
        data[0][0] = rand.nextDouble() * 5.0;
        for (int i2 = 1; i2 < data[0].length; ++i2) {
            data[0][i2] = rand.nextDouble() < 0.5 ? data[0][i2 - 1] + rand.nextDouble() * 5.0 : data[0][i2 - 1] - rand.nextDouble() * 5.0;
        }
        for (i = 0; i < data[0].length; ++i) {
            double tmp;
            data[1][i] = tmp = Math.pow(Math.E, (double)i / 60.0);
        }
        for (i = 0; i < data[0].length; ++i) {
            data[2][i] = Math.pow(Math.cos((double)i / 10.0) * 5.0, 2.0);
        }
        data[3][0] = data[0][0];
        double tmp = 0.0;
        for (i = 1; i < data[0].length; ++i) {
            for (int j = 0; j <= i; ++j) {
                tmp += data[0][j];
            }
            data[3][i] = tmp / ((double)i + 1.0);
            tmp = 0.0;
        }
        for (i = 0; i < data[0].length; ++i) {
            data[4][i] = data[1][i] + data[2][i] * (0.1 * -data[0][i]);
        }
        for (i = 0; i < data[0].length; ++i) {
            data[5][i] = data[0][i] + data[2][i];
        }
        final MultiTracing wnd = new MultiTracing();
        wnd.setForceXRange(new Range(0.0, data[0].length + 10));
        wnd.setForceYRange(MultiTracing.getRange(data));
        wnd.setLocation(200, 300);
        wnd.setSize(500, 300);
        wnd.setResizable(true);
        wnd.setVisible(true);
        new Thread(){

            public void run() {
                while (true) {
                    Trace2DSimple test = new Trace2DSimple();
                    test.setColor(Color.blue);
                    test.setName(this.getName());
                    wnd.addTrace(test);
                    for (int i = 0; i < data[0].length; ++i) {
                        test.addPoint(i, data[0][i]);
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                    try {
                        Thread.sleep((long)(rand.nextDouble() * 10000.0 + 1000.0));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                    }
                    wnd.removeTrace(test);
                    try {
                        Thread.sleep((long)(rand.nextDouble() * 15000.0 + 1000.0));
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                        continue;
                    }
                    break;
                }
            }
        }.start();
        new Thread(){

            public void run() {
                while (true) {
                    Trace2DSimple test = new Trace2DSimple();
                    test.setColor(Color.red);
                    test.setName(this.getName());
                    wnd.addTrace(test);
                    for (int i = 0; i < data[0].length; ++i) {
                        test.addPoint(i, data[1][i]);
                        try {
                            Thread.sleep(110L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                    try {
                        Thread.sleep((long)(rand.nextDouble() * 10000.0 + 1000.0));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                    }
                    wnd.removeTrace(test);
                    try {
                        Thread.sleep((long)(rand.nextDouble() * 15000.0 + 1000.0));
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                        continue;
                    }
                    break;
                }
            }
        }.start();
        new Thread(){

            public void run() {
                while (true) {
                    Trace2DSimple test = new Trace2DSimple();
                    test.setColor(Color.green);
                    test.setName(this.getName());
                    wnd.addTrace(test);
                    for (int i = 0; i < data[0].length; ++i) {
                        test.addPoint(i, data[2][i]);
                        try {
                            Thread.sleep(120L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                    try {
                        Thread.sleep((long)(rand.nextDouble() * 10000.0 + 1000.0));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                    }
                    wnd.removeTrace(test);
                    try {
                        Thread.sleep((long)(rand.nextDouble() * 15000.0 + 1000.0));
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                        continue;
                    }
                    break;
                }
            }
        }.start();
        new Thread(){

            public void run() {
                while (true) {
                    Trace2DSimple test = new Trace2DSimple();
                    test.setColor(Color.cyan);
                    test.setName(this.getName());
                    wnd.addTrace(test);
                    for (int i = 0; i < data[0].length; ++i) {
                        test.addPoint(i, data[3][i]);
                        try {
                            Thread.sleep(130L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                    try {
                        Thread.sleep((long)(rand.nextDouble() * 10000.0 + 1000.0));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                    }
                    wnd.removeTrace(test);
                    try {
                        Thread.sleep((long)(rand.nextDouble() * 15000.0 + 1000.0));
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                        continue;
                    }
                    break;
                }
            }
        }.start();
        new Thread(){

            public void run() {
                while (true) {
                    Trace2DSimple test = new Trace2DSimple();
                    test.setColor(Color.magenta);
                    test.setName(this.getName());
                    wnd.addTrace(test);
                    for (int i = 0; i < data[0].length; ++i) {
                        test.addPoint(i, data[4][i]);
                        try {
                            Thread.sleep(140L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                    try {
                        Thread.sleep((long)(rand.nextDouble() * 10000.0 + 1000.0));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                    }
                    wnd.removeTrace(test);
                    try {
                        Thread.sleep((long)(rand.nextDouble() * 15000.0 + 1000.0));
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                        continue;
                    }
                    break;
                }
            }
        }.start();
        new Thread(){

            public void run() {
                while (true) {
                    Trace2DSimple test = new Trace2DSimple();
                    test.setColor(Color.white);
                    test.setName(this.getName());
                    wnd.addTrace(test);
                    for (int i = 0; i < data[0].length; ++i) {
                        test.addPoint(i, data[5][i]);
                        try {
                            Thread.sleep(150L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                    try {
                        Thread.sleep((long)(rand.nextDouble() * 10000.0 + 1000.0));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                    }
                    wnd.removeTrace(test);
                    try {
                        Thread.sleep((long)(rand.nextDouble() * 15000.0 + 1000.0));
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace(System.err);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    private static Range getRange(double[][] data) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i = data.length - 1; i >= 0; --i) {
            for (int j = data[i].length - 1; j >= 0; --j) {
                double tmp = data[i][j];
                if (tmp > max) {
                    max = tmp;
                }
                if (!(tmp < min)) continue;
                min = tmp;
            }
        }
        System.out.println("MIN Y : " + min);
        System.out.println("MAX Y : " + max);
        return new Range(min, max);
    }

    public void setForceXRange(Range forceXRange) {
        this.chart.setForceXRange(forceXRange);
    }

    public void setForceYRange(Range forceYRange) {
        this.chart.setForceYRange(forceYRange);
    }
}

