/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.chart.demo;

import aw.gui.chart.Chart2D;
import aw.gui.chart.ITrace2D;
import aw.gui.chart.Trace2DLtd;
import aw.reflection.ObjRecorder2Trace2DAdapter;
import aw.util.Range;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.JFrame;

public class RunningChart
extends JFrame {
    protected Chart2D chart = null;

    public RunningChart(Chart2D chart, String Label) {
        super(Label);
        this.chart = chart;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.chart, "Center");
    }

    public void addTrace(ITrace2D data) {
        this.chart.addTrace(data);
    }

    public void removeTrace(ITrace2D data) {
        this.chart.removeTrace(data);
    }

    public static void main(String[] args) {
        System.out.println("10e3: 10000.0");
        Chart2D chart = new Chart2D();
        Trace2DLtd data = new Trace2DLtd(300);
        data.setColor(Color.RED);
        data.setName("random");
        data.setPhysicalUnits("hertz", "ms");
        chart.addTrace(data);
        RunningChart wnd = new RunningChart(chart, "RunningChart");
        chart.setScaleX(true);
        chart.setGridX(true);
        chart.setDecimalsX(0);
        chart.setScaleY(true);
        chart.setGridY(true);
        chart.setForceYRange(new Range(-10000.0, 10000.0));
        wnd.setLocation(200, 300);
        wnd.setSize(700, 210);
        wnd.setResizable(true);
        wnd.setVisible(true);
        ObjRecorder2Trace2DAdapter adapter = new ObjRecorder2Trace2DAdapter(data, new RandomBumper(0.5, 1000), "number", 40L);
    }

    static class RandomBumper
    extends Thread {
        protected double number = 0.0;
        protected Random randomizer = new Random();
        protected int plus = 1;
        protected double plusminus = 0.5;
        protected double factor;

        public RandomBumper(double plusminus, int factor) {
            if (plusminus < 0.0 || plusminus > 1.0) {
                System.out.println(this.getClass().getName() + " ignores constructor-passed value. Must be between 0.0 and 1.0!");
            } else {
                this.plusminus = plusminus;
            }
            this.factor = factor;
            this.start();
        }

        public void run() {
            while (true) {
                double rand;
                this.number = (rand = this.randomizer.nextDouble()) < this.plusminus ? (this.number += this.randomizer.nextDouble() * this.factor) : (this.number -= this.randomizer.nextDouble() * this.factor);
                try {
                    RandomBumper.sleep(40L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

