/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.chart.demo;

import aw.gui.chart.AbstractDataCollector;
import aw.gui.chart.Chart2D;
import aw.gui.chart.RandomDataCollector;
import aw.gui.chart.Trace2DLtd;
import aw.gui.chart.demo.FileFilterExtensions;
import aw.util.Range;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class Showcase
extends JFrame {
    Chart2D chart = new Chart2D();
    AbstractDataCollector collector;
    Trace2DLtd trace;
    private boolean running = false;

    public Showcase() {
        this.chart.setGridX(true);
        this.chart.setDecimalsX(0);
        this.chart.setGridY(true);
        this.chart.setForceYRange(new Range(-20.0, 20.0));
        this.chart.setGridColor(Color.LIGHT_GRAY);
        this.trace = new Trace2DLtd(100);
        this.trace.setName("random");
        this.trace.setPhysicalUnits("Milliseconds", "random value");
        this.trace.setColor(Color.RED);
        this.chart.addTrace(this.trace);
        this.collector = new RandomDataCollector(this.trace, 60);
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(content, 1));
        content.add(this.chart);
        content.add(new ControlPanel());
        this.collector = new RandomDataCollector(this.trace, 50);
    }

    public synchronized void startData() {
        if (!this.running) {
            new Thread(this.collector).start();
            this.running = true;
        }
    }

    public synchronized void stopData() {
        if (this.running) {
            this.collector.stop();
            this.running = false;
        }
    }

    public static void main(String[] args) {
        Showcase frame = new Showcase();
        frame.setSize(400, 300);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.show();
    }

    class ControlPanel
    extends JPanel {
        JSlider amountPointsSlider;
        JSlider latencyTimeSlider;
        JButton startStop;
        JButton snapshot;
        JFileChooser filechooser;

        ControlPanel() {
            this.setBackground(Color.WHITE);
            this.amountPointsSlider = new JSlider(10, 410);
            this.amountPointsSlider.setBackground(Color.WHITE);
            int maxPoints = Showcase.this.trace.getMaxSize();
            this.amountPointsSlider.setValue(maxPoints);
            this.amountPointsSlider.setMajorTickSpacing(40);
            this.amountPointsSlider.setMinorTickSpacing(20);
            this.amountPointsSlider.setSnapToTicks(true);
            this.amountPointsSlider.setPaintLabels(true);
            this.amountPointsSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Amount of points.", 1, 3));
            this.amountPointsSlider.setPaintTicks(true);
            this.amountPointsSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (!source.getValueIsAdjusting()) {
                        int value = source.getValue();
                        ((ControlPanel)ControlPanel.this).Showcase.this.trace.setMaxSize(value);
                    }
                }
            });
            this.latencyTimeSlider = new JSlider(10, 210);
            this.latencyTimeSlider.setBackground(Color.WHITE);
            this.latencyTimeSlider.setValue((int)Showcase.this.collector.getLatency());
            this.latencyTimeSlider.setMajorTickSpacing(50);
            this.latencyTimeSlider.setMinorTickSpacing(10);
            this.latencyTimeSlider.setSnapToTicks(true);
            this.latencyTimeSlider.setPaintLabels(true);
            this.latencyTimeSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Latency for adding points.", 1, 3));
            this.latencyTimeSlider.setPaintTicks(true);
            this.latencyTimeSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (!source.getValueIsAdjusting()) {
                        int value = source.getValue();
                        ((ControlPanel)ControlPanel.this).Showcase.this.collector.setLatency(value);
                    }
                }
            });
            this.startStop = new JButton("start");
            this.startStop.setBackground(Color.WHITE);
            this.startStop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JButton source = (JButton)e.getSource();
                    if (Showcase.this.running) {
                        Showcase.this.stopData();
                        source.setText("start");
                    } else {
                        Showcase.this.startData();
                        source.setText("stop");
                    }
                    source.invalidate();
                    source.repaint();
                }
            });
            this.filechooser = new JFileChooser();
            this.filechooser.setAcceptAllFileFilterUsed(false);
            this.snapshot = new JButton("snapshot");
            this.snapshot.setBackground(Color.WHITE);
            this.snapshot.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Iterator<Object> itWriters;
                    BufferedImage img = ((ControlPanel)ControlPanel.this).Showcase.this.chart.snapShot();
                    FileFilter[] farr = ControlPanel.this.filechooser.getChoosableFileFilters();
                    for (int i = 0; i < farr.length; ++i) {
                        ControlPanel.this.filechooser.removeChoosableFileFilter(farr[i]);
                    }
                    String[] encodings = ImageIO.getWriterFormatNames();
                    TreeSet<String> writers = new TreeSet<String>();
                    ImageTypeSpecifier spec = ImageTypeSpecifier.createFromRenderedImage(img);
                    for (int i = 0; i < encodings.length; ++i) {
                        itWriters = ImageIO.getImageWriters(spec, encodings[i]);
                        if (!itWriters.hasNext()) continue;
                        writers.add(encodings[i].toLowerCase());
                    }
                    itWriters = writers.iterator();
                    while (itWriters.hasNext()) {
                        String encoding = (String)itWriters.next();
                        ControlPanel.this.filechooser.addChoosableFileFilter(new FileFilterExtensions(new String[]{encoding}));
                    }
                    int ret = ControlPanel.this.filechooser.showSaveDialog(Showcase.this);
                    if (ret == 0) {
                        File file = ControlPanel.this.filechooser.getSelectedFile();
                        String encoding = ControlPanel.this.filechooser.getFileFilter().getDescription().substring(2);
                        try {
                            ImageIO.write((RenderedImage)img, encoding, new File(file.getAbsolutePath() + "." + encoding));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.amountPointsSlider);
            this.add(this.latencyTimeSlider);
            JPanel stretch = new JPanel();
            stretch.setBackground(Color.WHITE);
            stretch.setLayout(new BoxLayout(stretch, 0));
            stretch.add(Box.createHorizontalGlue());
            stretch.add(this.startStop);
            stretch.add(Box.createHorizontalGlue());
            stretch.add(this.snapshot);
            stretch.add(Box.createHorizontalGlue());
            this.add(stretch);
        }
    }
}

