/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.chart.demo;

import aw.gui.chart.Chart2D;
import aw.gui.chart.ITrace2D;
import aw.gui.chart.Trace2DBijective;
import aw.gui.chart.Trace2DLtd;
import aw.gui.chart.Trace2DLtdReplacing;
import aw.gui.chart.Trace2DLtdSorted;
import aw.gui.chart.Trace2DReplacing;
import aw.gui.chart.Trace2DSimple;
import aw.gui.chart.Trace2DSorted;
import aw.gui.chart.TracePoint2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.JFrame;

public class TraceTester {
    public static void main(String[] args) {
        try {
            int j;
            int i;
            Class[] traces = new Class[]{Trace2DSimple.class, Trace2DBijective.class, Trace2DReplacing.class, Trace2DSorted.class, Trace2DLtd.class, Trace2DLtdReplacing.class, Trace2DLtdSorted.class};
            RandomPoints rand = new RandomPoints(0, 3, 0, 3);
            Chart2D test = new Chart2D();
            test.setDecimalsX(4);
            test.setDecimalsY(4);
            JFrame frame = new JFrame("TraceTester");
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.getContentPane().add(test);
            frame.setSize(600, 500);
            frame.setLocation(200, 200);
            frame.setVisible(true);
            ITrace2D current = null;
            for (i = 0; i < traces.length; ++i) {
                current = (ITrace2D)traces[i].newInstance();
                test.addTrace(current);
                frame.setTitle("TraceTester: full-random, current: " + traces[i].getName());
                for (j = 0; j < 200; ++j) {
                    current.addPoint(rand.nextPoint(current));
                    Thread.sleep(50L);
                }
                Thread.sleep(2000L);
                test.removeTrace(current);
            }
            rand = new HalfRandomPoints(0, 3, 0, 3);
            for (i = 0; i < traces.length; ++i) {
                current = (ITrace2D)traces[i].newInstance();
                test.addTrace(current);
                frame.setTitle("TraceTester: repeating x 10 times, current: " + traces[i].getName());
                for (j = 0; j < 200; ++j) {
                    current.addPoint(rand.nextPoint(current));
                    Thread.sleep(50L);
                }
                Thread.sleep(2000L);
                test.removeTrace(current);
            }
            System.exit(0);
        }
        catch (Throwable f) {
            f.printStackTrace();
            System.exit(0);
        }
    }

    static class HalfRandomPoints
    extends RandomPoints {
        double samexcount = 0.0;
        double oldx = 0.0;

        HalfRandomPoints(int minx, int maxx, int miny, int maxy) {
            super(minx, maxx, miny, maxy);
            this.oldx = (maxx - minx) / 2;
        }

        public TracePoint2D nextPoint(ITrace2D listener) {
            if (this.samexcount == 10.0) {
                this.samexcount = 0.0;
                this.oldx = this.rand.nextDouble() * this.xrange + this.xmin;
            }
            this.samexcount += 1.0;
            return new TracePoint2D(listener, this.oldx, this.rand.nextDouble() * this.yrange + this.ymin);
        }
    }

    static class RandomPoints {
        Random rand = new Random();
        double xmin;
        double xrange;
        double ymin;
        double yrange;

        RandomPoints(int minx, int maxx, int miny, int maxy) {
            if (minx >= maxx) {
                throw new IllegalArgumentException("minx>=maxx!");
            }
            if (miny >= maxy) {
                throw new IllegalArgumentException("miny>=maxy!");
            }
            this.xmin = minx;
            this.xrange = maxx - minx;
            this.ymin = miny;
            this.yrange = maxy - miny;
        }

        public TracePoint2D nextPoint(ITrace2D listener) {
            return new TracePoint2D(listener, this.rand.nextDouble() * this.xrange + this.xmin, this.rand.nextDouble() * this.yrange + this.ymin);
        }
    }
}

