/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.util;

import aw.gui.util.HSBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ColorIterator
implements Iterator {
    private HSBColor start = new HSBColor(0.0f, 1.0f, 1.0f);
    private HSBColor iterate = (HSBColor)this.start.clone();
    private SteppingModel stepModel = new HueStep(0.001f);
    private SteppingModel resetModel = (SteppingModel)this.stepModel.clone();
    private boolean hasnext = true;

    public boolean hasNext() {
        return this.hasnext;
    }

    public Object next() {
        if (!this.hasnext) {
            throw new NoSuchElementException("No more colors to give (call reset for new run!)");
        }
        this.stepModel.doStep(this);
        if (this.iterate.equals(this.start)) {
            this.hasnext = false;
        }
        return this.iterate.getRGBColor();
    }

    public void reset() {
        this.iterate = (HSBColor)this.start.clone();
        this.stepModel = (SteppingModel)this.resetModel.clone();
        this.hasnext = true;
    }

    public void remove() {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("ColorCircleIterator-test");
        JPanel panel = new JPanel(){
            private ColorIterator color = new ColorIterator();
            {
                int wdt = 0;
                while (this.color.hasNext()) {
                    ++wdt;
                    this.color.next();
                }
                System.out.println("found " + wdt + " different colors.");
                System.out.println("size: " + wdt);
                this.setSize(wdt, 100);
                this.setPreferredSize(new Dimension(wdt, 100));
                this.setMinimumSize(new Dimension(wdt, 100));
            }

            public void paint(Graphics g) {
                super.paint(g);
                this.color.reset();
                int width = this.getWidth();
                int height = this.getHeight();
                for (int pxdrawn = 0; this.color.hasNext() && pxdrawn != width; ++pxdrawn) {
                    g.setColor((Color)this.color.next());
                    g.drawLine(pxdrawn, 0, pxdrawn, height);
                }
            }
        };
        JScrollPane scroll = new JScrollPane(panel);
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)scroll, "Center");
        frame.setLocation(200, 200);
        frame.setSize(new Dimension(400, 100));
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setResizable(true);
        frame.setVisible(true);
    }

    public static class HSStepper
    extends PiggyBackStepper {
        public void doStep(ColorIterator tostep) {
            this.huestep.doStep(tostep);
            if (((ColorIterator)tostep).iterate.hue == ((ColorIterator)tostep).start.hue) {
                this.satstep.doStep(tostep);
            }
        }
    }

    public static class HSBStepper
    extends PiggyBackStepper {
        public void doStep(ColorIterator tostep) {
            this.huestep.doStep(tostep);
            if (((ColorIterator)tostep).iterate.hue == ((ColorIterator)tostep).start.hue) {
                this.satstep.doStep(tostep);
                if (((ColorIterator)tostep).iterate.sat == ((ColorIterator)tostep).start.sat) {
                    this.lumstep.doStep(tostep);
                }
            }
        }
    }

    public static abstract class PiggyBackStepper
    extends DefaultStepping {
        HueStep huestep;
        SaturationStep satstep;
        LuminanceStep lumstep;

        public PiggyBackStepper() throws IllegalArgumentException {
            this(0.002f, 0.2f, 0.2f);
        }

        public PiggyBackStepper(float hueStepping, float satStepping, float lumStepping) throws IllegalArgumentException {
            this.huestep = new HueStep(hueStepping);
            this.satstep = new SaturationStep(satStepping);
            this.lumstep = new LuminanceStep(lumStepping);
        }

        public Object clone() {
            PiggyBackStepper ret = (PiggyBackStepper)super.clone();
            ret.huestep = (HueStep)this.huestep.clone();
            ret.satstep = (SaturationStep)this.satstep.clone();
            ret.lumstep = (LuminanceStep)this.lumstep.clone();
            return ret;
        }
    }

    public static class SaturationStep
    extends DefaultStepping {
        public SaturationStep() throws IllegalArgumentException {
        }

        public SaturationStep(float stepping) throws IllegalArgumentException {
            super(stepping);
        }

        public void doStep(ColorIterator tostep) {
            float increment = ((ColorIterator)tostep).iterate.sat;
            float bound = ((ColorIterator)tostep).start.sat;
            if (increment == bound) {
                increment += this.stepping;
            } else if (increment < bound) {
                if ((increment += this.stepping) > bound) {
                    increment = bound;
                }
            } else if ((increment += this.stepping) > 1.0f && (increment = (float)((double)increment - 1.0)) > bound) {
                increment = bound;
            }
            ((ColorIterator)tostep).iterate.sat = increment;
        }
    }

    public static class LuminanceStep
    extends DefaultStepping {
        public LuminanceStep() throws IllegalArgumentException {
        }

        public LuminanceStep(float stepping) throws IllegalArgumentException {
            super(stepping);
        }

        public void doStep(ColorIterator tostep) {
            float increment = ((ColorIterator)tostep).iterate.lum;
            float bound = ((ColorIterator)tostep).start.lum;
            if (increment == bound) {
                increment += this.stepping;
            } else if (increment < bound) {
                if ((increment += this.stepping) > bound) {
                    increment = bound;
                }
            } else if ((increment += this.stepping) > 1.0f && (increment = (float)((double)increment - 1.0)) > bound) {
                increment = bound;
            }
            ((ColorIterator)tostep).iterate.lum = increment;
        }
    }

    public static class HueStep
    extends DefaultStepping {
        public HueStep() throws IllegalArgumentException {
        }

        public HueStep(float stepping) throws IllegalArgumentException {
            super(stepping);
        }

        public void doStep(ColorIterator tostep) {
            float increment = ((ColorIterator)tostep).iterate.hue;
            float bound = ((ColorIterator)tostep).start.hue;
            if (increment == bound) {
                increment += this.stepping;
            } else if (increment < bound) {
                if ((increment += this.stepping) > bound) {
                    increment = bound;
                }
            } else if ((increment += this.stepping) > 1.0f && (increment = (float)((double)increment - 1.0)) > bound) {
                increment = bound;
            }
            ((ColorIterator)tostep).iterate.hue = increment;
        }
    }

    public static abstract class DefaultStepping
    implements SteppingModel {
        protected float stepping;

        public DefaultStepping() throws IllegalArgumentException {
            this(0.01f);
        }

        public DefaultStepping(float stepping) throws IllegalArgumentException {
            if (stepping > 1.0f || stepping <= 0.0f) {
                throw new IllegalArgumentException("Illegal stepping param: choose between 0.1 and 1.0.");
            }
            this.stepping = stepping;
        }

        public Object clone() {
            try {
                DefaultStepping ret = (DefaultStepping)this.getClass().newInstance();
                ret.stepping = this.stepping;
                return ret;
            }
            catch (Throwable f) {
                f.printStackTrace();
                return null;
            }
        }
    }

    public static interface SteppingModel
    extends Cloneable {
        public void doStep(ColorIterator var1);

        public Object clone();
    }
}

