/*
 * Decompiled with CFR 0.152.
 */
package aw.gui.util;

import java.awt.Color;
import java.io.Serializable;

public class HSBColor
implements Serializable,
Cloneable {
    float hue;
    float sat;
    float lum;

    private HSBColor() {
    }

    HSBColor(float hue, float saturation, float brightness) {
        this.hue = hue;
        this.sat = saturation;
        this.lum = brightness;
    }

    public HSBColor(Color rgbcolor) {
        int cmax;
        int rgb = rgbcolor.getRGB();
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        int n = r >= g ? (r >= b ? r : b) : (cmax = g >= b ? g : b);
        int cmin = r <= g ? (r <= b ? r : b) : (g <= b ? g : b);
        this.lum = (float)cmax / 255.0f;
        if (cmax != cmin) {
            float difference = cmax - cmin;
            this.sat = difference / (float)cmax;
            this.hue = r == cmax ? (float)(g - b) / difference : (g == cmax ? (float)(b - r) / difference + 2.0f : (float)(r - g) / difference + 4.0f);
            this.hue /= 6.0f;
            if (this.hue < 0.0f) {
                this.hue += 1.0f;
            }
        } else {
            this.sat = 0.0f;
            this.hue = 0.0f;
        }
    }

    public static HSBColor RGBtoHSB(Color color) {
        int cmax;
        int rgb = color.getRGB();
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        HSBColor ret = new HSBColor();
        int n = r >= g ? (r >= b ? r : b) : (cmax = g >= b ? g : b);
        int cmin = r <= g ? (r <= b ? r : b) : (g <= b ? g : b);
        ret.lum = (float)cmax / 255.0f;
        if (cmax != cmin) {
            float difference = cmax - cmin;
            ret.sat = difference / (float)cmax;
            ret.hue = r == cmax ? (float)(g - b) / difference : (g == cmax ? (float)(b - r) / difference + 2.0f : (float)(r - g) / difference + 4.0f);
            ret.hue /= 6.0f;
            if (ret.hue < 0.0f) {
                ret.hue += 1.0f;
            }
        } else {
            ret.sat = 0.0f;
            ret.hue = 0.0f;
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HSBColor)) {
            return false;
        }
        HSBColor other = (HSBColor)o;
        return this.hue == other.hue && this.sat == other.sat && this.lum == other.lum;
    }

    public Color getRGBColor() {
        return new Color(Color.HSBtoRGB(this.hue, this.sat, this.lum));
    }

    public Object clone() {
        return new HSBColor(this.hue, this.sat, this.lum);
    }
}

