/*
 * Decompiled with CFR 0.152.
 */
package aw.reflection;

import aw.util.TimeStampedValue;
import aw.util.collections.IRingBuffer;
import aw.util.collections.RingBufferArrayFast;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.naming.directory.NoSuchAttributeException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ObjectRecorder
extends Thread {
    protected long interval;
    protected IRingBuffer buffer = new RingBufferArrayFast(100);
    protected Object toinspect;
    protected Field[] fields;
    protected EventListenerList changeListeners = new EventListenerList();
    protected static final boolean verbose = false;

    public ObjectRecorder(Object toinspect, long interval) {
        this.interval = interval;
        this.toinspect = toinspect;
        this.fields = toinspect.getClass().getDeclaredFields();
        this.start();
    }

    public Object getInspected() {
        return this.toinspect;
    }

    public void run() {
        while (true) {
            try {
                ObjectRecorder.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.inspect();
        }
    }

    public void inspect() {
        ObjectInspection newentry = new ObjectInspection(this);
        for (int i = 0; i < this.fields.length; ++i) {
            try {
                this.fields[i].setAccessible(true);
                newentry.add(this.fields[i].get(this.toinspect));
                continue;
            }
            catch (IllegalAccessException e) {
                String fieldname = this.fields[i].getName();
                char[] fieldnm = fieldname.toCharArray();
                fieldnm[0] = Character.toUpperCase(fieldnm[0]);
                fieldname = new String(fieldnm);
                String methodname = "get" + fieldname;
                try {
                    Method toinvoke = this.toinspect.getClass().getDeclaredMethod(methodname, new Class[0]);
                    newentry.add(toinvoke.invoke(this.toinspect, new Object[0]));
                    continue;
                }
                catch (NoSuchMethodException f) {
                    continue;
                }
                catch (SecurityException g) {
                    g.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException h) {
                    h.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException l) {
                    l.printStackTrace();
                }
            }
        }
        this.buffer.add(newentry);
        this.fireChange();
    }

    public String[] getAttributeNames() {
        String[] ret = new String[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            ret[i] = this.fields[i].getName();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeStampedValue[] getAttributeHistory(String attributeName) throws NoSuchAttributeException {
        int attribindex = -1;
        for (int i = this.fields.length - 1; i >= 0; --i) {
            if (!this.fields[i].getName().equals(attributeName)) continue;
            attribindex = i;
            break;
        }
        if (attribindex == -1) {
            throw new NoSuchAttributeException("The Attribute with the name: " + attributeName + " does not exist in " + this.toinspect.getClass().getName());
        }
        int stop = this.buffer.size();
        TimeStampedValue[] ret = new TimeStampedValue[stop];
        IRingBuffer iRingBuffer = this.buffer;
        synchronized (iRingBuffer) {
            Iterator it = this.buffer.iteratorF2L();
            int i = 0;
            while (it.hasNext()) {
                ObjectInspection tmp = (ObjectInspection)it.next();
                ret[i++] = new TimeStampedValue(tmp.getTime(), tmp.get(attribindex));
            }
        }
        return ret;
    }

    public TimeStampedValue getLastValue(String fieldname) throws NoSuchAttributeException {
        int attribindex = -1;
        for (int i = this.fields.length - 1; i >= 0; --i) {
            if (!this.fields[i].getName().equals(fieldname)) continue;
            attribindex = i;
            break;
        }
        if (attribindex == -1) {
            throw new NoSuchAttributeException("The Attribute with the name: " + fieldname + " does not exist in " + this.toinspect.getClass().getName());
        }
        ObjectInspection tmp = (ObjectInspection)this.buffer.getYoungest();
        return new TimeStampedValue(tmp.getTime(), tmp.get(attribindex));
    }

    public void setHistoryLength(int length) {
        this.buffer.setBufferSize(length);
    }

    public IRingBuffer getRingBuffer() {
        return this.buffer;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void addChangeListener(ChangeListener x) {
        this.changeListeners.add(ChangeListener.class, x);
    }

    public void removeChangeListener(ChangeListener x) {
        this.changeListeners.remove(ChangeListener.class, x);
    }

    protected void fireChange() {
        ChangeEvent ce = new ChangeEvent(this);
        Object[] listeners = this.changeListeners.getListenerList();
        for (int i = listeners.length - 1; i >= 0; i -= 2) {
            ChangeListener cl = (ChangeListener)listeners[i];
            cl.stateChanged(ce);
        }
    }

    public void setInterval(long sleeptime) {
        this.interval = sleeptime;
    }

    private class ObjectInspection {
        protected long time;
        LinkedList values;
        ObjectRecorder inspector;

        private ObjectInspection(ObjectRecorder inspector) {
            this.inspector = inspector;
            this.time = new Date().getTime();
            this.values = new LinkedList();
        }

        public void add(Object value) {
            this.values.add(value);
        }

        public void remove(Object value) {
            this.values.remove(value);
        }

        public Object get(int index) {
            return this.values.get(index);
        }

        public long getTime() {
            return this.time;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer("\nObjectInspection:\n");
            ret.append("-----------------\n");
            ret.append("Inspected: ").append(this.inspector.getInspected().toString()).append("\n");
            ret.append("time:      ").append(this.time).append("\n");
            Field[] field = this.inspector.fields;
            for (int i = ObjectRecorder.this.fields.length - 1; i >= 0; --i) {
                ret.append(ObjectRecorder.this.fields[i].getName()).append(": ").append(this.values.get(i).toString()).append("\n");
            }
            return ret.toString();
        }
    }
}

