/*
 * Decompiled with CFR 0.152.
 */
package aw.util;

import java.io.Serializable;

public class Range
implements Serializable {
    protected double min;
    protected double max;

    public Range(double min, double max) {
        if (min == Double.NaN) {
            throw new IllegalArgumentException("Cannot work on Double.NaN for min.");
        }
        if (max == Double.NaN) {
            throw new IllegalArgumentException("Cannot work on Double.NaN for min.");
        }
        if (min < max) {
            this.min = min;
            this.max = max;
        } else {
            this.min = max;
            this.max = min;
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getExtent() {
        return this.max - this.min;
    }

    public boolean ensureContained(double contain) {
        boolean ret = false;
        if (contain < this.min) {
            ret = true;
            this.min = contain;
        } else if (contain > this.max) {
            ret = true;
            this.max = contain;
        }
        return ret;
    }

    public boolean isContained(double contained) {
        return this.min <= contained && this.max >= contained;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("Range[");
        ret.append(this.min).append(',');
        ret.append(this.max).append(']');
        return ret.toString();
    }
}

