/*
 * Decompiled with CFR 0.152.
 */
package aw.util.collections;

import aw.util.StringUtil;
import aw.util.collections.RingBufferArrayFast;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class RingBufferArray
extends RingBufferArrayFast {
    protected List pendingremove = new LinkedList();

    public RingBufferArray(int aSize) {
        super(aSize);
    }

    public Object remove() {
        if (this.pendingremove.size() > 0) {
            return this.pendingremove.remove(0);
        }
        return super.remove();
    }

    public Object[] removeAll() {
        int i;
        Object[] ret = new Object[this.size() + this.pendingremove.size()];
        int stop = this.pendingremove.size();
        for (i = 0; i < stop; ++i) {
            ret[i] = this.pendingremove.remove(0);
        }
        while (i < ret.length) {
            ret[i] = this.remove();
            ++i;
        }
        return ret;
    }

    public void setBufferSize(int newSize) {
        int i;
        LinkedList<Object> newpending = null;
        if (this.size() > newSize) {
            newpending = new LinkedList<Object>();
            int stop = this.size();
            for (i = newSize; i < stop; ++i) {
                Object add = this.remove();
                newpending.add(add);
            }
        }
        Object[] newbuffer = new Object[newSize];
        i = 0;
        while (!this.isEmpty()) {
            newbuffer[i] = this.remove();
            ++i;
        }
        this.tailpointer = 0;
        this.headpointer = newSize == i ? 0 : i;
        this.buffer = newbuffer;
        this.size = newSize - 1;
        if (newpending != null) {
            this.pendingremove = newpending;
        }
    }

    public int size() {
        return super.size() + this.pendingremove.size();
    }

    public boolean isEmpty() {
        return super.isEmpty() && this.pendingremove.size() == 0;
    }

    public String toString() {
        int i;
        if (this.isEmpty()) {
            return "[]";
        }
        Object[] actualcontent = new Object[this.size()];
        int tmp = this.tailpointer;
        int stop = this.pendingremove.size();
        Iterator it = this.pendingremove.iterator();
        for (i = 0; i < stop; ++i) {
            actualcontent[i] = it.next();
        }
        while (i < actualcontent.length) {
            actualcontent[i] = this.buffer[tmp];
            tmp = tmp == this.size ? 0 : ++tmp;
            if (tmp == this.headpointer && this.empty) break;
            ++i;
        }
        return StringUtil.ArrayToString(actualcontent);
    }

    public Iterator iteratorL2F() {
        return new RingBufferIterator(this.empty){
            int pendmax;
            {
                this.pendmax = RingBufferArray.this.pendingremove.size();
                this.startpos = this.pos = RingBufferArray.this.tailpointer;
                this.pendpos = 0;
            }

            public Object next() {
                Object ret = null;
                if (this.pendpos < this.pendmax) {
                    ret = RingBufferArray.this.pendingremove.get(this.pendpos);
                    ++this.pendpos;
                    return ret;
                }
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ret = RingBufferArray.this.buffer[this.pos];
                this.pos = this.pos == this.size ? 0 : ++this.pos;
                if (this.pos == this.startpos) {
                    this.empty = true;
                }
                if (ret == null) {
                    System.out.println("RingBufferArray.iteratorL2F returns null: head:" + RingBufferArray.this.headpointer + " tail: " + RingBufferArray.this.tailpointer);
                }
                return ret;
            }
        };
    }

    public Iterator iteratorF2L() {
        return new RingBufferIterator(this.empty){
            boolean bufini;
            {
                this.bufini = false;
                this.startpos = this.pos = RingBufferArray.this.headpointer == 0 ? this.size : RingBufferArray.this.headpointer - 1;
                this.pendpos = RingBufferArray.this.pendingremove.size() - 1;
            }

            public Object next() {
                Object ret = null;
                if (this.bufini) {
                    ret = RingBufferArray.this.pendingremove.get(this.pendpos);
                    --this.pendpos;
                    if (this.pendpos < 0) {
                        this.empty = true;
                    }
                    if (ret == null) {
                        System.out.println("RingBufferArray.iteratorF2L returns null: head:" + RingBufferArray.this.headpointer + " tail: " + RingBufferArray.this.tailpointer);
                    }
                    return ret;
                }
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ret = RingBufferArray.this.buffer[this.pos];
                this.pos = this.pos == 0 ? this.size : --this.pos;
                if (this.pos == this.startpos) {
                    this.bufini = true;
                }
                return ret;
            }
        };
    }

    private abstract class RingBufferIterator
    extends RingBufferArrayFast.RingBufferIterator {
        int pendpos;

        RingBufferIterator(boolean empty) {
            super(RingBufferArray.this, empty);
        }
    }
}

