/*
 * Decompiled with CFR 0.152.
 */
package aw.util.collections;

import aw.util.StringUtil;
import aw.util.collections.IRingBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RingBufferArrayFast
implements Cloneable,
IRingBuffer {
    public static final boolean debug = false;
    protected Object[] buffer;
    protected int size;
    protected int headpointer = 0;
    protected int tailpointer = 0;
    protected boolean empty = true;

    public RingBufferArrayFast(int aSize) {
        this.buffer = new Object[aSize];
        this.size = aSize - 1;
    }

    public Object add(Object anObject) {
        Object ret = null;
        if (this.isFull()) {
            ret = this.buffer[this.tailpointer];
            this.incTail();
        }
        this.buffer[this.headpointer] = anObject;
        this.incHead();
        return ret;
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw IRingBuffer.BUFFER_EMPTY;
        }
        Object ret = null;
        ret = this.buffer[this.tailpointer];
        this.incTail();
        return ret;
    }

    public Object[] removeAll() {
        Object[] ret = new Object[this.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.remove();
        }
        return ret;
    }

    public Object getYoungest() throws IRingBuffer.RingBufferException {
        if (this.isEmpty()) {
            throw BUFFER_EMPTY;
        }
        int tmp = this.headpointer;
        tmp = tmp == 0 ? this.size : --tmp;
        return this.buffer[tmp];
    }

    public Object getOldest() throws IRingBuffer.RingBufferException {
        if (this.isEmpty()) {
            throw BUFFER_EMPTY;
        }
        return this.buffer[this.tailpointer];
    }

    public int getBufferSize() {
        return this.size + 1;
    }

    public void setBufferSize(int newSize) {
        int i;
        Object[] newbuffer = new Object[newSize];
        boolean emptyStore = this.empty;
        for (i = 0; i < newSize && !this.isEmpty(); ++i) {
            newbuffer[i] = this.remove();
        }
        this.tailpointer = 0;
        this.headpointer = newSize - 1 <= i ? 0 : i;
        this.buffer = newbuffer;
        this.size = newSize - 1;
        this.empty = emptyStore;
    }

    public int size() {
        if (this.empty) {
            return 0;
        }
        if (this.headpointer == this.tailpointer) {
            return this.size + 1;
        }
        if (this.headpointer > this.tailpointer) {
            return this.headpointer - this.tailpointer;
        }
        return this.headpointer + this.size + 1 - this.tailpointer;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isFull() {
        boolean ret = this.headpointer == this.tailpointer && !this.empty;
        return ret;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        Object[] actualcontent = new Object[this.size()];
        int tmp = this.tailpointer;
        for (int i = 0; i < actualcontent.length; ++i) {
            actualcontent[i] = this.buffer[tmp];
            tmp = tmp == this.size ? 0 : ++tmp;
            if (tmp == this.headpointer && this.empty) break;
        }
        return StringUtil.ArrayToString(actualcontent);
    }

    private void incHead() {
        this.headpointer = this.headpointer == this.size ? 0 : ++this.headpointer;
        this.empty = false;
    }

    private void incTail() {
        this.tailpointer = this.tailpointer == this.size ? 0 : ++this.tailpointer;
        if (this.tailpointer == this.headpointer) {
            this.empty = true;
        }
    }

    public Iterator iteratorL2F() {
        return new RingBufferIterator(this.empty){
            {
                this.startpos = this.pos = RingBufferArrayFast.this.tailpointer;
            }

            public Object next() {
                Object ret = null;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ret = RingBufferArrayFast.this.buffer[this.pos];
                this.pos = this.pos == this.size ? 0 : ++this.pos;
                if (this.pos == this.startpos) {
                    this.empty = true;
                }
                if (ret == null) {
                    System.out.println("RingBufferArrayFast.iteratorL2F returns null: pos:" + this.pos + " startpos: " + this.startpos);
                }
                return ret;
            }
        };
    }

    public Iterator iteratorF2L() {
        return new RingBufferIterator(this.empty){
            {
                this.startpos = this.pos = RingBufferArrayFast.this.headpointer == 0 ? this.size : RingBufferArrayFast.this.headpointer - 1;
            }

            public Object next() {
                Object ret = null;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ret = RingBufferArrayFast.this.buffer[this.pos];
                this.pos = this.pos == 0 ? this.size : --this.pos;
                if (this.pos == this.startpos) {
                    this.empty = true;
                }
                if (ret == null) {
                    System.out.println("RingBufferArrayFast.iteratorF2L returns null: pos:" + this.pos + " startpos: " + this.startpos);
                }
                return ret;
            }
        };
    }

    protected abstract class RingBufferIterator
    implements Iterator {
        int pos;
        int startpos;
        int size;
        boolean empty;

        RingBufferIterator(boolean empty) {
            this.size = RingBufferArrayFast.this.size() - 1;
            this.empty = empty;
        }

        public boolean hasNext() {
            return !this.empty;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

