/*
 * Decompiled with CFR 0.152.
 */
package aw.util.math;

public class IntegerReuseable {
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final ArithmeticException OVERFLOW = new ArithmeticException("Overflow detected. Value saved unchanged.");
    public static final ArithmeticException CARRY = new ArithmeticException("Carry detected. Value saved unchanged.");
    private int value;

    public IntegerReuseable(int value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int intValue() {
        return this.value;
    }

    public int getValue() {
        return this.value;
    }

    public void add(int i) throws ArithmeticException {
        int oldval = this.value;
        this.value += i;
        if (oldval > this.value) {
            this.value = oldval;
            throw OVERFLOW;
        }
    }

    public void add(Integer i) throws ArithmeticException {
        this.add((int)i);
    }

    public void add(IntegerReuseable i) throws ArithmeticException {
        this.add(i.getValue());
    }

    public void sub(int i) throws ArithmeticException {
        int oldval = this.value;
        this.value -= i;
        if (oldval < this.value) {
            this.value = oldval;
            throw CARRY;
        }
    }

    public void sub(Integer i) throws ArithmeticException {
        this.sub((int)i);
    }

    public void sub(IntegerReuseable i) throws ArithmeticException {
        this.sub(i.intValue());
    }
}

