/*
 * Decompiled with CFR 0.152.
 */
package aw.util.math;

import aw.util.math.Object3D;
import aw.util.math.Object3DCombined;
import aw.util.math.Point3D;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Line3D
implements Object3D {
    double gradeY;
    double gradeZ;
    double offsetY;
    double offsetZ;
    Point3D start;
    Point3D end;

    public Line3D(Point3D start, Point3D end) {
        if (start.equals(end)) {
            throw new IllegalArgumentException("Given arguments are a Point not a line!");
        }
        if (start.x < end.x) {
            this.start = start;
            this.end = end;
        } else {
            this.end = start;
            this.start = end;
        }
        this.gradeY = (this.end.y - this.start.y) / (this.end.x - this.start.x);
        this.gradeZ = (this.end.z - this.start.z) / (this.end.x - this.start.x);
        this.offsetY = this.start.y - this.gradeY * this.start.x;
        this.offsetZ = this.start.z - this.gradeZ * this.start.x;
    }

    public boolean isContained(Object3D subspace) {
        if (!(subspace instanceof Point3D)) {
            return false;
        }
        Point3D test = (Point3D)subspace;
        if (test.y != test.x * this.gradeY + this.offsetY) {
            return false;
        }
        if (test.z != test.x * this.gradeZ + this.offsetZ) {
            return false;
        }
        return !(test.x > this.end.x);
    }

    public boolean isIntersect(Object3D cutspace) {
        Object3D test = this.intersection(cutspace);
        return test != Object3DVoid;
    }

    public boolean isUnion(Object3D space) {
        return this.equals(space);
    }

    public Object3D union(Object3D space) {
        if (this.isContained(space)) {
            return this;
        }
        if (space.isContained(this)) {
            return space;
        }
        if (space instanceof Line3D) {
            Line3D other = (Line3D)space;
            if (other.gradeY == this.gradeY && other.gradeZ == this.gradeZ && other.offsetY == this.offsetY && other.offsetZ == this.offsetZ) {
                if (this.start.x <= other.start.x && this.end.x >= other.start.x) {
                    return new Line3D(this.start, other.end);
                }
                if (this.start.x <= other.end.x && this.end.x >= other.end.x) {
                    return new Line3D(other.start, this.end);
                }
            }
        }
        return new Object3DCombined(this).union(space);
    }

    public Object3D intersection(Object3D space) {
        double cutxyX = 0.0;
        double cutxzX = 0.0;
        if (space instanceof Point3D) {
            Point3D other = (Point3D)space;
            if (this.gradeY * other.x + this.offsetY == other.y && this.gradeZ * other.x + this.offsetZ == other.z) {
                return (Object3D)other.clone();
            }
            return Object3DVoid;
        }
        if (space instanceof Line3D) {
            Line3D test = (Line3D)space;
            if (test.gradeY == this.gradeY && this.offsetY != test.offsetY) {
                return Object3DVoid;
            }
            if (test.gradeZ == this.gradeZ && this.offsetZ != test.offsetZ) {
                return Object3DVoid;
            }
            cutxyX = (this.offsetY - test.offsetY) / (test.gradeY - this.gradeY);
            cutxzX = (this.offsetZ - test.offsetZ) / (test.gradeZ - this.gradeZ);
            if (cutxyX == Double.NaN) {
                if (cutxzX == Double.NaN) {
                    if (!(this.end.x < test.start.x) && !(this.start.x > test.end.x)) {
                        Point3D startx = this.start.x > test.start.x ? this.start : test.start;
                        Point3D endx = this.end.x < test.end.x ? this.end : test.end;
                        return new Line3D(startx, endx);
                    }
                    return Object3DVoid;
                }
                if (cutxzX >= this.start.x && cutxzX <= this.end.x && cutxzX >= test.start.x && cutxzX <= test.end.x) {
                    return new Point3D(cutxzX, this.gradeY * cutxzX + this.offsetY, this.gradeZ * cutxzX + this.offsetZ);
                }
                return Object3DVoid;
            }
            if (cutxzX == Double.NaN) {
                if (cutxyX >= this.start.x && cutxyX <= this.end.x && cutxyX >= test.start.x && cutxyX <= test.end.x) {
                    return new Point3D(cutxyX, cutxyX * this.gradeY + this.offsetY, cutxyX * this.gradeZ + this.offsetZ);
                }
                return Object3DVoid;
            }
            if (cutxyX == cutxzX && cutxyX >= this.start.x && cutxyX <= this.end.x && cutxyX >= test.start.x && cutxyX <= test.end.x) {
                return new Point3D(cutxyX, cutxyX * this.gradeY + this.offsetY, cutxyX * this.gradeZ + this.offsetZ);
            }
            return Object3DVoid;
        }
        return space.intersection(this);
    }

    public Object3D getCenter() {
        return new Point3D((this.start.x + this.end.x) / 2.0, (this.start.y + this.end.y) * 2.0, (this.start.z + this.end.z) / 2.0);
    }

    public Iterator iterator() {
        return new Iterator(){
            private int cnt = 0;

            public boolean hasNext() {
                return this.cnt < 2;
            }

            public Object next() {
                switch (this.cnt) {
                    case 0: {
                        ++this.cnt;
                        return Line3D.this.start;
                    }
                    case 1: {
                        ++this.cnt;
                        return Line3D.this.end;
                    }
                }
                throw new NoSuchElementException("Read a tutorial about usage of java.util.Iterator!");
            }

            public void remove() {
                throw new UnsupportedOperationException("This would force  to morph the type of this Object3D.");
            }
        };
    }

    public Object clone() {
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Line3D)) {
            return false;
        }
        Line3D test = (Line3D)o;
        return test.start.equals(this.start) && test.end.equals(this.end);
    }

    public String toString() {
        return "Line3D from " + this.start.toString() + " to " + this.end.toString();
    }

    public static void main(String[] args) {
        Point3D p1 = new Point3D(0.0, 0.0, 0.0);
        Point3D p2 = new Point3D(4.0, 4.0, 4.0);
        Line3D l1 = new Line3D(p1, p2);
        Point3D p3 = new Point3D(0.0, 4.0, 4.0);
        Point3D p4 = new Point3D(4.0, 0.0, 0.0);
        Line3D l2 = new Line3D(p3, p4);
        System.out.println("p1: " + p1);
        System.out.println("p2: " + p2);
        System.out.println("l1: " + l1);
        System.out.println("l1.intersection(p2): " + l1.intersection(p2));
        System.out.println("p2.intersection(l1): " + p2.intersection(l1));
        System.out.println("l2: " + l2);
        System.out.println("l2.intersection(l1): " + l2.intersection(l1));
        System.out.println("l1.intersection(l2): " + l1.intersection(l2));
        System.out.println("Object3D c1 = l1.union(l2)");
        Object3D c1 = l1.union(l2);
        System.out.println("c1: \n" + c1.toString());
        System.out.println("p1.union(p4): \n" + p1.union(p4));
        System.out.println("c1.intersection(p1.union(p4))");
        System.out.println(c1.intersection(p1.union(p4)));
        System.out.println("c1.union(p3):\n" + c1.union(p3));
    }
}

