/*
 * Decompiled with CFR 0.152.
 */
package aw.util.math;

import aw.util.math.Line3D;
import aw.util.math.Object3D;
import aw.util.math.Point3D;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class Object3DCombined
implements Object3D {
    private List clients = new LinkedList();

    public Object3DCombined() {
    }

    public Object3DCombined(Object3D first) {
        this.clients.add(first);
    }

    public boolean isContained(Object3D subspace) {
        java.util.Iterator it = this.clients.iterator();
        while (it.hasNext()) {
            if (!((Object3D)it.next()).isContained(subspace)) continue;
            return true;
        }
        return false;
    }

    public boolean isIntersect(Object3D cutspace) {
        java.util.Iterator it = this.clients.iterator();
        while (it.hasNext()) {
            if (!((Object3D)it.next()).isIntersect(cutspace)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnion(Object3D space) {
        java.util.Iterator it = this.clients.iterator();
        while (it.hasNext()) {
            if (!((Object3D)it.next()).isUnion(space)) continue;
            return true;
        }
        return false;
    }

    public Object3D union(Object3D space) {
        Object3D tmp;
        java.util.Iterator it = this.clients.iterator();
        while (it.hasNext()) {
            tmp = (Object3D)it.next();
            if (!tmp.isContained(space)) continue;
            return this;
        }
        if (!(space instanceof Line3D) && !(space instanceof Point3D)) {
            it = this.clients.iterator();
            while (it.hasNext()) {
                tmp = (Object3D)it.next();
                if (!space.isContained(tmp)) continue;
                it.remove();
            }
        }
        if (space instanceof Object3DCombined) {
            it = ((Object3DCombined)space).clients.iterator();
            while (it.hasNext()) {
                this.clients.add(it.next());
            }
        } else {
            this.clients.add(space);
        }
        return this;
    }

    public Object3D intersection(Object3D space) {
        Object3DCombined combined = new Object3DCombined();
        java.util.Iterator it = this.clients.iterator();
        while (it.hasNext()) {
            Object3D tmp = ((Object3D)it.next()).intersection(space);
            if (tmp == Object3DVoid) continue;
            combined.union(tmp);
        }
        return combined;
    }

    public Object3D getCenter() {
        Point3D ret = new Point3D(0.0, 0.0, 0.0);
        int cnt = 0;
        java.util.Iterator it = this.iterator();
        while (it.hasNext()) {
            Object3D tmpcast = ((Object3D)it.next()).getCenter();
            if (tmpcast == Object3DVoid) continue;
            Point3D tmp = (Point3D)tmpcast;
            ret.x += tmp.x;
            ret.y += tmp.y;
            ret.z += tmp.z;
            ++cnt;
        }
        if (cnt != 0) {
            ret.x /= (double)cnt;
            ret.y /= (double)cnt;
            ret.z /= (double)cnt;
            return ret;
        }
        return Object3DVoid;
    }

    public java.util.Iterator iterator() {
        return new Iterator();
    }

    public Object clone() {
        java.util.Iterator it = this.clients.iterator();
        Object3DCombined ret = new Object3DCombined();
        while (it.hasNext()) {
            ret.clients.add(it.next());
        }
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("combined space:\n");
        java.util.Iterator it = this.clients.iterator();
        while (it.hasNext()) {
            ret.append("   ").append(it.next().toString()).append("\n");
        }
        return ret.toString();
    }

    private class Iterator
    implements java.util.Iterator {
        private java.util.Iterator clientsit;
        private java.util.Iterator pointer;

        private Iterator() {
            this.clientsit = Object3DCombined.this.clients.iterator();
            this.pointer = null;
            if (this.clientsit.hasNext()) {
                this.pointer = ((Object3D)this.clientsit.next()).iterator();
            }
        }

        public boolean hasNext() {
            if (this.pointer.hasNext()) {
                return true;
            }
            return this.clientsit.hasNext();
        }

        public Object next() {
            if (this.pointer.hasNext()) {
                return this.pointer.next();
            }
            if (this.clientsit.hasNext()) {
                this.pointer = ((Object3D)this.clientsit.next()).iterator();
            }
            if (this.pointer.hasNext()) {
                return this.pointer.next();
            }
            throw new NoSuchElementException("Read a tutorial about usage of java.util.Iterator!");
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

