/*
 * Decompiled with CFR 0.152.
 */
package aw.util.math;

import aw.util.math.Object3D;
import aw.util.math.Object3DCombined;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Point3D
implements Object3D {
    protected double x;
    protected double y;
    protected double z;

    public Point3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Object3D intersection(Object3D space) {
        if (space instanceof Point3D) {
            if (((Object)space).equals(this)) {
                return (Object3D)this.clone();
            }
            return Object3DVoid;
        }
        if (space.isContained(this)) {
            return (Object3D)this.clone();
        }
        return Object3DVoid;
    }

    public Object3D union(Object3D space) {
        if (space instanceof Point3D && ((Object)space).equals(this)) {
            return (Object3D)this.clone();
        }
        if (space.isContained(this)) {
            try {
                return (Object3D)space.clone();
            }
            catch (CloneNotSupportedException e) {
                return space;
            }
        }
        Object3DCombined ret = new Object3DCombined((Object3D)this.clone());
        ret.union(space);
        return ret;
    }

    public boolean isContained(Object3D subspace) {
        return ((Object)subspace).equals(this);
    }

    public boolean isIntersect(Object3D cutspace) {
        if (cutspace instanceof Point3D) {
            return ((Object)cutspace).equals(this);
        }
        return cutspace.isContained(this);
    }

    public boolean isUnion(Object3D space) {
        if (space instanceof Point3D) {
            return ((Object)space).equals(this);
        }
        return false;
    }

    public Object3D getCenter() {
        return (Object3D)this.clone();
    }

    public Iterator iterator() {
        return new Iterator(){
            private boolean unfinished = true;

            public boolean hasNext() {
                return this.unfinished;
            }

            public Object next() {
                if (this.unfinished) {
                    this.unfinished = false;
                    return Point3D.this;
                }
                throw new NoSuchElementException("If hasNext returns false, you should not try to continue!");
            }

            public void remove() {
                throw new UnsupportedOperationException("This is a single Point3D. Nothing left to remove!");
            }
        };
    }

    public Object clone() {
        return new Point3D(this.x, this.y, this.z);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

