/*
 * Decompiled with CFR 0.152.
 */
package aw.util.units;

public abstract class Unit {
    public double factor;
    protected String prefix;
    protected int decimals = 2;

    public double getValue(double value) {
        return this.round(value / this.factor);
    }

    public String getLabel(double value) {
        return this.round(value / this.factor) + " " + this.prefix;
    }

    public String getLabel() {
        return this.prefix;
    }

    public String toString() {
        return this.getLabel();
    }

    public double getFactor() {
        return this.factor;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setDecimals(int aftercomma) {
        if (aftercomma >= 0) {
            this.decimals = aftercomma;
        }
    }

    public int getDecimals() {
        return this.decimals;
    }

    public double round(double value) {
        double tmp = Math.pow(10.0, this.decimals);
        return Math.floor(value * tmp + 0.5) / tmp;
    }
}

