/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import proguard.ArgumentWordReader;
import proguard.ClassMemberSpecification;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationConstants;
import proguard.FileWordReader;
import proguard.ParseException;
import proguard.WordReader;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public class ConfigurationParser {
    private WordReader reader;
    private String nextWord;
    private String lastComments;

    public ConfigurationParser(String[] stringArray) throws IOException {
        this.reader = new ArgumentWordReader(stringArray);
        this.readNextWord();
    }

    public ConfigurationParser(String string) throws IOException {
        this.reader = new FileWordReader(string);
        this.readNextWord();
    }

    public ConfigurationParser(URL uRL) throws IOException {
        this.reader = new FileWordReader(uRL);
        this.readNextWord();
    }

    public void parse(Configuration configuration) throws ParseException, IOException {
        while (this.nextWord != null) {
            this.lastComments = this.reader.lastComments();
            if ("@".startsWith(this.nextWord) || "-include".startsWith(this.nextWord)) {
                this.parseIncludeArgument();
                continue;
            }
            if ("-injars".startsWith(this.nextWord)) {
                configuration.programJars = this.parseClassPathArgument(configuration.programJars, false);
                continue;
            }
            if ("-outjars".startsWith(this.nextWord)) {
                configuration.programJars = this.parseClassPathArgument(configuration.programJars, true);
                continue;
            }
            if ("-libraryjars".startsWith(this.nextWord)) {
                configuration.libraryJars = this.parseClassPathArgument(configuration.libraryJars, false);
                continue;
            }
            if ("-resourcejars".startsWith(this.nextWord)) {
                throw new ParseException("The '-resourcejars' option is no longer supported. Please use the '-injars' option for all input");
            }
            if ("-dontskipnonpubliclibraryclasses".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClasses = this.parseNoArgument(false);
                continue;
            }
            if ("-dontskipnonpubliclibraryclassmembers".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClassMembers = this.parseNoArgument(false);
                continue;
            }
            if ("-keep".startsWith(this.nextWord)) {
                configuration.keep = this.parseClassSpecificationArguments(configuration.keep, true, false);
                continue;
            }
            if ("-keepclassmembers".startsWith(this.nextWord)) {
                configuration.keep = this.parseClassSpecificationArguments(configuration.keep, false, false);
                continue;
            }
            if ("-keepclasseswithmembers".startsWith(this.nextWord)) {
                configuration.keep = this.parseClassSpecificationArguments(configuration.keep, false, true);
                continue;
            }
            if ("-keepnames".startsWith(this.nextWord)) {
                configuration.keepNames = this.parseClassSpecificationArguments(configuration.keepNames, true, false);
                continue;
            }
            if ("-keepclassmembernames".startsWith(this.nextWord)) {
                configuration.keepNames = this.parseClassSpecificationArguments(configuration.keepNames, false, false);
                continue;
            }
            if ("-keepclasseswithmembernames".startsWith(this.nextWord)) {
                configuration.keepNames = this.parseClassSpecificationArguments(configuration.keepNames, false, true);
                continue;
            }
            if ("-printseeds".startsWith(this.nextWord)) {
                configuration.printSeeds = this.parseOptionalArgument();
                continue;
            }
            if ("-dontshrink".startsWith(this.nextWord)) {
                configuration.shrink = this.parseNoArgument(false);
                continue;
            }
            if ("-printusage".startsWith(this.nextWord)) {
                configuration.printUsage = this.parseOptionalArgument();
                continue;
            }
            if ("-dontoptimize".startsWith(this.nextWord)) {
                configuration.optimize = this.parseNoArgument(false);
                continue;
            }
            if ("-assumenosideeffects".startsWith(this.nextWord)) {
                configuration.assumeNoSideEffects = this.parseClassSpecificationArguments(configuration.assumeNoSideEffects, false, false);
                continue;
            }
            if ("-allowaccessmodification".startsWith(this.nextWord)) {
                configuration.allowAccessModification = this.parseNoArgument(true);
                continue;
            }
            if ("-dontobfuscate".startsWith(this.nextWord)) {
                configuration.obfuscate = this.parseNoArgument(false);
                continue;
            }
            if ("-printmapping".startsWith(this.nextWord)) {
                configuration.printMapping = this.parseOptionalArgument();
                continue;
            }
            if ("-applymapping".startsWith(this.nextWord)) {
                configuration.applyMapping = this.parseOptionalArgument();
                continue;
            }
            if ("-obfuscationdictionary".startsWith(this.nextWord)) {
                configuration.obfuscationDictionary = this.parseObfuscationDictionaryArgument();
                continue;
            }
            if ("-overloadaggressively".startsWith(this.nextWord)) {
                configuration.overloadAggressively = this.parseNoArgument(true);
                continue;
            }
            if ("-defaultpackage".startsWith(this.nextWord)) {
                configuration.defaultPackage = ClassUtil.internalClassName(this.parseOptionalArgument());
                continue;
            }
            if ("-dontusemixedcaseclassnames".startsWith(this.nextWord)) {
                configuration.useMixedCaseClassNames = this.parseNoArgument(false);
                continue;
            }
            if ("-keepattributes".startsWith(this.nextWord)) {
                configuration.keepAttributes = this.parseKeepAttributesArguments(configuration.keepAttributes);
                continue;
            }
            if ("-renamesourcefileattribute".startsWith(this.nextWord)) {
                configuration.newSourceFileAttribute = this.parseOptionalArgument();
                continue;
            }
            if ("-verbose".startsWith(this.nextWord)) {
                configuration.verbose = this.parseNoArgument(true);
                continue;
            }
            if ("-dontnote".startsWith(this.nextWord)) {
                configuration.note = this.parseNoArgument(false);
                continue;
            }
            if ("-dontwarn".startsWith(this.nextWord)) {
                configuration.warn = this.parseNoArgument(false);
                continue;
            }
            if ("-ignorewarnings".startsWith(this.nextWord)) {
                configuration.ignoreWarnings = this.parseNoArgument(true);
                continue;
            }
            if ("-dump".startsWith(this.nextWord)) {
                configuration.dump = this.parseOptionalArgument();
                continue;
            }
            throw new ParseException("Unknown configuration " + this.reader.locationDescription());
        }
    }

    private void parseIncludeArgument() throws ParseException, IOException {
        this.readNextWord("configuration file name");
        this.reader.includeWordReader(new FileWordReader(this.replaceSystemProperties(this.nextWord)));
        this.readNextWord();
    }

    private ClassPath parseClassPathArgument(ClassPath classPath, boolean bl) throws ParseException, IOException {
        if (classPath == null) {
            classPath = new ClassPath();
        }
        do {
            this.readNextWord("jar or directory name");
            ClassPathEntry classPathEntry = new ClassPathEntry(this.replaceSystemProperties(this.nextWord), bl);
            this.readNextWord();
            if (!this.configurationEnd() && "(".equals(this.nextWord)) {
                String[] stringArray = new String[5];
                int n = 0;
                do {
                    stringArray[n++] = ListUtil.commaSeparatedString(this.parseCommaSeparatedList(false, true));
                } while (n < stringArray.length && ";".equals(this.nextWord));
                if (!")".equals(this.nextWord)) {
                    throw new ParseException("Expecting separating ',' or ';', or closing ')' before " + this.reader.locationDescription());
                }
                classPathEntry.setFilter(stringArray[--n]);
                if (n > 0) {
                    classPathEntry.setJarFilter(stringArray[--n]);
                    if (n > 0) {
                        classPathEntry.setWarFilter(stringArray[--n]);
                        if (n > 0) {
                            classPathEntry.setEarFilter(stringArray[--n]);
                            if (n > 0) {
                                classPathEntry.setZipFilter(stringArray[--n]);
                            }
                        }
                    }
                }
                this.readNextWord();
            }
            classPath.add(classPathEntry);
            if (!this.configurationEnd()) continue;
            return classPath;
        } while (this.nextWord.equals(ConfigurationConstants.JAR_SEPARATOR_KEYWORD));
        throw new ParseException("Expecting class path separator '" + ConfigurationConstants.JAR_SEPARATOR_KEYWORD + "' before " + this.reader.locationDescription());
    }

    private List parseKeepAttributesArguments(List arrayList) throws ParseException, IOException {
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        this.readNextWord();
        if (this.configurationEnd()) {
            arrayList.clear();
            return arrayList;
        }
        if (this.nextWord.equals("*")) {
            arrayList.clear();
            this.readNextWord();
            return arrayList;
        }
        while (true) {
            arrayList.add(this.nextWord);
            this.readNextWord();
            if (this.configurationEnd()) break;
            if (!this.nextWord.equals(",")) {
                throw new ParseException("Expecting attribute name separator ',' before " + this.reader.locationDescription());
            }
            this.readNextWord("attribute name");
        }
        return arrayList;
    }

    private String parseObfuscationDictionaryArgument() throws ParseException, IOException {
        this.readNextWord("obfuscation dictionary name");
        String string = this.replaceSystemProperties(this.nextWord);
        this.readNextWord();
        return string;
    }

    private String parseOptionalArgument() throws IOException {
        this.readNextWord();
        if (this.configurationEnd()) {
            return "";
        }
        String string = this.nextWord;
        this.readNextWord();
        return string;
    }

    private boolean parseNoArgument(boolean bl) throws IOException {
        this.readNextWord();
        return bl;
    }

    private List parseClassSpecificationArguments(List arrayList, boolean bl, boolean bl2) throws ParseException, IOException {
        if (arrayList == null) {
            arrayList = new ArrayList<ClassSpecification>();
        }
        arrayList.add(this.parseClassSpecificationArguments(bl, bl2));
        return arrayList;
    }

    private ClassSpecification parseClassSpecificationArguments(boolean bl, boolean bl2) throws ParseException, IOException {
        String string;
        String string2 = this.lastComments;
        int n = 0;
        int n2 = 0;
        do {
            int n3;
            this.readNextWord("keyword 'class' or 'interface'");
            if ("class".equals(this.nextWord)) break;
            String string3 = string = this.nextWord.startsWith("!") ? this.nextWord.substring(1) : this.nextWord;
            int n4 = string.equals("public") ? 1 : (string.equals("final") ? 16 : (string.equals("interface") ? 512 : (n3 = string.equals("abstract") ? 1024 : this.unknownAccessFlag())));
            if (string == this.nextWord) {
                n |= n3;
            } else {
                n2 |= n3;
            }
            if ((n & n2) == 0) continue;
            throw new ParseException("Conflicting class access modifiers for '" + string + "' before " + this.reader.locationDescription());
        } while (!"interface".equals(string));
        this.readNextWord("class name or interface name");
        this.checkJavaIdentifier("class name or interface name");
        string = this.nextWord;
        String string4 = "*".equals(string) ? null : ClassUtil.internalClassName(string);
        this.readNextWord();
        String string5 = null;
        if (!this.configurationEnd() && ("implements".equals(this.nextWord) || "extends".equals(this.nextWord))) {
            this.readNextWord("class name or interface name");
            this.checkJavaIdentifier("class name or interface name");
            string5 = ClassUtil.internalClassName(this.nextWord);
            this.readNextWord();
        }
        ClassSpecification classSpecification = new ClassSpecification(n, n2, string4, string5, bl, bl2, string2);
        if (!this.configurationEnd()) {
            if (!"{".equals(this.nextWord)) {
                throw new ParseException("Expecting opening '{' at " + this.reader.locationDescription());
            }
            while (this.parseClassMemberSpecificationArguments(string, classSpecification)) {
            }
        }
        return classSpecification;
    }

    private boolean parseClassMemberSpecificationArguments(String string, ClassSpecification classSpecification) throws ParseException, IOException {
        String string2;
        int n;
        int n2;
        block20: {
            n2 = 0;
            n = 0;
            do {
                int n3;
                this.readNextWord("class member description or closing '}'");
                if (n2 == 0 && n == 0 && "}".equals(this.nextWord)) {
                    this.readNextWord();
                    return false;
                }
                String string3 = string2 = this.nextWord.startsWith("!") ? this.nextWord.substring(1) : this.nextWord;
                int n4 = string2.equals("public") ? 1 : (string2.equals("private") ? 2 : (string2.equals("protected") ? 4 : (string2.equals("static") ? 8 : (string2.equals("final") ? 16 : (string2.equals("synchronized") ? 32 : (string2.equals("volatile") ? 64 : (string2.equals("transient") ? 128 : (string2.equals("native") ? 256 : (string2.equals("abstract") ? 1024 : (n3 = string2.equals("strictfp") ? 2048 : 0))))))))));
                if (n3 == 0) break block20;
                if (string2 == this.nextWord) {
                    n2 |= n3;
                    continue;
                }
                n |= n3;
            } while ((n2 & n) == 0);
            throw new ParseException("Conflicting class member access modifiers for " + this.reader.locationDescription());
        }
        if ("*".equals(this.nextWord) || "<fields>".equals(this.nextWord) || "<methods>".equals(this.nextWord)) {
            if ("*".equals(this.nextWord)) {
                this.checkFieldAccessFlags(n2, n);
                this.checkMethodAccessFlags(n2, n);
                classSpecification.addField(new ClassMemberSpecification(n2, n, null, null));
                classSpecification.addMethod(new ClassMemberSpecification(n2, n, null, null));
            } else if ("<fields>".equals(this.nextWord)) {
                this.checkFieldAccessFlags(n2, n);
                classSpecification.addField(new ClassMemberSpecification(n2, n, null, null));
            } else if ("<methods>".equals(this.nextWord)) {
                this.checkMethodAccessFlags(n2, n);
                classSpecification.addMethod(new ClassMemberSpecification(n2, n, null, null));
            }
            this.readNextWord("separator ';'");
            if (!";".equals(this.nextWord)) {
                throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
            }
        } else {
            this.checkJavaIdentifier("class member type");
            string2 = this.nextWord;
            this.readNextWord("class member name");
            String string4 = this.nextWord;
            if ("(".equals(string4)) {
                if (!(string2.equals("<init>") || string2.equals(string) || string2.equals(ClassUtil.externalShortClassName(string)))) {
                    throw new ParseException("Expecting type and name instead of just '" + string2 + "' before " + this.reader.locationDescription());
                }
                string2 = "void";
                string4 = "<init>";
            } else {
                this.checkJavaIdentifier("class member name");
                this.readNextWord("opening '(' or separator ';'");
            }
            if (";".equals(this.nextWord)) {
                this.checkFieldAccessFlags(n2, n);
                String string5 = ClassUtil.internalType(string2);
                classSpecification.addField(new ClassMemberSpecification(n2, n, string4, string5));
            } else if ("(".equals(this.nextWord)) {
                this.checkMethodAccessFlags(n2, n);
                String string6 = ClassUtil.internalMethodDescriptor(string2, this.parseCommaSeparatedList(true, false));
                if (!")".equals(this.nextWord)) {
                    throw new ParseException("Expecting separating ',' or closing ')' before " + this.reader.locationDescription());
                }
                this.readNextWord("separator ';'");
                if (!";".equals(this.nextWord)) {
                    throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
                }
                classSpecification.addMethod(new ClassMemberSpecification(n2, n, string4, string6));
            } else {
                throw new ParseException("Expecting opening '(' or separator ';' before " + this.reader.locationDescription());
            }
        }
        return true;
    }

    private List parseCommaSeparatedList(boolean bl, boolean bl2) throws ParseException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            this.readNextWord("argument");
            if (arrayList.size() == 0 && (")".equals(this.nextWord) || ";".equals(this.nextWord))) break;
            if (bl) {
                this.checkJavaIdentifier("argument type");
            }
            if (bl2) {
                this.nextWord = this.replaceSystemProperties(this.nextWord);
            }
            arrayList.add(this.nextWord);
            this.readNextWord("separating ',' or closing ')'");
        } while (",".equals(this.nextWord));
        return arrayList;
    }

    private int unknownAccessFlag() throws ParseException {
        throw new ParseException("Unexpected keyword " + this.reader.locationDescription());
    }

    private String replaceSystemProperties(String string) throws ParseException {
        int n = 0;
        while ((n = string.indexOf(60, n)) >= 0) {
            int n2 = string.indexOf(62, n + 1);
            if (n2 < 0) {
                throw new ParseException("Expecting closing '>' after opening '<' in " + this.reader.locationDescription());
            }
            String string2 = string.substring(n + 1, n2);
            String string3 = System.getProperty(string2);
            if (string3 == null) {
                throw new ParseException("Value of system property '" + string2 + "' is undefined in " + this.reader.locationDescription());
            }
            string = string.substring(0, n) + string3 + string.substring(n2 + 1);
        }
        return string;
    }

    private void readNextWord(String string) throws ParseException, IOException {
        this.readNextWord();
        if (this.configurationEnd()) {
            throw new ParseException("Expecting " + string + " before " + this.reader.locationDescription());
        }
    }

    private void readNextWord() throws IOException {
        this.nextWord = this.reader.nextWord();
    }

    private boolean configurationEnd() {
        return this.nextWord == null || this.nextWord.startsWith("-") || this.nextWord.equals("@");
    }

    private void checkJavaIdentifier(String string) throws ParseException {
        if (!this.isJavaIdentifier(this.nextWord)) {
            throw new ParseException("Expecting " + string + " before " + this.reader.locationDescription());
        }
    }

    private boolean isJavaIdentifier(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '[' || c == ']' || c == '<' || c == '>' || c == '*' || c == '?' || c == '%') continue;
            return false;
        }
        return true;
    }

    private void checkFieldAccessFlags(int n, int n2) throws ParseException {
        if (((n | n2) & 0xFFFFAF20) != 0) {
            throw new ParseException("Invalid method access modifier for field before " + this.reader.locationDescription());
        }
    }

    private void checkMethodAccessFlags(int n, int n2) throws ParseException {
        if (((n | n2) & 0xFFFFE200) != 0) {
            throw new ParseException("Invalid field access modifier for method before " + this.reader.locationDescription());
        }
    }

    public static void main(String[] stringArray) {
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(stringArray);
            configurationParser.parse(new Configuration());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

