/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.DataEntryReaderFactory;
import proguard.DataEntryWriterFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.AllAttrInfoVisitor;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.MultiAttrInfoVisitor;
import proguard.classfile.editor.CodeAttrInfoEditor;
import proguard.classfile.editor.CodeAttrInfoEditorResetter;
import proguard.classfile.editor.ConstantPoolSorter;
import proguard.classfile.instruction.AllInstructionVisitor;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.MultiInstructionVisitor;
import proguard.classfile.util.ClassFileHierarchyInitializer;
import proguard.classfile.util.ClassFileReferenceInitializer;
import proguard.classfile.visitor.AllCpInfoVisitor;
import proguard.classfile.visitor.AllMemberInfoVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.BottomClassFileFilter;
import proguard.classfile.visitor.ClassFileCleaner;
import proguard.classfile.visitor.ClassFileHierarchyTraveler;
import proguard.classfile.visitor.ClassFilePrinter;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.LibraryClassFileFilter;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.classfile.visitor.MultiClassFileVisitor;
import proguard.classfile.visitor.MultiClassPoolVisitor;
import proguard.classfile.visitor.ProgramClassFileFilter;
import proguard.classfile.visitor.ProgramMemberInfoFilter;
import proguard.classfile.visitor.ReferencedClassFileVisitor;
import proguard.classfile.visitor.SimpleClassFilePrinter;
import proguard.io.ClassFileFilter;
import proguard.io.ClassFileReader;
import proguard.io.ClassFileRewriter;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryPump;
import proguard.obfuscate.AttributeShrinker;
import proguard.obfuscate.AttributeUsageMarker;
import proguard.obfuscate.ClassFileObfuscator;
import proguard.obfuscate.ClassFileRenamer;
import proguard.obfuscate.MappingKeeper;
import proguard.obfuscate.MappingPrinter;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;
import proguard.obfuscate.MemberInfoLinker;
import proguard.obfuscate.MemberInfoObfuscator;
import proguard.obfuscate.MultiMappingProcessor;
import proguard.obfuscate.NameAndTypeShrinker;
import proguard.obfuscate.NameAndTypeUsageMarker;
import proguard.obfuscate.NameMarker;
import proguard.obfuscate.Utf8Shrinker;
import proguard.obfuscate.Utf8UsageMarker;
import proguard.optimize.KeepMarker;
import proguard.optimize.NoSideEffectMethodMarker;
import proguard.optimize.SideEffectMethodMarker;
import proguard.optimize.WriteOnlyFieldMarker;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.peephole.BranchTargetFinder;
import proguard.optimize.peephole.ClassFileFinalizer;
import proguard.optimize.peephole.GetterSetterInliner;
import proguard.optimize.peephole.GotoReturnReplacer;
import proguard.optimize.peephole.LoadStoreRemover;
import proguard.optimize.peephole.NopRemover;
import proguard.optimize.peephole.PushPopRemover;
import proguard.optimize.peephole.SingleImplementationInliner;
import proguard.optimize.peephole.SingleImplementationMarker;
import proguard.optimize.peephole.StoreLoadReplacer;
import proguard.shrink.ClassFileShrinker;
import proguard.shrink.InnerUsageMarker;
import proguard.shrink.InterfaceUsageMarker;
import proguard.shrink.UsageMarker;
import proguard.shrink.UsagePrinter;
import proguard.shrink.UsedClassFileFilter;

public class ProGuard {
    public static final String VERSION = "ProGuard, version 3.1";
    private Configuration configuration;
    private ClassPool programClassPool = new ClassPool();
    private ClassPool libraryClassPool = new ClassPool();

    public ProGuard(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute() throws IOException {
        System.out.println(VERSION);
        this.readInput();
        if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate) {
            this.initialize();
        }
        if (this.configuration.printSeeds != null) {
            this.printSeeds();
        }
        if (this.configuration.shrink) {
            this.shrink();
        }
        if (this.configuration.optimize) {
            this.optimize();
            if (this.configuration.shrink) {
                this.configuration.printUsage = null;
                this.shrink();
            }
        }
        if (this.configuration.obfuscate) {
            this.obfuscate();
        }
        if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate) {
            this.sortConstantPools();
        }
        if (this.configuration.programJars.hasOutput()) {
            this.writeOutput();
        }
        if (this.configuration.dump != null) {
            this.dump();
        }
    }

    private void readInput() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Reading jars...");
        }
        if (this.configuration.programJars == null) {
            throw new IOException("The input is empty. You have to specify one or more '-injars' options.");
        }
        this.readInput("Reading program ", this.configuration.programJars, this.createDataEntryClassPoolFiller(false));
        if (this.programClassPool.size() == 0) {
            throw new IOException("The input doesn't contain any class files. Did you specify the proper '-injars' options?");
        }
        if (this.configuration.libraryJars != null) {
            this.readInput("Reading library ", this.configuration.libraryJars, this.createDataEntryClassPoolFiller(true));
        }
        if (this.configuration.defaultPackage != null) {
            this.configuration.allowAccessModification = true;
        }
    }

    private DataEntryReader createDataEntryClassPoolFiller(boolean bl) {
        ClassPool classPool = bl ? this.libraryClassPool : this.programClassPool;
        return new ClassFileFilter(new ClassFileReader(bl, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, new ClassPoolFiller(classPool, this.configuration.note)));
    }

    private void readInput(String string, ClassPath classPath, DataEntryReader dataEntryReader) throws IOException {
        this.readInput(string, classPath, 0, classPath.size(), dataEntryReader);
    }

    private void readInput(String string, ClassPath classPath, int n, int n2, DataEntryReader dataEntryReader) throws IOException {
        for (int i = n; i < n2; ++i) {
            ClassPathEntry classPathEntry = classPath.get(i);
            if (classPathEntry.isOutput()) continue;
            this.readInput(string, classPathEntry, dataEntryReader);
        }
    }

    private void readInput(String string, ClassPathEntry classPathEntry, DataEntryReader dataEntryReader) throws IOException {
        try {
            DataEntryReader dataEntryReader2 = DataEntryReaderFactory.createDataEntryReader(string, classPathEntry, dataEntryReader);
            DirectoryPump directoryPump = new DirectoryPump(new File(classPathEntry.getName()));
            directoryPump.pumpDataEntries(dataEntryReader2);
        }
        catch (IOException iOException) {
            throw new IOException("Can't read [" + classPathEntry + "] (" + iOException.getMessage() + ")");
        }
    }

    private void initialize() throws IOException {
        int n;
        int n2;
        ClassFileHierarchyInitializer classFileHierarchyInitializer = new ClassFileHierarchyInitializer(this.programClassPool, this.libraryClassPool, this.configuration.warn);
        this.programClassPool.classFilesAccept(classFileHierarchyInitializer);
        ClassFileHierarchyInitializer classFileHierarchyInitializer2 = new ClassFileHierarchyInitializer(this.programClassPool, this.libraryClassPool, false);
        this.libraryClassPool.classFilesAccept(classFileHierarchyInitializer2);
        ClassFileReferenceInitializer classFileReferenceInitializer = new ClassFileReferenceInitializer(this.programClassPool, this.libraryClassPool, this.configuration.warn, this.configuration.note);
        this.programClassPool.classFilesAccept(classFileReferenceInitializer);
        int n3 = classFileReferenceInitializer.getNoteCount();
        if (n3 > 0) {
            System.err.println("Note: there were " + n3 + " class casts of dynamically created class instances.");
            System.err.println("      You might consider explicitly keeping the mentioned classes and/or");
            System.err.println("      their implementations (using '-keep').");
        }
        if ((n2 = classFileHierarchyInitializer.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n2 + " unresolved references to superclasses or interfaces.");
            System.err.println("         You may need to specify additional library jars (using '-libraryjars'),");
            System.err.println("         or perhaps the '-dontskipnonpubliclibraryclasses' option.");
        }
        if ((n = classFileReferenceInitializer.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n + " unresolved references to program class members.");
            System.err.println("         Your input class files appear to be inconsistent.");
            System.err.println("         You may need to recompile them and try again.");
        }
        if (!(n2 <= 0 && n <= 0 || this.configuration.ignoreWarnings)) {
            System.err.println("         If you are sure the mentioned classes are not used anyway,");
            System.err.println("         you could try your luck using the '-ignorewarnings' option.");
            throw new IOException("Please correct the above warnings first.");
        }
        if (this.configuration.verbose) {
            System.out.println("Removing unused library classes...");
            System.out.println("    Original number of library classes: " + this.libraryClassPool.size());
        }
        ClassPool classPool = new ClassPool();
        this.programClassPool.classFilesAccept(new AllCpInfoVisitor(new ReferencedClassFileVisitor(new LibraryClassFileFilter(new ClassFileHierarchyTraveler(true, true, true, false, new LibraryClassFileFilter(new ClassPoolFiller(classPool, false)))))));
        this.libraryClassPool = classPool;
        if (this.configuration.verbose) {
            System.out.println("    Final number of library classes:    " + this.libraryClassPool.size());
        }
    }

    private void printSeeds() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing kept classes, fields, and methods...");
        }
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        PrintStream printStream = this.configuration.printSeeds.length() > 0 ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.printSeeds))) : System.out;
        SimpleClassFilePrinter simpleClassFilePrinter = new SimpleClassFilePrinter(false, printStream);
        ClassPoolVisitor classPoolVisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, (ClassFileVisitor)new ProgramClassFileFilter(simpleClassFilePrinter), (MemberInfoVisitor)new ProgramMemberInfoFilter(simpleClassFilePrinter));
        this.programClassPool.accept(classPoolVisitor);
        this.libraryClassPool.accept(classPoolVisitor);
        if (printStream != System.out) {
            printStream.close();
        }
    }

    private void shrink() throws IOException {
        Object object;
        if (this.configuration.verbose) {
            System.out.println("Shrinking...");
        }
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        ClassFileCleaner classFileCleaner = new ClassFileCleaner();
        this.programClassPool.classFilesAccept(classFileCleaner);
        this.libraryClassPool.classFilesAccept(classFileCleaner);
        UsageMarker usageMarker = new UsageMarker();
        ClassPoolVisitor classPoolVisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, (ClassFileVisitor)usageMarker, (MemberInfoVisitor)usageMarker);
        this.programClassPool.accept(classPoolVisitor);
        this.libraryClassPool.accept(classPoolVisitor);
        this.programClassPool.classFilesAccept(new InterfaceUsageMarker());
        this.programClassPool.classFilesAccept(new InnerUsageMarker());
        if (this.configuration.printUsage != null) {
            if (this.configuration.verbose) {
                System.out.println("Printing usage" + (this.configuration.printUsage.length() > 0 ? " to [" + this.configuration.printUsage + "]" : "..."));
            }
            object = this.configuration.printUsage.length() > 0 ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.printUsage))) : System.out;
            this.programClassPool.classFilesAcceptAlphabetically(new UsagePrinter(true, (PrintStream)object));
            if (object != System.out) {
                ((PrintStream)object).close();
            }
        }
        if (this.configuration.verbose) {
            System.out.println("Removing unused program classes and class elements...");
            System.out.println("    Original number of program classes: " + this.programClassPool.size());
        }
        object = new ClassPool();
        this.programClassPool.classFilesAccept(new UsedClassFileFilter(new MultiClassFileVisitor(new ClassFileVisitor[]{new ClassFileShrinker(1024), new ClassPoolFiller((ClassPool)object, false)})));
        this.programClassPool = object;
        if (this.configuration.verbose) {
            System.out.println("    Final number of program classes:    " + this.programClassPool.size());
        }
        if (this.programClassPool.size() == 0) {
            throw new IOException("The output jar is empty. Did you specify the proper '-keep' options?");
        }
    }

    private void optimize() throws IOException {
        Object object;
        Object object2;
        if (this.configuration.verbose) {
            System.out.println("Optimizing...");
        }
        ClassFileCleaner classFileCleaner = new ClassFileCleaner();
        this.programClassPool.classFilesAccept(classFileCleaner);
        this.libraryClassPool.classFilesAccept(classFileCleaner);
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the optimization step.");
        }
        KeepMarker keepMarker = new KeepMarker();
        ClassPoolVisitor classPoolVisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, (ClassFileVisitor)keepMarker, (MemberInfoVisitor)keepMarker);
        this.programClassPool.accept(classPoolVisitor);
        this.libraryClassPool.accept(classPoolVisitor);
        this.programClassPool.classFilesAccept(new ClassFileFinalizer());
        this.programClassPool.classFilesAccept(new AllMethodVisitor(new AllAttrInfoVisitor(new AllInstructionVisitor(new WriteOnlyFieldMarker()))));
        if (this.configuration.assumeNoSideEffects != null) {
            object2 = new NoSideEffectMethodMarker();
            object = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.assumeNoSideEffects, null, (MemberInfoVisitor)object2);
            this.programClassPool.accept((ClassPoolVisitor)object);
            this.libraryClassPool.accept((ClassPoolVisitor)object);
        }
        this.programClassPool.accept(new SideEffectMethodMarker());
        this.programClassPool.classFilesAccept(new SingleImplementationMarker(this.configuration.allowAccessModification));
        this.programClassPool.classFilesAccept(new AllMethodVisitor(new AllAttrInfoVisitor(new SingleImplementationInliner())));
        this.programClassPool.classFilesAccept(new AllMemberInfoVisitor(new SingleImplementationInliner()));
        this.programClassPool.classFilesAccept(new AllMethodVisitor(new PartialEvaluator()));
        object2 = new BranchTargetFinder(1024);
        object = new CodeAttrInfoEditor(1024);
        this.programClassPool.classFilesAccept(new AllMethodVisitor(new AllAttrInfoVisitor(new MultiAttrInfoVisitor(new AttrInfoVisitor[]{object2, new CodeAttrInfoEditorResetter((CodeAttrInfoEditor)object), new AllInstructionVisitor(new MultiInstructionVisitor(new InstructionVisitor[]{new PushPopRemover((BranchTargetFinder)object2, (CodeAttrInfoEditor)object), new LoadStoreRemover((BranchTargetFinder)object2, (CodeAttrInfoEditor)object), new StoreLoadReplacer((BranchTargetFinder)object2, (CodeAttrInfoEditor)object), new GotoReturnReplacer((CodeAttrInfoEditor)object), new NopRemover((CodeAttrInfoEditor)object), new GetterSetterInliner((CodeAttrInfoEditor)object, this.configuration.allowAccessModification)})), object}))));
    }

    private void obfuscate() throws IOException {
        Object object;
        Object object2;
        if (this.configuration.verbose) {
            System.out.println("Obfuscating...");
        }
        if (this.configuration.keep == null && this.configuration.keepNames == null) {
            throw new IOException("You have to specify '-keep' options for the obfuscation step.");
        }
        ClassFileCleaner classFileCleaner = new ClassFileCleaner();
        this.programClassPool.classFilesAccept(classFileCleaner);
        this.libraryClassPool.classFilesAccept(classFileCleaner);
        this.programClassPool.classFilesAccept(new BottomClassFileFilter(new MemberInfoLinker()));
        NameMarker nameMarker = new NameMarker();
        MultiClassPoolVisitor multiClassPoolVisitor = new MultiClassPoolVisitor(new ClassPoolVisitor[]{ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, (ClassFileVisitor)nameMarker, (MemberInfoVisitor)nameMarker), ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keepNames, (ClassFileVisitor)nameMarker, (MemberInfoVisitor)nameMarker)});
        this.programClassPool.accept(multiClassPoolVisitor);
        this.libraryClassPool.accept(multiClassPoolVisitor);
        if (this.configuration.applyMapping != null) {
            if (this.configuration.verbose) {
                System.out.println("Applying mapping [" + this.configuration.applyMapping + "]");
            }
            object2 = new MappingReader(this.configuration.applyMapping);
            object = new MultiMappingProcessor(new MappingProcessor[]{new MappingKeeper(this.programClassPool), new MappingKeeper(this.libraryClassPool)});
            ((MappingReader)object2).pump((MappingProcessor)object);
        }
        object2 = new AttributeUsageMarker();
        if (this.configuration.keepAttributes != null) {
            if (this.configuration.keepAttributes.size() != 0) {
                ((AttributeUsageMarker)object2).setKeepAttributes(this.configuration.keepAttributes);
            } else {
                ((AttributeUsageMarker)object2).setKeepAllAttributes();
            }
        }
        this.programClassPool.classFilesAccept((ClassFileVisitor)object2);
        this.programClassPool.classFilesAccept(new AttributeShrinker());
        if (this.configuration.verbose) {
            System.out.println("Renaming program classes and class elements...");
        }
        this.programClassPool.classFilesAccept(new ClassFileObfuscator(this.programClassPool, this.configuration.defaultPackage, this.configuration.useMixedCaseClassNames));
        this.programClassPool.classFilesAccept(new BottomClassFileFilter(new MemberInfoObfuscator(this.configuration.overloadAggressively, this.configuration.obfuscationDictionary)));
        if (this.configuration.printMapping != null) {
            if (this.configuration.verbose) {
                System.out.println("Printing mapping" + (this.configuration.printMapping.length() > 0 ? " to [" + this.configuration.printMapping + "]" : "..."));
            }
            object = this.configuration.printMapping.length() > 0 ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.printMapping))) : System.out;
            this.programClassPool.classFilesAcceptAlphabetically(new MappingPrinter((PrintStream)object));
            if (object != System.out) {
                ((PrintStream)object).close();
            }
        }
        this.programClassPool.classFilesAccept(new ClassFileRenamer(this.configuration.defaultPackage != null, this.configuration.newSourceFileAttribute));
        this.programClassPool.classFilesAccept(new NameAndTypeUsageMarker());
        this.programClassPool.classFilesAccept(new NameAndTypeShrinker(1024));
        this.programClassPool.classFilesAccept(new Utf8UsageMarker());
        this.programClassPool.classFilesAccept(new Utf8Shrinker(1024));
    }

    private void sortConstantPools() {
        this.programClassPool.classFilesAccept(new ConstantPoolSorter(1024));
    }

    private void writeOutput() throws IOException {
        ClassPathEntry classPathEntry;
        int n;
        int n2;
        ClassPath classPath;
        ClassPathEntry classPathEntry2;
        if (this.configuration.verbose) {
            System.out.println("Writing jars...");
        }
        if ((classPathEntry2 = (classPath = this.configuration.programJars).get(0)).isOutput()) {
            throw new IOException("The output jar [" + classPathEntry2.getName() + "] must be specified after an input jar, or it will be empty.");
        }
        for (n2 = 0; n2 < classPath.size() - 1; ++n2) {
            ClassPathEntry classPathEntry3 = classPath.get(n2);
            if (!classPathEntry3.isOutput()) continue;
            if (classPathEntry3.getFilter() == null && classPathEntry3.getJarFilter() == null && classPathEntry3.getWarFilter() == null && classPathEntry3.getEarFilter() == null && classPathEntry3.getZipFilter() == null && classPath.get(n2 + 1).isOutput()) {
                throw new IOException("The output jar [" + classPathEntry3.getName() + "] must have a filter, or all subsequent jars will be empty.");
            }
            for (n = 0; n < classPath.size(); ++n) {
                classPathEntry = classPath.get(n);
                if (classPathEntry.isOutput() || !classPathEntry3.getName().equals(classPathEntry.getName())) continue;
                throw new IOException("The output jar [" + classPathEntry3.getName() + "] must be different from all input jars.");
            }
        }
        n2 = 0;
        int n3 = 0;
        for (n = 0; n < classPath.size(); ++n) {
            classPathEntry = classPath.get(n);
            if (!classPathEntry.isOutput()) {
                n3 = n;
                continue;
            }
            int n4 = n + 1;
            if (n4 != classPath.size() && classPath.get(n4).isOutput()) continue;
            this.writeOutput(classPath, n2, n3 + 1, n4);
            n2 = n4;
        }
    }

    private void writeOutput(ClassPath classPath, int n, int n2, int n3) throws IOException {
        try {
            DataEntryWriter dataEntryWriter = DataEntryWriterFactory.createDataEntryWriter(classPath, n2, n3);
            ClassFileFilter classFileFilter = new ClassFileFilter(new ClassFileRewriter(this.programClassPool, dataEntryWriter), new DataEntryCopier(dataEntryWriter));
            this.readInput("Copying resources from program ", classPath, n, n2, classFileFilter);
            dataEntryWriter.close();
        }
        catch (IOException iOException) {
            throw new IOException("Can't write [" + classPath.get(n2).getName() + "] (" + iOException.getMessage() + ")");
        }
    }

    private void dump() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing classes" + (this.configuration.dump.length() > 0 ? " to [" + this.configuration.dump + "]" : "..."));
        }
        PrintStream printStream = this.configuration.dump.length() > 0 ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.dump))) : System.out;
        this.programClassPool.classFilesAccept(new ClassFilePrinter(printStream));
        if (this.configuration.dump.length() > 0) {
            printStream.close();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: java proguard.ProGuard [options ...]");
            System.exit(1);
        }
        Configuration configuration = new Configuration();
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(stringArray);
            configurationParser.parse(configuration);
            ProGuard proGuard = new ProGuard(configuration);
            proGuard.execute();
        }
        catch (Exception exception) {
            if (configuration.verbose) {
                exception.printStackTrace();
            } else {
                System.err.println("Error: " + exception.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

