/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.IOException;

public abstract class WordReader {
    private static final char COMMENT_CHARACTER = '#';
    private WordReader includeWordReader;
    private String currentLine;
    private int currentLineLength;
    private int currentIndex;
    private String currentWord;
    private String currentComments;

    public void includeWordReader(WordReader wordReader) {
        if (this.includeWordReader == null) {
            this.includeWordReader = wordReader;
        } else {
            this.includeWordReader.includeWordReader(wordReader);
        }
    }

    public String nextWord() throws IOException {
        int n;
        char c;
        int n2;
        this.currentWord = null;
        if (this.includeWordReader != null) {
            this.currentWord = this.includeWordReader.nextWord();
            if (this.currentWord != null) {
                return this.currentWord;
            }
            this.includeWordReader = null;
        }
        while (this.currentLine != null && this.currentIndex < this.currentLineLength && Character.isWhitespace(this.currentLine.charAt(this.currentIndex))) {
            ++this.currentIndex;
        }
        while (this.currentLine == null || this.currentIndex == this.currentLineLength) {
            this.currentLine = this.nextLine();
            if (this.currentLine == null) {
                return null;
            }
            n2 = this.currentLine.indexOf(35);
            if (n2 >= 0) {
                this.currentLineLength = n2;
                String string = this.currentLine.substring(n2 + 1);
                this.currentComments = this.currentComments == null ? string : this.currentComments + '\n' + string;
            } else {
                this.currentLineLength = this.currentLine.length();
            }
            this.currentIndex = 0;
            while (this.currentIndex < this.currentLineLength && Character.isWhitespace(this.currentLine.charAt(this.currentIndex))) {
                ++this.currentIndex;
            }
        }
        if (this.isDelimiter(c = this.currentLine.charAt(n2 = this.currentIndex++))) {
            n = this.currentIndex;
        } else if (this.isQuote(c)) {
            ++n2;
            do {
                ++this.currentIndex;
                if (this.currentIndex != this.currentLineLength) continue;
                this.currentWord = this.currentLine.substring(n2 - 1, this.currentIndex);
                throw new IOException("Missing closing quote for " + this.locationDescription());
            } while (this.currentLine.charAt(this.currentIndex) != c);
            n = this.currentIndex++;
        } else {
            char c2;
            while (this.currentIndex < this.currentLineLength && !this.isDelimiter(c2 = this.currentLine.charAt(this.currentIndex)) && !Character.isWhitespace(c2)) {
                ++this.currentIndex;
            }
            n = this.currentIndex;
        }
        this.currentWord = this.currentLine.substring(n2, n);
        return this.currentWord;
    }

    public String lastComments() throws IOException {
        if (this.includeWordReader == null) {
            String string = this.currentComments;
            this.currentComments = null;
            return string;
        }
        return this.includeWordReader.lastComments();
    }

    public String locationDescription() {
        return (this.includeWordReader == null ? (this.currentWord == null ? "end of " : "'" + this.currentWord + "' in ") : this.includeWordReader.locationDescription() + ",\n" + "  included from ") + this.lineLocationDescription();
    }

    protected abstract String nextLine() throws IOException;

    protected abstract String lineLocationDescription();

    private boolean isDelimiter(char c) {
        return c == '@' || c == '{' || c == '}' || c == '(' || c == ')' || c == ',' || c == ';' || c == File.pathSeparatorChar;
    }

    private boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }
}

