/*
 * Decompiled with CFR 0.152.
 */
package proguard.ant;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import proguard.ConfigurationParser;
import proguard.ParseException;
import proguard.ProGuard;
import proguard.ant.ConfigurationTask;
import proguard.classfile.util.ClassUtil;

public class ProGuardTask
extends ConfigurationTask {
    public void setConfiguration(File file) throws BuildException {
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(file.getPath());
            configurationParser.parse(this.configuration);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException.getMessage());
        }
        catch (ParseException parseException) {
            throw new BuildException(parseException.getMessage());
        }
    }

    public void setOutjar(String string) {
        throw new BuildException("Use the <outjar> nested element instead of the 'outjar' attribute");
    }

    public void setSkipnonpubliclibraryclasses(boolean bl) {
        this.configuration.skipNonPublicLibraryClasses = bl;
    }

    public void setSkipnonpubliclibraryclassmembers(boolean bl) {
        this.configuration.skipNonPublicLibraryClassMembers = bl;
    }

    public void setPrintseeds(File file) {
        this.configuration.printSeeds = this.optionalFileName(file);
    }

    public void setShrink(boolean bl) {
        this.configuration.shrink = bl;
    }

    public void setPrintusage(File file) {
        this.configuration.printUsage = this.optionalFileName(file);
    }

    public void setOptimize(boolean bl) {
        this.configuration.optimize = bl;
    }

    public void setAllowaccessmodification(boolean bl) {
        this.configuration.allowAccessModification = bl;
    }

    public void setObfuscate(boolean bl) {
        this.configuration.obfuscate = bl;
    }

    public void setPrintmapping(File file) {
        this.configuration.printMapping = this.optionalFileName(file);
    }

    public void setApplymapping(String string) {
        this.configuration.applyMapping = string;
    }

    public void setObfuscationdictionary(File file) {
        this.configuration.obfuscationDictionary = file.getName();
    }

    public void setOverloadaggressively(boolean bl) {
        this.configuration.overloadAggressively = bl;
    }

    public void setDefaultpackage(String string) {
        this.configuration.defaultPackage = ClassUtil.internalClassName(string);
    }

    public void setUsemixedcaseclassnames(boolean bl) {
        this.configuration.useMixedCaseClassNames = bl;
    }

    public void setRenamesourcefileattribute(String string) {
        this.configuration.newSourceFileAttribute = string;
    }

    public void setVerbose(boolean bl) {
        this.configuration.verbose = bl;
    }

    public void setNote(boolean bl) {
        this.configuration.note = bl;
    }

    public void setWarn(boolean bl) {
        this.configuration.warn = bl;
    }

    public void setIgnorewarnings(boolean bl) {
        this.configuration.ignoreWarnings = bl;
    }

    public void setDump(File file) {
        this.configuration.dump = this.optionalFileName(file);
    }

    public void execute() throws BuildException {
        try {
            ProGuard proGuard = new ProGuard(this.configuration);
            proGuard.execute();
        }
        catch (IOException iOException) {
            throw new BuildException(iOException.getMessage());
        }
    }

    private String optionalFileName(File file) {
        String string = file.getName();
        return string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("off") ? null : (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("on") ? "" : file.getPath());
    }
}

