/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import proguard.classfile.ClassFile;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;

public class ClassPool {
    private Map classFiles = new HashMap();

    public ClassFile addClass(ClassFile classFile) {
        String string = classFile.getName();
        ClassFile classFile2 = this.classFiles.put(string, classFile);
        if (classFile2 != null) {
            this.classFiles.put(string, classFile2);
        }
        return classFile2;
    }

    public void removeClass(ClassFile classFile) {
        this.classFiles.remove(classFile.getName());
    }

    public ClassFile getClass(String string) {
        return (ClassFile)this.classFiles.get(ClassUtil.internalClassNameFromType(string));
    }

    public Iterator elements() {
        return this.classFiles.values().iterator();
    }

    public int size() {
        return this.classFiles.size();
    }

    public void accept(ClassPoolVisitor classPoolVisitor) {
        classPoolVisitor.visitClassPool(this);
    }

    public void classFilesAccept(ClassFileVisitor classFileVisitor) {
        Iterator iterator = this.elements();
        while (iterator.hasNext()) {
            ClassFile classFile = (ClassFile)iterator.next();
            classFile.accept(classFileVisitor);
        }
    }

    public void classFilesAcceptAlphabetically(ClassFileVisitor classFileVisitor) {
        TreeMap treeMap = new TreeMap(this.classFiles);
        Iterator iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            ClassFile classFile = (ClassFile)iterator.next();
            classFile.accept(classFileVisitor);
        }
    }

    public void classFileAccept(ClassFileVisitor classFileVisitor, String string) {
        ClassFile classFile = this.getClass(string);
        if (classFile != null) {
            classFile.accept(classFileVisitor);
        }
    }
}

