/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.io.DataInput;
import java.io.IOException;
import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMemberInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.LibraryAttrInfo;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class LibraryClassFile
implements ClassFile {
    private static LibraryClassFile reusableLibraryClassFile;
    private static CpInfo[] reusableConstantPool;
    private static LibraryFieldInfo[] reusableFields;
    private static LibraryMethodInfo[] reusableMethods;
    public int u2accessFlags;
    public String thisClassName;
    public String superClassName;
    public String[] interfaceNames;
    public LibraryFieldInfo[] fields;
    public LibraryMethodInfo[] methods;
    public ClassFile superClass = null;
    public ClassFile[] interfaceClasses = null;
    public ClassFile[] subClasses = null;
    public Object visitorInfo;

    public static LibraryClassFile create(DataInput dataInput, boolean bl, boolean bl2) throws IOException {
        if (reusableLibraryClassFile == null) {
            reusableLibraryClassFile = new LibraryClassFile();
        }
        LibraryClassFile libraryClassFile = reusableLibraryClassFile;
        libraryClassFile.read(dataInput, bl, bl2);
        if (libraryClassFile.thisClassName != null) {
            reusableLibraryClassFile = null;
        } else {
            libraryClassFile = null;
        }
        return libraryClassFile;
    }

    private LibraryClassFile() {
    }

    private void read(DataInput dataInput, boolean bl, boolean bl2) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = dataInput.readInt();
        ClassUtil.checkMagicNumber(n7);
        int n8 = dataInput.readUnsignedShort();
        int n9 = dataInput.readUnsignedShort();
        ClassUtil.checkVersionNumbers(n9, n8);
        int n10 = dataInput.readUnsignedShort();
        if (reusableConstantPool == null || reusableConstantPool.length < n10) {
            reusableConstantPool = new CpInfo[n10];
        }
        for (n6 = 1; n6 < n10; ++n6) {
            LibraryClassFile.reusableConstantPool[n6] = CpInfo.createOrShare(dataInput);
            n5 = reusableConstantPool[n6].getTag();
            if (n5 != 5 && n5 != 6) continue;
            ++n6;
        }
        this.u2accessFlags = dataInput.readUnsignedShort();
        if (bl && !this.isVisible()) {
            return;
        }
        n6 = dataInput.readUnsignedShort();
        n5 = dataInput.readUnsignedShort();
        this.thisClassName = this.toName(reusableConstantPool, n6);
        this.superClassName = n5 == 0 ? null : this.toName(reusableConstantPool, n5);
        int n11 = dataInput.readUnsignedShort();
        this.interfaceNames = new String[n11];
        for (n4 = 0; n4 < n11; ++n4) {
            n3 = dataInput.readUnsignedShort();
            this.interfaceNames[n4] = this.toName(reusableConstantPool, n3);
        }
        n4 = dataInput.readUnsignedShort();
        if (reusableFields == null || reusableFields.length < n4) {
            reusableFields = new LibraryFieldInfo[n4];
        }
        n3 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            LibraryFieldInfo libraryFieldInfo = LibraryFieldInfo.create(dataInput, reusableConstantPool);
            if (!libraryFieldInfo.isVisible() && (bl2 || (libraryFieldInfo.getAccessFlags() & 2) != 0)) continue;
            LibraryClassFile.reusableFields[n3++] = libraryFieldInfo;
        }
        this.fields = new LibraryFieldInfo[n3];
        System.arraycopy(reusableFields, 0, this.fields, 0, n3);
        n2 = dataInput.readUnsignedShort();
        if (reusableMethods == null || reusableMethods.length < n2) {
            reusableMethods = new LibraryMethodInfo[n2];
        }
        int n12 = 0;
        for (n = 0; n < n2; ++n) {
            LibraryMethodInfo libraryMethodInfo = LibraryMethodInfo.create(dataInput, reusableConstantPool);
            if (!libraryMethodInfo.isVisible() && (bl || (libraryMethodInfo.getAccessFlags() & 2) != 0)) continue;
            LibraryClassFile.reusableMethods[n12++] = libraryMethodInfo;
        }
        this.methods = new LibraryMethodInfo[n12];
        System.arraycopy(reusableMethods, 0, this.methods, 0, n12);
        n = dataInput.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            LibraryAttrInfo.skip(dataInput);
        }
    }

    boolean isVisible() {
        return (this.u2accessFlags & 1) != 0;
    }

    private String toName(CpInfo[] cpInfoArray, int n) {
        ClassCpInfo classCpInfo = (ClassCpInfo)cpInfoArray[n];
        Utf8CpInfo utf8CpInfo = (Utf8CpInfo)cpInfoArray[classCpInfo.getNameIndex()];
        return utf8CpInfo.getString();
    }

    private LibraryFieldInfo findLibraryField(String string, String string2) {
        for (int i = 0; i < this.fields.length; ++i) {
            LibraryFieldInfo libraryFieldInfo = this.fields[i];
            if (libraryFieldInfo == null || !libraryFieldInfo.getName(this).equals(string) || !libraryFieldInfo.getDescriptor(this).equals(string2)) continue;
            return libraryFieldInfo;
        }
        return null;
    }

    private LibraryMethodInfo findLibraryMethod(String string, String string2) {
        for (int i = 0; i < this.methods.length; ++i) {
            LibraryMethodInfo libraryMethodInfo = this.methods[i];
            if (libraryMethodInfo == null || !libraryMethodInfo.getName(this).equals(string) || !libraryMethodInfo.getDescriptor(this).equals(string2)) continue;
            return libraryMethodInfo;
        }
        return null;
    }

    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    public String getName() {
        return this.thisClassName;
    }

    public String getSuperName() {
        return this.superClassName;
    }

    public String getInterfaceName(int n) {
        return this.interfaceNames[n];
    }

    public int getCpTag(int n) {
        return -1;
    }

    public String getCpString(int n) {
        return null;
    }

    public String getCpClassNameString(int n) {
        return null;
    }

    public String getCpNameString(int n) {
        return null;
    }

    public String getCpTypeString(int n) {
        return null;
    }

    public void addSubClass(ClassFile classFile) {
        if (this.subClasses == null) {
            this.subClasses = new ClassFile[1];
        } else {
            ClassFile[] classFileArray = new ClassFile[this.subClasses.length + 1];
            System.arraycopy(this.subClasses, 0, classFileArray, 0, this.subClasses.length);
            this.subClasses = classFileArray;
        }
        this.subClasses[this.subClasses.length - 1] = classFile;
    }

    public ClassFile getSuperClass() {
        return this.superClass;
    }

    public ClassFile getInterface(int n) {
        return this.interfaceClasses[n];
    }

    public boolean extends_(ClassFile classFile) {
        if (this.equals(classFile)) {
            return true;
        }
        ClassFile classFile2 = this.getSuperClass();
        return classFile2 != null && classFile2.extends_(classFile);
    }

    public boolean implements_(ClassFile classFile) {
        if (this.equals(classFile)) {
            return true;
        }
        if (this.interfaceClasses != null) {
            for (int i = 0; i < this.interfaceClasses.length; ++i) {
                ClassFile classFile2 = this.getInterface(i);
                if (classFile2 == null || !classFile2.implements_(classFile)) continue;
                return true;
            }
        }
        return false;
    }

    public FieldInfo findField(String string, String string2) {
        return this.findLibraryField(string, string2);
    }

    public MethodInfo findMethod(String string, String string2) {
        return this.findLibraryMethod(string, string2);
    }

    public void accept(ClassFileVisitor classFileVisitor) {
        classFileVisitor.visitLibraryClassFile(this);
    }

    public void hierarchyAccept(boolean bl, boolean bl2, boolean bl3, boolean bl4, ClassFileVisitor classFileVisitor) {
        ClassFile classFile;
        int n;
        if (bl) {
            this.accept(classFileVisitor);
        }
        if (bl2 && this.superClass != null) {
            this.superClass.hierarchyAccept(true, true, bl3, false, classFileVisitor);
        }
        if (bl3 && this.interfaceClasses != null) {
            for (n = 0; n < this.interfaceClasses.length; ++n) {
                classFile = this.getInterface(n);
                if (classFile == null) continue;
                classFile.hierarchyAccept(true, true, true, false, classFileVisitor);
            }
        }
        if (bl4 && this.subClasses != null) {
            for (n = 0; n < this.subClasses.length; ++n) {
                classFile = this.subClasses[n];
                classFile.hierarchyAccept(true, false, false, true, classFileVisitor);
            }
        }
    }

    public void constantPoolEntriesAccept(CpInfoVisitor cpInfoVisitor) {
    }

    public void constantPoolEntryAccept(CpInfoVisitor cpInfoVisitor, int n) {
    }

    public void fieldsAccept(MemberInfoVisitor memberInfoVisitor) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] == null) continue;
            this.fields[i].accept(this, memberInfoVisitor);
        }
    }

    public void fieldAccept(MemberInfoVisitor memberInfoVisitor, String string, String string2) {
        LibraryFieldInfo libraryFieldInfo = this.findLibraryField(string, string2);
        if (libraryFieldInfo != null) {
            ((LibraryMemberInfo)libraryFieldInfo).accept(this, memberInfoVisitor);
        }
    }

    public void methodsAccept(MemberInfoVisitor memberInfoVisitor) {
        for (int i = 0; i < this.methods.length; ++i) {
            if (this.methods[i] == null) continue;
            this.methods[i].accept(this, memberInfoVisitor);
        }
    }

    public void methodAccept(MemberInfoVisitor memberInfoVisitor, String string, String string2) {
        LibraryMethodInfo libraryMethodInfo = this.findLibraryMethod(string, string2);
        if (libraryMethodInfo != null) {
            ((LibraryMemberInfo)libraryMethodInfo).accept(this, memberInfoVisitor);
        }
    }

    public void attributesAccept(AttrInfoVisitor attrInfoVisitor) {
    }

    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    public void setVisitorInfo(Object object) {
        this.visitorInfo = object;
    }
}

