/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.visitor.CpInfoVisitor;

public class LongCpInfo
extends CpInfo {
    public int u4highBytes;
    public int u4lowBytes;

    public LongCpInfo(long l) {
        this.setValue(l);
    }

    protected LongCpInfo() {
    }

    public long getValue() {
        return (long)this.u4highBytes << 32 | (long)this.u4lowBytes;
    }

    public void setValue(long l) {
        this.u4highBytes = (int)(l >> 32);
        this.u4lowBytes = (int)l;
    }

    public int getTag() {
        return 5;
    }

    protected void readInfo(DataInput dataInput) throws IOException {
        this.u4highBytes = dataInput.readInt();
        this.u4lowBytes = dataInput.readInt();
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.u4highBytes);
        dataOutput.writeInt(this.u4lowBytes);
    }

    public void accept(ClassFile classFile, CpInfoVisitor cpInfoVisitor) {
        cpInfoVisitor.visitLongCpInfo(classFile, this);
    }
}

