/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;

public class NameAndTypeCpInfo
extends CpInfo
implements Cloneable {
    public int u2nameIndex;
    public int u2descriptorIndex;
    public ClassFile[] referencedClassFiles;

    protected NameAndTypeCpInfo() {
    }

    public NameAndTypeCpInfo(int n, int n2, ClassFile[] classFileArray) {
        this.u2nameIndex = n;
        this.u2descriptorIndex = n2;
        this.referencedClassFiles = classFileArray;
    }

    protected int getNameIndex() {
        return this.u2nameIndex;
    }

    protected void setNameIndex(int n) {
        this.u2nameIndex = n;
    }

    protected int getDescriptorIndex() {
        return this.u2descriptorIndex;
    }

    protected void setDescriptorIndex(int n) {
        this.u2descriptorIndex = n;
    }

    public String getName(ClassFile classFile) {
        return classFile.getCpString(this.u2nameIndex);
    }

    public String getType(ClassFile classFile) {
        return classFile.getCpString(this.u2descriptorIndex);
    }

    public int getTag() {
        return 12;
    }

    protected void readInfo(DataInput dataInput) throws IOException {
        this.u2nameIndex = dataInput.readUnsignedShort();
        this.u2descriptorIndex = dataInput.readUnsignedShort();
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2nameIndex);
        dataOutput.writeShort(this.u2descriptorIndex);
    }

    public void accept(ClassFile classFile, CpInfoVisitor cpInfoVisitor) {
        cpInfoVisitor.visitNameAndTypeCpInfo(classFile, this);
    }

    public void referencedClassesAccept(ClassFileVisitor classFileVisitor) {
        if (this.referencedClassFiles != null) {
            for (int i = 0; i < this.referencedClassFiles.length; ++i) {
                if (this.referencedClassFiles[i] == null) continue;
                this.referencedClassFiles[i].accept(classFileVisitor);
            }
        }
    }
}

