/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.FieldInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;

public abstract class AttrInfo
implements VisitorAccepter {
    protected static final int CONSTANT_FIELD_SIZE = 6;
    public int u2attrNameIndex;
    public Object visitorInfo;

    public static AttrInfo create(DataInput dataInput, ClassFile classFile) throws IOException {
        int n = dataInput.readUnsignedShort();
        int n2 = dataInput.readInt();
        String string = classFile.getCpString(n);
        InnerClassesAttrInfo innerClassesAttrInfo = string.equals("InnerClasses") ? new InnerClassesAttrInfo() : (string.equals("EnclosingMethod") ? new EnclosingMethodAttrInfo() : (string.equals("ConstantValue") ? new ConstantValueAttrInfo() : (string.equals("Exceptions") ? new ExceptionsAttrInfo() : (string.equals("Code") ? new CodeAttrInfo() : (string.equals("LineNumberTable") ? new LineNumberTableAttrInfo() : (string.equals("LocalVariableTable") ? new LocalVariableTableAttrInfo() : (string.equals("SourceFile") ? new SourceFileAttrInfo() : (string.equals("SourceDir") ? new SourceDirAttrInfo() : (string.equals("Deprecated") ? new DeprecatedAttrInfo() : (string.equals("Synthetic") ? new SyntheticAttrInfo() : (string.equals("Signature") ? new SignatureAttrInfo() : (string.equals("RuntimeVisibleAnnotations") ? new RuntimeVisibleAnnotationsAttrInfo() : (string.equals("RuntimeInvisibleAnnotations") ? new RuntimeInvisibleAnnotationsAttrInfo() : (string.equals("RuntimeVisibleParameterAnnotations") ? new RuntimeVisibleParameterAnnotationsAttrInfo() : (string.equals("RuntimeInvisibleParameterAnnotations") ? new RuntimeInvisibleParameterAnnotationsAttrInfo() : (string.equals("AnnotationDefault") ? new AnnotationDefaultAttrInfo() : new UnknownAttrInfo(n2)))))))))))))))));
        innerClassesAttrInfo.u2attrNameIndex = n;
        ((AttrInfo)innerClassesAttrInfo).readInfo(dataInput, classFile);
        return innerClassesAttrInfo;
    }

    protected AttrInfo() {
    }

    public final void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2attrNameIndex);
        dataOutput.writeInt(this.getLength());
        this.writeInfo(dataOutput);
    }

    public String getAttributeName(ClassFile classFile) {
        return classFile.getCpString(this.u2attrNameIndex);
    }

    protected abstract int getLength();

    protected abstract void readInfo(DataInput var1, ClassFile var2) throws IOException;

    protected abstract void writeInfo(DataOutput var1) throws IOException;

    public void accept(ClassFile classFile, AttrInfoVisitor attrInfoVisitor) {
    }

    public void accept(ClassFile classFile, FieldInfo fieldInfo, AttrInfoVisitor attrInfoVisitor) {
        this.accept(classFile, attrInfoVisitor);
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, AttrInfoVisitor attrInfoVisitor) {
        this.accept(classFile, attrInfoVisitor);
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, AttrInfoVisitor attrInfoVisitor) {
        this.accept(classFile, methodInfo, attrInfoVisitor);
    }

    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    public void setVisitorInfo(Object object) {
        this.visitorInfo = object;
    }
}

