/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.InnerClassesInfoVisitor;

public class InnerClassesAttrInfo
extends AttrInfo {
    private static final int CONSTANT_FIELD_SIZE = 2;
    public int u2numberOfClasses;
    public InnerClassesInfo[] classes;

    protected InnerClassesAttrInfo() {
    }

    protected InnerClassesInfo[] getInfo() throws Exception {
        return this.classes;
    }

    protected int getLength() {
        return 2 + this.u2numberOfClasses * 8;
    }

    protected void readInfo(DataInput dataInput, ClassFile classFile) throws IOException {
        this.u2numberOfClasses = dataInput.readUnsignedShort();
        this.classes = new InnerClassesInfo[this.u2numberOfClasses];
        for (int i = 0; i < this.u2numberOfClasses; ++i) {
            this.classes[i] = InnerClassesInfo.create(dataInput);
        }
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2numberOfClasses);
        for (int i = 0; i < this.u2numberOfClasses; ++i) {
            this.classes[i].write(dataOutput);
        }
    }

    public void accept(ClassFile classFile, AttrInfoVisitor attrInfoVisitor) {
        attrInfoVisitor.visitInnerClassesAttrInfo(classFile, this);
    }

    public void innerClassEntriesAccept(ClassFile classFile, InnerClassesInfoVisitor innerClassesInfoVisitor) {
        for (int i = 0; i < this.u2numberOfClasses; ++i) {
            innerClassesInfoVisitor.visitInnerClassesInfo(classFile, this.classes[i]);
        }
    }
}

