/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;

public class Annotation
implements VisitorAccepter {
    private static final int CONSTANT_FIELD_SIZE = 4;
    private static final int CONSTANT_FIELD_SIZE2 = 2;
    public int u2typeIndex;
    public int u2numberOfElementValuePairs;
    public ElementValue[] elementValues;
    public ClassFile[] referencedClassFiles;
    public Object visitorInfo;

    public static Annotation create(DataInput dataInput) throws IOException {
        Annotation annotation = new Annotation();
        annotation.read(dataInput);
        return annotation;
    }

    private void read(DataInput dataInput) throws IOException {
        this.u2typeIndex = dataInput.readUnsignedShort();
        this.u2numberOfElementValuePairs = dataInput.readUnsignedShort();
        this.elementValues = new ElementValue[this.u2numberOfElementValuePairs];
        for (int i = 0; i < this.u2numberOfElementValuePairs; ++i) {
            int n = dataInput.readUnsignedShort();
            this.elementValues[i] = ElementValue.create(dataInput);
            this.elementValues[i].u2elementName = n;
        }
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2typeIndex);
        dataOutput.writeShort(this.u2numberOfElementValuePairs);
        for (int i = 0; i < this.u2numberOfElementValuePairs; ++i) {
            dataOutput.writeShort(this.elementValues[i].u2elementName);
            this.elementValues[i].write(dataOutput);
        }
    }

    protected int getLength() {
        int n = 4;
        for (int i = 0; i < this.u2numberOfElementValuePairs; ++i) {
            n += 2 + this.elementValues[i].getLength();
        }
        return n;
    }

    public void elementValuesAccept(ClassFile classFile, ElementValueVisitor elementValueVisitor) {
        for (int i = 0; i < this.u2numberOfElementValuePairs; ++i) {
            this.elementValues[i].accept(classFile, this, elementValueVisitor);
        }
    }

    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    public void setVisitorInfo(Object object) {
        this.visitorInfo = object;
    }
}

