/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;

public abstract class ElementValue
implements VisitorAccepter {
    protected static final int CONSTANT_FIELD_SIZE = 1;
    public int u1tag;
    public int u2elementName;
    public MethodInfo referencedMethodInfo;
    public Object visitorInfo;

    public static ElementValue create(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        ElementValue elementValue = ElementValue.createElementValue(n);
        elementValue.u1tag = n;
        elementValue.readInfo(dataInput);
        return elementValue;
    }

    private static ElementValue createElementValue(int n) {
        switch (n) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return new ConstantElementValue();
            }
            case 101: {
                return new EnumConstantElementValue();
            }
            case 99: {
                return new ClassElementValue();
            }
            case 64: {
                return new AnnotationElementValue();
            }
            case 91: {
                return new ArrayElementValue();
            }
        }
        throw new IllegalArgumentException("Unknown element value tag [" + n + "]");
    }

    protected ElementValue() {
    }

    public final void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.u1tag);
        this.writeInfo(dataOutput);
    }

    protected abstract int getLength();

    protected abstract void readInfo(DataInput var1) throws IOException;

    protected abstract void writeInfo(DataOutput var1) throws IOException;

    public abstract void accept(ClassFile var1, Annotation var2, ElementValueVisitor var3);

    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    public void setVisitorInfo(Object object) {
        this.visitorInfo = object;
    }
}

