/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationVisitor;

public abstract class RuntimeParameterAnnotationsAttrInfo
extends AttrInfo {
    private static final int CONSTANT_FIELD_SIZE = 2;
    public Annotation[][] parameterAnnotations;

    protected RuntimeParameterAnnotationsAttrInfo() {
    }

    public void annotationsAccept(ClassFile classFile, AnnotationVisitor annotationVisitor) {
        for (int i = 0; i < this.parameterAnnotations.length; ++i) {
            Annotation[] annotationArray = this.parameterAnnotations[i];
            int n = 0;
            while (n < annotationArray.length) {
                annotationVisitor.visitAnnotation(classFile, annotationArray[n]);
                ++i;
            }
        }
    }

    protected int getLength() {
        int n = 2;
        for (int i = 0; i < this.parameterAnnotations.length; ++i) {
            n += 2;
            Annotation[] annotationArray = this.parameterAnnotations[i];
            int n2 = 0;
            while (n2 < annotationArray.length) {
                n += annotationArray[n2].getLength();
                ++i;
            }
        }
        return n;
    }

    protected void readInfo(DataInput dataInput, ClassFile classFile) throws IOException {
        int n = dataInput.readUnsignedShort();
        this.parameterAnnotations = new Annotation[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInput.readUnsignedShort();
            Annotation[] annotationArray = new Annotation[n2];
            for (int j = 0; j < n2; ++j) {
                annotationArray[j] = Annotation.create(dataInput);
            }
            this.parameterAnnotations[i] = annotationArray;
        }
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.parameterAnnotations.length);
        for (int i = 0; i < this.parameterAnnotations.length; ++i) {
            Annotation[] annotationArray = this.parameterAnnotations[i];
            dataOutput.writeShort(annotationArray.length);
            int n = 0;
            while (n < annotationArray.length) {
                annotationArray[n].write(dataOutput);
                ++i;
            }
        }
    }
}

