/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionInfoVisitor;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.InnerClassesInfoVisitor;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableInfoVisitor;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationVisitor;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.editor.CodeAttrInfoEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class ConstantPoolRemapper
implements ClassFileVisitor,
CpInfoVisitor,
MemberInfoVisitor,
AttrInfoVisitor,
InstructionVisitor,
InnerClassesInfoVisitor,
ExceptionInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private CodeAttrInfoEditor codeAttrInfoEditor;
    private int[] cpIndexMap;

    public ConstantPoolRemapper(int n) {
        this.codeAttrInfoEditor = new CodeAttrInfoEditor(n);
    }

    public void setCpIndexMap(int[] nArray) {
        this.cpIndexMap = nArray;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.u2thisClass = this.remapCpIndex(programClassFile.u2thisClass);
        programClassFile.u2superClass = this.remapCpIndex(programClassFile.u2superClass);
        this.remapCpIndexArray(programClassFile.u2interfaces, programClassFile.u2interfacesCount);
        programClassFile.constantPoolEntriesAccept(this);
        programClassFile.fieldsAccept(this);
        programClassFile.methodsAccept(this);
        programClassFile.attributesAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        classCpInfo.u2nameIndex = this.remapCpIndex(classCpInfo.u2nameIndex);
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        fieldrefCpInfo.u2classIndex = this.remapCpIndex(fieldrefCpInfo.u2classIndex);
        fieldrefCpInfo.u2nameAndTypeIndex = this.remapCpIndex(fieldrefCpInfo.u2nameAndTypeIndex);
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        interfaceMethodrefCpInfo.u2classIndex = this.remapCpIndex(interfaceMethodrefCpInfo.u2classIndex);
        interfaceMethodrefCpInfo.u2nameAndTypeIndex = this.remapCpIndex(interfaceMethodrefCpInfo.u2nameAndTypeIndex);
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        methodrefCpInfo.u2classIndex = this.remapCpIndex(methodrefCpInfo.u2classIndex);
        methodrefCpInfo.u2nameAndTypeIndex = this.remapCpIndex(methodrefCpInfo.u2nameAndTypeIndex);
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
        nameAndTypeCpInfo.u2nameIndex = this.remapCpIndex(nameAndTypeCpInfo.u2nameIndex);
        nameAndTypeCpInfo.u2descriptorIndex = this.remapCpIndex(nameAndTypeCpInfo.u2descriptorIndex);
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
        stringCpInfo.u2stringIndex = this.remapCpIndex(stringCpInfo.u2stringIndex);
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMemberInfo(programClassFile, programMethodInfo);
    }

    private void visitMemberInfo(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        programMemberInfo.u2nameIndex = this.remapCpIndex(programMemberInfo.u2nameIndex);
        programMemberInfo.u2descriptorIndex = this.remapCpIndex(programMemberInfo.u2descriptorIndex);
        programMemberInfo.attributesAccept(programClassFile, this);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
        unknownAttrInfo.u2attrNameIndex = this.remapCpIndex(unknownAttrInfo.u2attrNameIndex);
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
        innerClassesAttrInfo.u2attrNameIndex = this.remapCpIndex(innerClassesAttrInfo.u2attrNameIndex);
        innerClassesAttrInfo.innerClassEntriesAccept(classFile, this);
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
        enclosingMethodAttrInfo.u2attrNameIndex = this.remapCpIndex(enclosingMethodAttrInfo.u2attrNameIndex);
        enclosingMethodAttrInfo.u2classIndex = this.remapCpIndex(enclosingMethodAttrInfo.u2classIndex);
        enclosingMethodAttrInfo.u2nameAndTypeIndex = this.remapCpIndex(enclosingMethodAttrInfo.u2nameAndTypeIndex);
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
        constantValueAttrInfo.u2attrNameIndex = this.remapCpIndex(constantValueAttrInfo.u2attrNameIndex);
        constantValueAttrInfo.u2constantValueIndex = this.remapCpIndex(constantValueAttrInfo.u2constantValueIndex);
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
        exceptionsAttrInfo.u2attrNameIndex = this.remapCpIndex(exceptionsAttrInfo.u2attrNameIndex);
        this.remapCpIndexArray(exceptionsAttrInfo.u2exceptionIndexTable, exceptionsAttrInfo.u2numberOfExceptions);
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        codeAttrInfo.u2attrNameIndex = this.remapCpIndex(codeAttrInfo.u2attrNameIndex);
        this.codeAttrInfoEditor.reset(codeAttrInfo.u4codeLength);
        codeAttrInfo.instructionsAccept(classFile, methodInfo, this);
        this.codeAttrInfoEditor.visitCodeAttrInfo(classFile, methodInfo, codeAttrInfo);
        codeAttrInfo.exceptionsAccept(classFile, methodInfo, this);
        codeAttrInfo.attributesAccept(classFile, methodInfo, this);
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
        lineNumberTableAttrInfo.u2attrNameIndex = this.remapCpIndex(lineNumberTableAttrInfo.u2attrNameIndex);
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
        localVariableTableAttrInfo.u2attrNameIndex = this.remapCpIndex(localVariableTableAttrInfo.u2attrNameIndex);
        localVariableTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
        localVariableTypeTableAttrInfo.u2attrNameIndex = this.remapCpIndex(localVariableTypeTableAttrInfo.u2attrNameIndex);
        localVariableTypeTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
        sourceFileAttrInfo.u2attrNameIndex = this.remapCpIndex(sourceFileAttrInfo.u2attrNameIndex);
        sourceFileAttrInfo.u2sourceFileIndex = this.remapCpIndex(sourceFileAttrInfo.u2sourceFileIndex);
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
        sourceDirAttrInfo.u2attrNameIndex = this.remapCpIndex(sourceDirAttrInfo.u2attrNameIndex);
        sourceDirAttrInfo.u2sourceDirIndex = this.remapCpIndex(sourceDirAttrInfo.u2sourceDirIndex);
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
        deprecatedAttrInfo.u2attrNameIndex = this.remapCpIndex(deprecatedAttrInfo.u2attrNameIndex);
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
        syntheticAttrInfo.u2attrNameIndex = this.remapCpIndex(syntheticAttrInfo.u2attrNameIndex);
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
        signatureAttrInfo.u2attrNameIndex = this.remapCpIndex(signatureAttrInfo.u2attrNameIndex);
        signatureAttrInfo.u2signatureIndex = this.remapCpIndex(signatureAttrInfo.u2signatureIndex);
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
        runtimeVisibleAnnotationsAttrInfo.u2attrNameIndex = this.remapCpIndex(runtimeVisibleAnnotationsAttrInfo.u2attrNameIndex);
        runtimeVisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
        runtimeInvisibleAnnotationsAttrInfo.u2attrNameIndex = this.remapCpIndex(runtimeInvisibleAnnotationsAttrInfo.u2attrNameIndex);
        runtimeInvisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        runtimeVisibleParameterAnnotationsAttrInfo.u2attrNameIndex = this.remapCpIndex(runtimeVisibleParameterAnnotationsAttrInfo.u2attrNameIndex);
        runtimeVisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        runtimeInvisibleParameterAnnotationsAttrInfo.u2attrNameIndex = this.remapCpIndex(runtimeInvisibleParameterAnnotationsAttrInfo.u2attrNameIndex);
        runtimeInvisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
        annotationDefaultAttrInfo.u2attrNameIndex = this.remapCpIndex(annotationDefaultAttrInfo.u2attrNameIndex);
        annotationDefaultAttrInfo.defaultValueAccept(classFile, this);
    }

    public void visitInnerClassesInfo(ClassFile classFile, InnerClassesInfo innerClassesInfo) {
        if (innerClassesInfo.u2innerClassInfoIndex != 0) {
            innerClassesInfo.u2innerClassInfoIndex = this.remapCpIndex(innerClassesInfo.u2innerClassInfoIndex);
        }
        if (innerClassesInfo.u2outerClassInfoIndex != 0) {
            innerClassesInfo.u2outerClassInfoIndex = this.remapCpIndex(innerClassesInfo.u2outerClassInfoIndex);
        }
        if (innerClassesInfo.u2innerNameIndex != 0) {
            innerClassesInfo.u2innerNameIndex = this.remapCpIndex(innerClassesInfo.u2innerNameIndex);
        }
    }

    public void visitExceptionInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, ExceptionInfo exceptionInfo) {
        if (exceptionInfo.u2catchType != 0) {
            exceptionInfo.u2catchType = this.remapCpIndex(exceptionInfo.u2catchType);
        }
    }

    public void visitLocalVariableInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2nameIndex = this.remapCpIndex(localVariableInfo.u2nameIndex);
        localVariableInfo.u2descriptorIndex = this.remapCpIndex(localVariableInfo.u2descriptorIndex);
    }

    public void visitLocalVariableTypeInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2nameIndex = this.remapCpIndex(localVariableTypeInfo.u2nameIndex);
        localVariableTypeInfo.u2signatureIndex = this.remapCpIndex(localVariableTypeInfo.u2signatureIndex);
    }

    public void visitAnnotation(ClassFile classFile, Annotation annotation) {
        annotation.u2typeIndex = this.remapCpIndex(annotation.u2typeIndex);
        annotation.elementValuesAccept(classFile, this);
    }

    public void visitConstantElementValue(ClassFile classFile, Annotation annotation, ConstantElementValue constantElementValue) {
        constantElementValue.u2elementName = this.remapCpIndex(constantElementValue.u2elementName);
        constantElementValue.u2constantValueIndex = this.remapCpIndex(constantElementValue.u2constantValueIndex);
    }

    public void visitEnumConstantElementValue(ClassFile classFile, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        enumConstantElementValue.u2elementName = this.remapCpIndex(enumConstantElementValue.u2elementName);
        enumConstantElementValue.u2typeNameIndex = this.remapCpIndex(enumConstantElementValue.u2typeNameIndex);
        enumConstantElementValue.u2constantNameIndex = this.remapCpIndex(enumConstantElementValue.u2constantNameIndex);
    }

    public void visitClassElementValue(ClassFile classFile, Annotation annotation, ClassElementValue classElementValue) {
        classElementValue.u2elementName = this.remapCpIndex(classElementValue.u2elementName);
        classElementValue.u2classInfoIndex = this.remapCpIndex(classElementValue.u2classInfoIndex);
    }

    public void visitAnnotationElementValue(ClassFile classFile, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.u2elementName = this.remapCpIndex(annotationElementValue.u2elementName);
        annotationElementValue.annotationAccept(classFile, this);
    }

    public void visitArrayElementValue(ClassFile classFile, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.u2elementName = this.remapCpIndex(arrayElementValue.u2elementName);
        arrayElementValue.elementValuesAccept(classFile, annotation, this);
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        int n2 = cpInstruction.length(n);
        cpInstruction.cpIndex = this.remapCpIndex(cpInstruction.cpIndex);
        cpInstruction.shrink();
        int n3 = cpInstruction.length(n);
        if (n3 != n2 || this.codeAttrInfoEditor.isModified()) {
            cpInstruction = new CpInstruction().copy(cpInstruction);
            this.codeAttrInfoEditor.replaceInstruction(n, cpInstruction);
        } else {
            cpInstruction.write(codeAttrInfo, n);
        }
    }

    private void remapCpIndexArray(int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.remapCpIndex(nArray[i]);
        }
    }

    private int remapCpIndex(int n) {
        return this.cpIndexMap[n];
    }
}

