/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.RefCpInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.CpInfoVisitor;

public class CpInstruction
extends Instruction
implements CpInfoVisitor {
    public int cpIndex;
    public int constant;
    private int parameterStackDelta;
    private int typeStackDelta;

    public CpInstruction() {
    }

    public CpInstruction(byte by, int n) {
        this(by, n, 0);
    }

    public CpInstruction(byte by, int n, int n2) {
        this.opcode = by;
        this.cpIndex = n;
        this.constant = n2;
    }

    public CpInstruction copy(CpInstruction cpInstruction) {
        this.opcode = cpInstruction.opcode;
        this.cpIndex = cpInstruction.cpIndex;
        this.constant = cpInstruction.constant;
        return this;
    }

    public Instruction shrink() {
        if (this.opcode == 18 && this.cpIndex > 255) {
            this.opcode = (byte)19;
        } else if (this.opcode == 19 && this.cpIndex <= 255) {
            this.opcode = (byte)18;
        }
        return this;
    }

    protected void readInfo(byte[] byArray, int n) {
        int n2 = this.cpIndexSize();
        int n3 = this.constantSize();
        this.cpIndex = CpInstruction.readValue(byArray, n, n2);
        this.constant = CpInstruction.readValue(byArray, n += n2, n3);
    }

    protected void writeInfo(byte[] byArray, int n) {
        int n2 = this.cpIndexSize();
        int n3 = this.constantSize();
        CpInstruction.writeValue(byArray, n, this.cpIndex, n2);
        CpInstruction.writeValue(byArray, n += n2, this.constant, n3);
    }

    public int length(int n) {
        return 1 + this.cpIndexSize() + this.constantSize();
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitCpInstruction(classFile, methodInfo, codeAttrInfo, n, this);
    }

    public String toString(int n) {
        return "[" + n + "] " + this.getName() + " (cpIndex=" + this.cpIndex + ")";
    }

    public int stackPopCount(ClassFile classFile) {
        int n = super.stackPopCount(classFile);
        switch (this.opcode) {
            case -59: {
                n += this.constant;
                break;
            }
            case -77: 
            case -75: {
                classFile.constantPoolEntryAccept(this, this.cpIndex);
                n += this.typeStackDelta;
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                classFile.constantPoolEntryAccept(this, this.cpIndex);
                n += this.parameterStackDelta;
            }
        }
        return n;
    }

    public int stackPushCount(ClassFile classFile) {
        int n = super.stackPushCount(classFile);
        switch (this.opcode) {
            case -78: 
            case -76: 
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                classFile.constantPoolEntryAccept(this, this.cpIndex);
                n += this.typeStackDelta;
            }
        }
        return n;
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        String string = fieldrefCpInfo.getType(classFile);
        this.typeStackDelta = ClassUtil.internalTypeSize(ClassUtil.internalMethodReturnType(string));
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        this.visitRefCpInfo(classFile, interfaceMethodrefCpInfo);
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        this.visitRefCpInfo(classFile, methodrefCpInfo);
    }

    private void visitRefCpInfo(ClassFile classFile, RefCpInfo refCpInfo) {
        String string = refCpInfo.getType(classFile);
        this.parameterStackDelta = ClassUtil.internalMethodParameterSize(string);
        this.typeStackDelta = ClassUtil.internalTypeSize(ClassUtil.internalMethodReturnType(string));
    }

    public String toString() {
        return this.getName() + " (cpIndex=" + this.cpIndex + ")";
    }

    private int cpIndexSize() {
        return this.opcode == 18 ? 1 : 2;
    }

    private int constantSize() {
        return this.opcode == -59 ? 1 : (this.opcode == -71 ? 2 : 0);
    }
}

