/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionVisitor;

public class VariableInstruction
extends Instruction {
    public boolean wide;
    public int variableIndex;
    public int constant;

    public VariableInstruction() {
    }

    public VariableInstruction(byte by, int n) {
        this(by, n, 0);
    }

    public VariableInstruction(byte by, int n, int n2) {
        this.opcode = by;
        this.variableIndex = n;
        this.constant = n2;
        this.wide = this.mustBeWide();
    }

    public VariableInstruction copy(VariableInstruction variableInstruction) {
        this.opcode = variableInstruction.opcode;
        this.variableIndex = variableInstruction.variableIndex;
        this.constant = variableInstruction.constant;
        this.wide = variableInstruction.wide;
        return this;
    }

    public boolean isLoad() {
        return this.opcode < 54 && this.opcode != -124;
    }

    public Instruction shrink() {
        if (this.variableIndex <= 3) {
            switch (this.opcode) {
                case 21: {
                    this.opcode = (byte)(26 + this.variableIndex);
                    break;
                }
                case 22: {
                    this.opcode = (byte)(30 + this.variableIndex);
                    break;
                }
                case 23: {
                    this.opcode = (byte)(34 + this.variableIndex);
                    break;
                }
                case 24: {
                    this.opcode = (byte)(38 + this.variableIndex);
                    break;
                }
                case 25: {
                    this.opcode = (byte)(42 + this.variableIndex);
                    break;
                }
                case 54: {
                    this.opcode = (byte)(59 + this.variableIndex);
                    break;
                }
                case 55: {
                    this.opcode = (byte)(63 + this.variableIndex);
                    break;
                }
                case 56: {
                    this.opcode = (byte)(67 + this.variableIndex);
                    break;
                }
                case 57: {
                    this.opcode = (byte)(71 + this.variableIndex);
                    break;
                }
                case 58: {
                    this.opcode = (byte)(75 + this.variableIndex);
                }
            }
        }
        this.wide = this.mustBeWide();
        return this;
    }

    protected boolean isWide() {
        return this.wide;
    }

    protected void readInfo(byte[] byArray, int n) {
        int n2 = this.variableIndexSize();
        int n3 = this.constantSize();
        if (n2 == 0) {
            this.variableIndex = this.opcode < 59 ? this.opcode - 26 & 3 : this.opcode - 59 & 3;
        } else {
            this.variableIndex = VariableInstruction.readValue(byArray, n, n2);
            n += n2;
        }
        this.constant = VariableInstruction.readSignedValue(byArray, n, n3);
    }

    protected void writeInfo(byte[] byArray, int n) {
        int n2 = this.variableIndexSize();
        int n3 = this.constantSize();
        VariableInstruction.writeValue(byArray, n, this.variableIndex, n2);
        VariableInstruction.writeValue(byArray, n += n2, this.constant, n3);
    }

    public int length(int n) {
        return (this.wide ? 2 : 1) + this.variableIndexSize() + this.constantSize();
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitVariableInstruction(classFile, methodInfo, codeAttrInfo, n, this);
    }

    public String toString(int n) {
        return "[" + n + "] " + this.getName() + (this.wide ? "_w" : "") + " (variableIndex=" + this.variableIndex + ", constant=" + this.constant + ")";
    }

    public String toString() {
        return this.getName() + " (variableIndex=" + this.variableIndex + ", constant=" + this.constant + ")";
    }

    private boolean mustBeWide() {
        return this.variableIndex > 255 || (this.opcode == -124 ? this.constant < -128 || this.constant > 127 : this.constant > 255);
    }

    private int variableIndexSize() {
        return this.opcode >= 26 && this.opcode <= 45 || this.opcode >= 59 && this.opcode <= 78 ? 0 : (this.wide ? 2 : 1);
    }

    private int constantSize() {
        return this.opcode == -124 ? (this.wide ? 2 : 1) : 0;
    }
}

