/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.ClassPool;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.RefCpInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationVisitor;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.util.ClassFileClassForNameReferenceInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.visitor.AllMemberInfoVisitor;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoNameFilter;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.classfile.visitor.NamedFieldVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;

public class ClassFileReferenceInitializer
implements ClassFileVisitor,
MemberInfoVisitor,
CpInfoVisitor,
AttrInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private ClassFileClassForNameReferenceInitializer classFileClassForNameReferenceInitializer;
    private MyMemberFinder memberFinder = new MyMemberFinder();
    private ClassPool programClassPool;
    private ClassPool libraryClassPool;
    private boolean warn;
    private int warningCount;

    public ClassFileReferenceInitializer(ClassPool classPool, ClassPool classPool2) {
        this(classPool, classPool2, true, true);
    }

    public ClassFileReferenceInitializer(ClassPool classPool, ClassPool classPool2, boolean bl, boolean bl2) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.warn = bl;
        this.classFileClassForNameReferenceInitializer = new ClassFileClassForNameReferenceInitializer(classPool, bl2);
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getNoteCount() {
        return this.classFileClassForNameReferenceInitializer.getNoteCount();
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.constantPoolEntriesAccept(this);
        programClassFile.fieldsAccept(this);
        programClassFile.methodsAccept(this);
        programClassFile.attributesAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMemberInfo(programClassFile, programMethodInfo);
    }

    private void visitMemberInfo(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        programMemberInfo.referencedClassFiles = this.findReferencedClasses(programMemberInfo.getDescriptor(programClassFile));
        programMemberInfo.attributesAccept(programClassFile, this);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        this.visitRefCpInfo(classFile, fieldrefCpInfo, true);
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        this.visitRefCpInfo(classFile, interfaceMethodrefCpInfo, false);
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        this.visitRefCpInfo(classFile, methodrefCpInfo, false);
    }

    private void visitRefCpInfo(ClassFile classFile, RefCpInfo refCpInfo, boolean bl) {
        String string = refCpInfo.getClassName(classFile);
        ClassFile classFile2 = this.findClass(string);
        if (classFile2 != null) {
            MemberInfo memberInfo;
            String string2 = refCpInfo.getName(classFile);
            String string3 = refCpInfo.getType(classFile);
            MemberInfo memberInfo2 = memberInfo = bl ? classFile2.findField(string2, string3) : classFile2.findMethod(string2, string3);
            if (memberInfo != null) {
                refCpInfo.referencedClassFile = classFile2;
                refCpInfo.referencedMemberInfo = memberInfo;
                return;
            }
            try {
                classFile2.hierarchyAccept(false, true, true, false, bl ? new NamedFieldVisitor(this.memberFinder, string2, string3) : new NamedMethodVisitor(this.memberFinder, string2, string3));
            }
            catch (MyMemberFinder.MemberFoundException memberFoundException) {
                refCpInfo.referencedClassFile = this.memberFinder.classFile;
                refCpInfo.referencedMemberInfo = this.memberFinder.memberInfo;
                return;
            }
            if (this.warn) {
                ++this.warningCount;
                System.err.println("Warning: " + ClassUtil.externalClassName(classFile.getName()) + ": can't find referenced " + (bl ? "field '" + ClassUtil.externalFullFieldDescription(0, string2, string3) : "method '" + ClassUtil.externalFullMethodDescription(string, 0, string2, string3)) + "' in class " + ClassUtil.externalClassName(string));
            }
        }
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        classCpInfo.referencedClassFile = this.findClass(classCpInfo.getName(classFile));
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
        nameAndTypeCpInfo.referencedClassFiles = this.findReferencedClasses(nameAndTypeCpInfo.getType(classFile));
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
        String string;
        String string2 = enclosingMethodAttrInfo.getClassName(classFile);
        ClassFile classFile2 = this.findClass(string2);
        if (classFile2 == null) {
            if (this.warn) {
                ++this.warningCount;
                System.err.println("Warning: " + ClassUtil.externalClassName(classFile.getName()) + ": can't find enclosing class " + ClassUtil.externalClassName(string2));
            }
            return;
        }
        String string3 = enclosingMethodAttrInfo.getName(classFile);
        MethodInfo methodInfo = classFile2.findMethod(string3, string = enclosingMethodAttrInfo.getType(classFile));
        if (methodInfo == null) {
            if (this.warn) {
                ++this.warningCount;
                System.err.println("Warning: " + ClassUtil.externalClassName(classFile.getName()) + ": can't find enclosing method '" + ClassUtil.externalFullMethodDescription(string2, 0, string3, string) + "' in class " + ClassUtil.externalClassName(string2));
            }
            return;
        }
        enclosingMethodAttrInfo.referencedClassFile = classFile2;
        enclosingMethodAttrInfo.referencedMethodInfo = methodInfo;
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        codeAttrInfo.instructionsAccept(classFile, methodInfo, this.classFileClassForNameReferenceInitializer);
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
        signatureAttrInfo.referencedClassFiles = this.findReferencedClasses(classFile.getCpString(signatureAttrInfo.u2signatureIndex));
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
        runtimeVisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
        runtimeInvisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        runtimeVisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        runtimeInvisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
        annotationDefaultAttrInfo.defaultValueAccept(classFile, this);
    }

    public void visitLocalVariableInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableInfo localVariableInfo) {
        localVariableInfo.referencedClassFile = this.findClass(classFile.getCpString(localVariableInfo.u2descriptorIndex));
    }

    public void visitLocalVariableTypeInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.referencedClassFiles = this.findReferencedClasses(classFile.getCpString(localVariableTypeInfo.u2signatureIndex));
    }

    public void visitAnnotation(ClassFile classFile, Annotation annotation) {
        annotation.referencedClassFiles = this.findReferencedClasses(classFile.getCpString(annotation.u2typeIndex));
        annotation.elementValuesAccept(classFile, this);
    }

    public void visitConstantElementValue(ClassFile classFile, Annotation annotation, ConstantElementValue constantElementValue) {
        this.initializeElementValue(classFile, annotation, constantElementValue);
    }

    public void visitEnumConstantElementValue(ClassFile classFile, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.initializeElementValue(classFile, annotation, enumConstantElementValue);
        enumConstantElementValue.referencedClassFiles = this.findReferencedClasses(classFile.getCpString(enumConstantElementValue.u2typeNameIndex));
    }

    public void visitClassElementValue(ClassFile classFile, Annotation annotation, ClassElementValue classElementValue) {
        this.initializeElementValue(classFile, annotation, classElementValue);
        classElementValue.referencedClassFiles = this.findReferencedClasses(classFile.getCpString(classElementValue.u2classInfoIndex));
    }

    public void visitAnnotationElementValue(ClassFile classFile, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.initializeElementValue(classFile, annotation, annotationElementValue);
        annotationElementValue.annotationAccept(classFile, this);
    }

    public void visitArrayElementValue(ClassFile classFile, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.initializeElementValue(classFile, annotation, arrayElementValue);
        arrayElementValue.elementValuesAccept(classFile, annotation, this);
    }

    private void initializeElementValue(ClassFile classFile, Annotation annotation, ElementValue elementValue) {
        if (annotation != null && annotation.referencedClassFiles != null && elementValue.u2elementName != 0) {
            try {
                annotation.referencedClassFiles[0].accept(new AllMemberInfoVisitor(new MemberInfoNameFilter(this.memberFinder, classFile.getCpString(elementValue.u2elementName))));
            }
            catch (MyMemberFinder.MemberFoundException memberFoundException) {
                elementValue.referencedMethodInfo = (MethodInfo)this.memberFinder.memberInfo;
            }
        }
    }

    private ClassFile[] findReferencedClasses(String string) {
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string);
        int n = descriptorClassEnumeration.classCount();
        if (n > 0) {
            ClassFile[] classFileArray = new ClassFile[n];
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string2 = descriptorClassEnumeration.nextClassName();
                ClassFile classFile = this.findClass(string2);
                if (classFile == null) continue;
                classFileArray[i] = classFile;
                bl = true;
            }
            if (bl) {
                return classFileArray;
            }
        }
        return null;
    }

    private ClassFile findClass(String string) {
        ClassFile classFile = this.programClassPool.getClass(string);
        if (classFile == null) {
            classFile = this.libraryClassPool.getClass(string);
        }
        return classFile;
    }

    private static class MyMemberFinder
    implements MemberInfoVisitor {
        private static final MemberFoundException MEMBER_FOUND = new MemberFoundException();
        private ClassFile classFile;
        private MemberInfo memberInfo;

        private MyMemberFinder() {
        }

        public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
            this.visitMemberInfo(programClassFile, programFieldInfo);
        }

        public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
            this.visitMemberInfo(programClassFile, programMethodInfo);
        }

        public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
            this.visitMemberInfo(libraryClassFile, libraryFieldInfo);
        }

        public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
            this.visitMemberInfo(libraryClassFile, libraryMethodInfo);
        }

        private void visitMemberInfo(ClassFile classFile, MemberInfo memberInfo) {
            this.classFile = classFile;
            this.memberInfo = memberInfo;
            throw MEMBER_FOUND;
        }

        private static class MemberFoundException
        extends IllegalArgumentException {
            private MemberFoundException() {
            }
        }
    }
}

