/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.visitor.ClassFileVisitor;

public class ClassFileAccessFilter
implements ClassFileVisitor {
    private ClassFileVisitor classFileVisitor;
    private int requiredSetAccessFlags;
    private int requiredUnsetAccessFlags;

    public ClassFileAccessFilter(ClassFileVisitor classFileVisitor, int n, int n2) {
        this.classFileVisitor = classFileVisitor;
        this.requiredSetAccessFlags = n;
        this.requiredUnsetAccessFlags = n2;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if (this.accepted(programClassFile.getAccessFlags())) {
            this.classFileVisitor.visitProgramClassFile(programClassFile);
        }
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        if (this.accepted(libraryClassFile.getAccessFlags())) {
            this.classFileVisitor.visitLibraryClassFile(libraryClassFile);
        }
    }

    private boolean accepted(int n) {
        return (this.requiredSetAccessFlags & ~n) == 0 && (this.requiredUnsetAccessFlags & n) == 0;
    }
}

