/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.util.ClassNameMatcher;
import proguard.util.StringMatcher;

public class ClassFileNameFilter
implements ClassFileVisitor {
    private ClassFileVisitor classFileVisitor;
    private StringMatcher regularExpressionMatcher;

    public ClassFileNameFilter(ClassFileVisitor classFileVisitor, String string) {
        this.classFileVisitor = classFileVisitor;
        this.regularExpressionMatcher = new ClassNameMatcher(string);
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if (this.accepted(programClassFile.getName())) {
            this.classFileVisitor.visitProgramClassFile(programClassFile);
        }
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        if (this.accepted(libraryClassFile.getName())) {
            this.classFileVisitor.visitLibraryClassFile(libraryClassFile);
        }
    }

    private boolean accepted(String string) {
        return this.regularExpressionMatcher.matches(string);
    }
}

