/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.util.ClassNameMatcher;
import proguard.util.StringMatcher;

public class MemberInfoDescriptorFilter
implements MemberInfoVisitor {
    private MemberInfoVisitor memberInfoVisitor;
    private StringMatcher regularExpressionMatcher;

    public MemberInfoDescriptorFilter(MemberInfoVisitor memberInfoVisitor, String string) {
        this.memberInfoVisitor = memberInfoVisitor;
        this.regularExpressionMatcher = new ClassNameMatcher(string);
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        if (this.accepted(programFieldInfo.getDescriptor(programClassFile))) {
            this.memberInfoVisitor.visitProgramFieldInfo(programClassFile, programFieldInfo);
        }
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        if (this.accepted(programMethodInfo.getDescriptor(programClassFile))) {
            this.memberInfoVisitor.visitProgramMethodInfo(programClassFile, programMethodInfo);
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        if (this.accepted(libraryFieldInfo.getDescriptor(libraryClassFile))) {
            this.memberInfoVisitor.visitLibraryFieldInfo(libraryClassFile, libraryFieldInfo);
        }
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        if (this.accepted(libraryMethodInfo.getDescriptor(libraryClassFile))) {
            this.memberInfoVisitor.visitLibraryMethodInfo(libraryClassFile, libraryMethodInfo);
        }
    }

    private boolean accepted(String string) {
        return this.regularExpressionMatcher.matches(string);
    }
}

