/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;

public class ClassFileReader
implements DataEntryReader {
    private boolean isLibrary;
    private boolean skipNonPublicLibraryClasses;
    private boolean skipNonPublicLibraryClassMembers;
    private ClassFileVisitor classFileVisitor;

    public ClassFileReader(boolean bl, boolean bl2, boolean bl3, ClassFileVisitor classFileVisitor) {
        this.isLibrary = bl;
        this.skipNonPublicLibraryClasses = bl2;
        this.skipNonPublicLibraryClassMembers = bl3;
        this.classFileVisitor = classFileVisitor;
    }

    public void read(DataEntry dataEntry) throws IOException {
        try {
            ClassFile classFile;
            InputStream inputStream = dataEntry.getInputStream();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            ClassFile classFile2 = classFile = this.isLibrary ? LibraryClassFile.create(dataInputStream, this.skipNonPublicLibraryClasses, this.skipNonPublicLibraryClassMembers) : ProgramClassFile.create(dataInputStream);
            if (classFile != null) {
                classFile.accept(this.classFileVisitor);
            }
            dataEntry.closeInputStream();
        }
        catch (Exception exception) {
            throw new IOException("Can't process class file [" + dataEntry.getName() + "] (" + exception.getMessage() + ")");
        }
    }
}

