/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.RefCpInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableInfoVisitor;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationVisitor;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.obfuscate.ClassFileObfuscator;
import proguard.obfuscate.MemberInfoObfuscator;

public class ClassFileRenamer
implements ClassFileVisitor,
MemberInfoVisitor,
CpInfoVisitor,
AttrInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private MyNameAndTypeRenamer nameAndTypeRenamer = new MyNameAndTypeRenamer();
    private boolean openUpPackages;
    private String newSourceFileAttribute;

    public ClassFileRenamer(boolean bl, String string) {
        this.openUpPackages = bl;
        this.newSourceFileAttribute = string;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.fieldsAccept(this);
        programClassFile.methodsAccept(this);
        programClassFile.constantPoolEntriesAccept(this.nameAndTypeRenamer);
        programClassFile.constantPoolEntriesAccept(this);
        if (this.openUpPackages && this.isPackageVisible(programClassFile.u2accessFlags)) {
            programClassFile.u2accessFlags = this.makePublic(programClassFile.u2accessFlags);
        }
        programClassFile.attributesAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMemberInfo(programClassFile, programMethodInfo);
    }

    private void visitMemberInfo(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        String string;
        String string2 = programMemberInfo.getName(programClassFile);
        String string3 = programMemberInfo.getDescriptor(programClassFile);
        String string4 = MemberInfoObfuscator.newMemberName(programMemberInfo);
        if (string4 != null && !string4.equals(string2)) {
            programMemberInfo.u2nameIndex = this.createUtf8CpInfo(programClassFile, string4);
        }
        if ((string = this.newDescriptor(programMemberInfo.getDescriptor(programClassFile), programMemberInfo.referencedClassFiles)) != null) {
            programMemberInfo.u2descriptorIndex = this.createUtf8CpInfo(programClassFile, string);
        }
        if (this.openUpPackages && this.isPackageVisible(programMemberInfo.u2accessFlags)) {
            programMemberInfo.u2accessFlags = this.makePublic(programMemberInfo.u2accessFlags);
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
        String string = this.newClassName(stringCpInfo.getString(classFile), stringCpInfo.referencedClassFile);
        if (string != null) {
            String string2 = ClassUtil.externalClassName(string);
            stringCpInfo.u2stringIndex = this.createUtf8CpInfo((ProgramClassFile)classFile, string2);
        }
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        String string = this.newClassName(classCpInfo.getName(classFile), classCpInfo.referencedClassFile);
        if (string != null) {
            classCpInfo.u2nameIndex = this.createUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        this.visitRefCpInfo(classFile, fieldrefCpInfo);
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        this.visitRefCpInfo(classFile, interfaceMethodrefCpInfo);
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        this.visitRefCpInfo(classFile, methodrefCpInfo);
    }

    private void visitRefCpInfo(ClassFile classFile, RefCpInfo refCpInfo) {
        String string = this.newMemberName(refCpInfo.referencedMemberInfo);
        if (string != null) {
            refCpInfo.u2nameAndTypeIndex = this.createNameAndTypeCpInfo((ProgramClassFile)classFile, string, refCpInfo.getType(classFile));
        }
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
        String string = this.newMemberName(enclosingMethodAttrInfo.referencedMethodInfo);
        if (string != null) {
            enclosingMethodAttrInfo.u2nameAndTypeIndex = this.createNameAndTypeCpInfo((ProgramClassFile)classFile, string, enclosingMethodAttrInfo.getType(classFile));
        }
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
        localVariableTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
        localVariableTypeTableAttrInfo.localVariablesAccept(classFile, methodInfo, codeAttrInfo, this);
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
        if (this.newSourceFileAttribute != null) {
            sourceFileAttrInfo.u2sourceFileIndex = this.createUtf8CpInfo((ProgramClassFile)classFile, this.newSourceFileAttribute);
        }
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
        if (this.newSourceFileAttribute != null) {
            sourceDirAttrInfo.u2sourceDirIndex = this.createUtf8CpInfo((ProgramClassFile)classFile, this.newSourceFileAttribute);
        }
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
        String string = this.newDescriptor(classFile.getCpString(signatureAttrInfo.u2signatureIndex), signatureAttrInfo.referencedClassFiles);
        if (string != null) {
            signatureAttrInfo.u2signatureIndex = this.createUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
        runtimeVisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
        runtimeInvisibleAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
        runtimeVisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
        runtimeInvisibleParameterAnnotationsAttrInfo.annotationsAccept(classFile, this);
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
        annotationDefaultAttrInfo.defaultValueAccept(classFile, this);
    }

    public void visitLocalVariableInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableInfo localVariableInfo) {
        String string = this.newClassName(classFile.getCpString(localVariableInfo.u2descriptorIndex), localVariableInfo.referencedClassFile);
        if (string != null) {
            localVariableInfo.u2descriptorIndex = this.createUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    public void visitLocalVariableTypeInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeInfo localVariableTypeInfo) {
        String string = this.newDescriptor(classFile.getCpString(localVariableTypeInfo.u2signatureIndex), localVariableTypeInfo.referencedClassFiles);
        if (string != null) {
            localVariableTypeInfo.u2signatureIndex = this.createUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    public void visitAnnotation(ClassFile classFile, Annotation annotation) {
        String string = this.newDescriptor(classFile.getCpString(annotation.u2typeIndex), annotation.referencedClassFiles);
        if (string != null) {
            annotation.u2typeIndex = this.createUtf8CpInfo((ProgramClassFile)classFile, string);
        }
        annotation.elementValuesAccept(classFile, this);
    }

    public void visitConstantElementValue(ClassFile classFile, Annotation annotation, ConstantElementValue constantElementValue) {
        this.renameElementValue(classFile, constantElementValue);
    }

    public void visitEnumConstantElementValue(ClassFile classFile, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.renameElementValue(classFile, enumConstantElementValue);
        String string = this.newDescriptor(classFile.getCpString(enumConstantElementValue.u2typeNameIndex), enumConstantElementValue.referencedClassFiles);
        if (string != null) {
            enumConstantElementValue.u2typeNameIndex = this.createUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    public void visitClassElementValue(ClassFile classFile, Annotation annotation, ClassElementValue classElementValue) {
        this.renameElementValue(classFile, classElementValue);
        String string = this.newDescriptor(classFile.getCpString(classElementValue.u2classInfoIndex), classElementValue.referencedClassFiles);
        if (string != null) {
            classElementValue.u2classInfoIndex = this.createUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    public void visitAnnotationElementValue(ClassFile classFile, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.renameElementValue(classFile, annotationElementValue);
        annotationElementValue.annotationAccept(classFile, this);
    }

    public void visitArrayElementValue(ClassFile classFile, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.renameElementValue(classFile, arrayElementValue);
        arrayElementValue.elementValuesAccept(classFile, annotation, this);
    }

    public void renameElementValue(ClassFile classFile, ElementValue elementValue) {
        String string = this.newMemberName(elementValue.referencedMethodInfo);
        if (string != null) {
            elementValue.u2elementName = this.createUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }

    private int createNameAndTypeCpInfo(ProgramClassFile programClassFile, String string, String string2) {
        int n;
        CpInfo[] cpInfoArray = programClassFile.constantPool;
        int n2 = programClassFile.u2constantPoolCount;
        ClassFile[] classFileArray = null;
        for (n = 1; n < n2; ++n) {
            NameAndTypeCpInfo nameAndTypeCpInfo;
            CpInfo cpInfo = cpInfoArray[n];
            if (cpInfo == null || cpInfo.getTag() != 12 || !(nameAndTypeCpInfo = (NameAndTypeCpInfo)cpInfo).getType(programClassFile).equals(string2)) continue;
            if (nameAndTypeCpInfo.getName(programClassFile).equals(string)) {
                return n;
            }
            classFileArray = nameAndTypeCpInfo.referencedClassFiles;
        }
        n = this.createUtf8CpInfo(programClassFile, string);
        int n3 = this.createUtf8CpInfo(programClassFile, string2);
        return this.addCpInfo(programClassFile, new NameAndTypeCpInfo(n, n3, classFileArray));
    }

    private int createUtf8CpInfo(ProgramClassFile programClassFile, String string) {
        CpInfo[] cpInfoArray = programClassFile.constantPool;
        int n = programClassFile.u2constantPoolCount;
        for (int i = 1; i < n; ++i) {
            Utf8CpInfo utf8CpInfo;
            CpInfo cpInfo = cpInfoArray[i];
            if (cpInfo == null || cpInfo.getTag() != 1 || !(utf8CpInfo = (Utf8CpInfo)cpInfo).getString().equals(string)) continue;
            return i;
        }
        return this.addCpInfo(programClassFile, new Utf8CpInfo(string));
    }

    private int addCpInfo(ProgramClassFile programClassFile, CpInfo cpInfo) {
        int n = programClassFile.u2constantPoolCount;
        CpInfo[] cpInfoArray = programClassFile.constantPool;
        if (n == cpInfoArray.length) {
            programClassFile.constantPool = new CpInfo[n + 1];
            System.arraycopy(cpInfoArray, 0, programClassFile.constantPool, 0, n);
            cpInfoArray = programClassFile.constantPool;
        }
        cpInfoArray[programClassFile.u2constantPoolCount++] = cpInfo;
        return n;
    }

    private String newDescriptor(String string, ClassFile[] classFileArray) {
        if (classFileArray == null) {
            return null;
        }
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string);
        String string2 = descriptorClassEnumeration.nextFluff();
        int n = 0;
        while (descriptorClassEnumeration.hasMoreClassNames()) {
            String string3;
            String string4 = descriptorClassEnumeration.nextClassName();
            String string5 = descriptorClassEnumeration.nextFluff();
            if ((string3 = this.newClassName(string4, classFileArray[n++])) == null) {
                string3 = string4;
            }
            string2 = string2 + string3 + string5;
        }
        if (string.equals(string2)) {
            return null;
        }
        return string2;
    }

    private String newClassName(String string, ClassFile classFile) {
        if (classFile == null) {
            return null;
        }
        String string2 = ClassFileObfuscator.newClassName(classFile);
        if (string2 == null) {
            return null;
        }
        if (string.charAt(0) == '[') {
            string2 = string.substring(0, string.indexOf(76) + 1) + string2 + ';';
        }
        return string2;
    }

    private String newMemberName(MemberInfo memberInfo) {
        if (memberInfo == null) {
            return null;
        }
        return MemberInfoObfuscator.newMemberName(memberInfo);
    }

    private boolean isPackageVisible(int n) {
        return AccessUtil.accessLevel(n) >= 1;
    }

    private int makePublic(int n) {
        return AccessUtil.replaceAccessFlags(n, 1);
    }

    private class MyNameAndTypeRenamer
    implements CpInfoVisitor {
        private MyNameAndTypeRenamer() {
        }

        public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
        }

        public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
        }

        public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
        }

        public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
        }

        public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
        }

        public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
        }

        public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        }

        public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        }

        public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        }

        public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        }

        public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
            String string = ClassFileRenamer.this.newDescriptor(nameAndTypeCpInfo.getType(classFile), nameAndTypeCpInfo.referencedClassFiles);
            if (string != null) {
                nameAndTypeCpInfo.u2descriptorIndex = ClassFileRenamer.this.createUtf8CpInfo((ProgramClassFile)classFile, string);
            }
        }
    }
}

