/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.PrintStream;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.obfuscate.ClassFileObfuscator;
import proguard.obfuscate.MemberInfoObfuscator;

public class MappingPrinter
implements ClassFileVisitor,
MemberInfoVisitor {
    private PrintStream ps;
    private String className;

    public MappingPrinter() {
        this(System.out);
    }

    public MappingPrinter(PrintStream printStream) {
        this.ps = printStream;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        this.className = programClassFile.getName();
        String string = ClassFileObfuscator.newClassName(programClassFile);
        if (string != null) {
            this.ps.println(ClassUtil.externalClassName(this.className) + " -> " + ClassUtil.externalClassName(string) + ":");
            this.className = null;
        }
        programClassFile.fieldsAccept(this);
        programClassFile.methodsAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        String string = MemberInfoObfuscator.newMemberName(programFieldInfo);
        if (string != null) {
            this.printClassNameHeader();
            this.ps.println("    " + MappingPrinter.lineNumberRange(programClassFile, programFieldInfo) + ClassUtil.externalFullFieldDescription(0, programFieldInfo.getName(programClassFile), programFieldInfo.getDescriptor(programClassFile)) + " -> " + string);
        }
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        String string = MemberInfoObfuscator.newMemberName(programMethodInfo);
        if (string != null) {
            this.printClassNameHeader();
            this.ps.println("    " + MappingPrinter.lineNumberRange(programClassFile, programMethodInfo) + ClassUtil.externalFullMethodDescription(programClassFile.getName(), 0, programMethodInfo.getName(programClassFile), programMethodInfo.getDescriptor(programClassFile)) + " -> " + string);
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    private void printClassNameHeader() {
        if (this.className != null) {
            this.ps.println(ClassUtil.externalClassName(this.className) + ":");
            this.className = null;
        }
    }

    private static String lineNumberRange(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        String string = programMemberInfo.getLineNumberRange(programClassFile);
        return string != null ? string + ":" : "";
    }
}

