/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.visitor.AllMemberInfoVisitor;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class MemberInfoLinker
implements ClassFileVisitor,
MemberInfoVisitor {
    private final Map methodInfoMap = new HashMap();

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.hierarchyAccept(true, true, true, false, new AllMemberInfoVisitor(this));
        this.methodInfoMap.clear();
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMethodInfo(programClassFile, programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        this.visitMethodInfo(libraryClassFile, libraryMethodInfo);
    }

    private void visitMethodInfo(ClassFile classFile, MethodInfo methodInfo) {
        if ((methodInfo.getAccessFlags() & 2) != 0) {
            return;
        }
        String string = methodInfo.getName(classFile);
        String string2 = methodInfo.getDescriptor(classFile);
        if (string.equals("<clinit>") || string.equals("<init>")) {
            return;
        }
        MemberInfo memberInfo = MemberInfoLinker.lastMemberInfo(methodInfo);
        String string3 = string + string2;
        MethodInfo methodInfo2 = (MethodInfo)this.methodInfoMap.get(string3);
        if (methodInfo2 == null) {
            this.methodInfoMap.put(string3, memberInfo);
        } else {
            MemberInfo memberInfo2 = MemberInfoLinker.lastMemberInfo(methodInfo2);
            if (memberInfo != memberInfo2) {
                if (memberInfo instanceof LibraryMethodInfo) {
                    memberInfo2.setVisitorInfo(memberInfo);
                } else {
                    memberInfo.setVisitorInfo(memberInfo2);
                }
            }
        }
    }

    static MemberInfo lastMemberInfo(MemberInfo memberInfo) {
        VisitorAccepter visitorAccepter = memberInfo;
        while (visitorAccepter.getVisitorInfo() != null && visitorAccepter.getVisitorInfo() instanceof VisitorAccepter) {
            visitorAccepter = (VisitorAccepter)visitorAccepter.getVisitorInfo();
        }
        return visitorAccepter;
    }
}

