/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.visitor.AllMemberInfoVisitor;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoAccessFilter;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.obfuscate.MemberInfoLinker;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.ReadNameFactory;
import proguard.obfuscate.SimpleNameFactory;

public class MemberInfoObfuscator
implements ClassFileVisitor {
    private static final char UNIQUE_SUFFIX = '_';
    private boolean allowAggressiveOverloading;
    private NameFactory nameFactory = new SimpleNameFactory();
    private NameFactory uniqueNameFactory = new SimpleNameFactory();
    private final Map nonPrivateDescriptorMap = new HashMap();
    private final Map privateDescriptorMap = new HashMap();

    public MemberInfoObfuscator(boolean bl, String string) throws IOException {
        this.allowAggressiveOverloading = bl;
        if (string != null) {
            this.nameFactory = new ReadNameFactory(string, this.nameFactory);
        }
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.hierarchyAccept(true, true, true, false, new AllMemberInfoVisitor(new MyNewNameCollector(this.nonPrivateDescriptorMap)));
        programClassFile.hierarchyAccept(true, true, true, false, new MyNonPrivateMemberInfoObfuscator());
        programClassFile.hierarchyAccept(true, true, true, false, new MyPrivateMemberInfoObfuscator());
        this.nonPrivateDescriptorMap.clear();
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    private Map retrieveNameMap(Map map, String string) {
        HashMap hashMap = (HashMap)map.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(string, hashMap);
        }
        return hashMap;
    }

    static void setNewMemberName(MemberInfo memberInfo, String string) {
        MemberInfoLinker.lastMemberInfo(memberInfo).setVisitorInfo(string);
    }

    static String newMemberName(MemberInfo memberInfo) {
        return (String)MemberInfoLinker.lastMemberInfo(memberInfo).getVisitorInfo();
    }

    private class MyNewNameAssigner
    implements MemberInfoVisitor {
        private final Map descriptorMap;
        private final Map secondaryDescriptorMap;

        public MyNewNameAssigner(Map map) {
            this(map, null);
        }

        public MyNewNameAssigner(Map map, Map map2) {
            this.descriptorMap = map;
            this.secondaryDescriptorMap = map2;
        }

        public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
            this.visitMemberInfo(programClassFile, programFieldInfo);
        }

        public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
            this.visitMemberInfo(programClassFile, programMethodInfo);
        }

        public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        }

        public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        }

        private void visitMemberInfo(ClassFile classFile, MemberInfo memberInfo) {
            String string = memberInfo.getName(classFile);
            if (string.equals("<clinit>") || string.equals("<init>")) {
                return;
            }
            String string2 = MemberInfoObfuscator.newMemberName(memberInfo);
            if (string2 == null) {
                String string3 = memberInfo.getDescriptor(classFile);
                if (!MemberInfoObfuscator.this.allowAggressiveOverloading) {
                    string3 = string3.substring(0, string3.indexOf(41) + 1);
                }
                Map map = MemberInfoObfuscator.this.retrieveNameMap(this.descriptorMap, string3);
                Map map2 = this.secondaryDescriptorMap == null ? null : (Map)this.secondaryDescriptorMap.get(string3);
                MemberInfoObfuscator.this.nameFactory.reset();
                while (map.containsKey(string2 = MemberInfoObfuscator.this.nameFactory.nextName()) || map2 != null && map2.containsKey(string2)) {
                }
                MemberInfoObfuscator.setNewMemberName(memberInfo, string2);
                map.put(string2, string);
            }
        }
    }

    private class MyNewNameCollector
    implements MemberInfoVisitor {
        private final Map descriptorMap;

        public MyNewNameCollector(Map map) {
            this.descriptorMap = map;
        }

        public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
            this.visitMemberInfo(programClassFile, programFieldInfo);
        }

        public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
            this.visitMemberInfo(programClassFile, programMethodInfo);
        }

        public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
            String string = libraryFieldInfo.getName(libraryClassFile);
            MemberInfoObfuscator.setNewMemberName(libraryFieldInfo, string);
            this.visitMemberInfo(libraryClassFile, libraryFieldInfo);
        }

        public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
            String string = libraryMethodInfo.getName(libraryClassFile);
            MemberInfoObfuscator.setNewMemberName(libraryMethodInfo, string);
            this.visitMemberInfo(libraryClassFile, libraryMethodInfo);
        }

        private void visitMemberInfo(ClassFile classFile, MemberInfo memberInfo) {
            String string = memberInfo.getName(classFile);
            if (string.equals("<clinit>") || string.equals("<init>")) {
                return;
            }
            String string2 = MemberInfoObfuscator.newMemberName(memberInfo);
            if (string2 != null) {
                Map map;
                String string3;
                String string4 = memberInfo.getDescriptor(classFile);
                if (!MemberInfoObfuscator.this.allowAggressiveOverloading) {
                    string4 = string4.substring(0, string4.indexOf(41) + 1);
                }
                if ((string3 = (String)(map = MemberInfoObfuscator.this.retrieveNameMap(this.descriptorMap, string4)).get(string2)) != null && !string3.equals(string)) {
                    MemberInfoObfuscator.setNewMemberName(memberInfo, MemberInfoObfuscator.this.uniqueNameFactory.nextName() + '_');
                } else {
                    map.put(string2, string);
                }
            }
        }
    }

    private class MyPrivateMemberInfoObfuscator
    implements ClassFileVisitor {
        private MyPrivateMemberInfoObfuscator() {
        }

        public void visitProgramClassFile(ProgramClassFile programClassFile) {
            MemberInfoAccessFilter memberInfoAccessFilter = new MemberInfoAccessFilter(new MyNewNameAssigner(MemberInfoObfuscator.this.privateDescriptorMap, MemberInfoObfuscator.this.nonPrivateDescriptorMap), 2, 0);
            programClassFile.fieldsAccept(memberInfoAccessFilter);
            programClassFile.methodsAccept(memberInfoAccessFilter);
            MemberInfoObfuscator.this.privateDescriptorMap.clear();
        }

        public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        }
    }

    private class MyNonPrivateMemberInfoObfuscator
    implements ClassFileVisitor {
        private MyNonPrivateMemberInfoObfuscator() {
        }

        public void visitProgramClassFile(ProgramClassFile programClassFile) {
            MemberInfoAccessFilter memberInfoAccessFilter = new MemberInfoAccessFilter(new MyNewNameAssigner(MemberInfoObfuscator.this.nonPrivateDescriptorMap), 0, 2);
            programClassFile.fieldsAccept(memberInfoAccessFilter);
            programClassFile.methodsAccept(memberInfoAccessFilter);
        }

        public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        }
    }
}

