/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class KeepMarker
implements ClassFileVisitor,
MemberInfoVisitor {
    private static final Object KEPT = new Object();

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        KeepMarker.markAsKept(programClassFile);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.visitMemberInfo(programClassFile, programMethodInfo);
    }

    private void visitMemberInfo(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        KeepMarker.markAsKept(programMemberInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    public static void markAsKept(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(KEPT);
    }

    public static boolean isKept(VisitorAccepter visitorAccepter) {
        return visitorAccepter == null || visitorAccepter.getVisitorInfo() == KEPT;
    }
}

