/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.visitor.MemberInfoVisitor;

public class NoSideEffectMethodMarker
implements MemberInfoVisitor {
    private static final Object NO_SIDE_EFFECTS = new Object();

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        NoSideEffectMethodMarker.markAsNoSideEffects(programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        NoSideEffectMethodMarker.markAsNoSideEffects(libraryMethodInfo);
    }

    public static void markAsNoSideEffects(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(NO_SIDE_EFFECTS);
    }

    public static boolean hasNoSideEffects(VisitorAccepter visitorAccepter) {
        return visitorAccepter != null && visitorAccepter.getVisitorInfo() == NO_SIDE_EFFECTS;
    }
}

