/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.optimize.KeepMarker;

public class WriteOnlyFieldMarker
implements InstructionVisitor,
CpInfoVisitor,
MemberInfoVisitor {
    private static final Object READ = new Object();
    private static final Object WRITE_ONLY = new Object();
    private boolean reading;

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        byte by = cpInstruction.opcode;
        if (by == -78 || by == -76) {
            this.reading = true;
            classFile.constantPoolEntryAccept(this, cpInstruction.cpIndex);
        } else if (by == -77 || by == -75) {
            this.reading = false;
            classFile.constantPoolEntryAccept(this, cpInstruction.cpIndex);
        }
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        MemberInfo memberInfo = fieldrefCpInfo.referencedMemberInfo;
        if (memberInfo != null) {
            memberInfo.accept(fieldrefCpInfo.referencedClassFile, this);
        }
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        if (!WriteOnlyFieldMarker.isRead(programFieldInfo)) {
            if (this.reading) {
                WriteOnlyFieldMarker.markAsRead(programFieldInfo);
            } else {
                WriteOnlyFieldMarker.markAsWriteOnly(programFieldInfo);
            }
        }
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    private static void markAsRead(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(READ);
    }

    private static boolean isRead(VisitorAccepter visitorAccepter) {
        return visitorAccepter == null || visitorAccepter.getVisitorInfo() == READ || KeepMarker.isKept(visitorAccepter);
    }

    public static void markAsWriteOnly(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(WRITE_ONLY);
    }

    public static boolean isWriteOnly(VisitorAccepter visitorAccepter) {
        return visitorAccepter != null && visitorAccepter.getVisitorInfo() == WRITE_ONLY && !KeepMarker.isKept(visitorAccepter);
    }
}

