/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionInfoVisitor;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.editor.CodeAttrInfoEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.visitor.ClassFileCleaner;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.optimize.SideEffectInstructionChecker;
import proguard.optimize.evaluation.Processor;
import proguard.optimize.evaluation.TracedBranchUnit;
import proguard.optimize.evaluation.TracedStack;
import proguard.optimize.evaluation.TracedVariables;
import proguard.optimize.evaluation.value.InstructionOffsetValue;
import proguard.optimize.evaluation.value.InstructionOffsetValueFactory;
import proguard.optimize.evaluation.value.ReferenceValue;
import proguard.optimize.evaluation.value.ReferenceValueFactory;
import proguard.optimize.evaluation.value.Value;
import proguard.optimize.evaluation.value.ValueFactory;

public class PartialEvaluator
implements MemberInfoVisitor,
AttrInfoVisitor,
ExceptionInfoVisitor,
InstructionVisitor,
CpInfoVisitor {
    private static final boolean DEBUG_RESULTS = false;
    private static final boolean DEBUG_ANALYSIS = false;
    private static final boolean DEBUG = false;
    private static final int INITIAL_CODE_LENGTH = 1024;
    private static final int INITIAL_VALUE_COUNT = 32;
    private static final int MAXIMUM_EVALUATION_COUNT = 100;
    private InstructionOffsetValue[] varTraceValues = new InstructionOffsetValue[1024];
    private InstructionOffsetValue[] stackTraceValues = new InstructionOffsetValue[1024];
    private InstructionOffsetValue[] branchOriginValues = new InstructionOffsetValue[1024];
    private InstructionOffsetValue[] branchTargetValues = new InstructionOffsetValue[1024];
    private TracedVariables[] vars = new TracedVariables[1024];
    private TracedStack[] stacks = new TracedStack[1024];
    private int[] evaluationCounts = new int[1024];
    private boolean[] initialization = new boolean[1024];
    private boolean[] isNecessary = new boolean[1024];
    private boolean evaluateExceptions;
    private TracedVariables parameters = new TracedVariables(32);
    private TracedVariables variables = new TracedVariables(32);
    private TracedStack stack = new TracedStack(32);
    private TracedBranchUnit branchUnit = new TracedBranchUnit();
    private ClassFileCleaner classFileCleaner = new ClassFileCleaner();
    private SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true);
    private CodeAttrInfoEditor codeAttrInfoEditor = new CodeAttrInfoEditor(1024);
    private boolean isInitializer;

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        boolean bl = (programMethodInfo.u2accessFlags & 8) != 0;
        String string = programMethodInfo.getDescriptor(programClassFile);
        int n = (bl ? 0 : 1) + ClassUtil.internalMethodParameterSize(string);
        this.parameters.reset(n);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
        int n2 = 0;
        this.parameters.setStoreValue(InstructionOffsetValueFactory.create());
        if (!bl) {
            this.parameters.store(n2++, ReferenceValueFactory.create(false));
        }
        while (internalTypeEnumeration.hasMoreTypes()) {
            String string2 = internalTypeEnumeration.nextType();
            Value value = ValueFactory.create(string2);
            this.parameters.store(n2, value);
            n2 += value.isCategory2() ? 2 : 1;
        }
        this.branchUnit.setTraceReturnValue(null);
        try {
            programMethodInfo.attributesAccept(programClassFile, this);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while optimizing after partial evaluation:");
            System.err.println("  ClassFile   = [" + programClassFile.getName() + "]");
            System.err.println("  Method      = [" + programMethodInfo.getName(programClassFile) + programMethodInfo.getDescriptor(programClassFile) + "]");
            System.err.println("Not optimizing this method");
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        Instruction instruction;
        int n;
        int n2;
        int n3 = codeAttrInfo.u4codeLength;
        this.codeAttrInfoEditor.reset(n3);
        if (this.isNecessary.length < n3) {
            this.varTraceValues = new InstructionOffsetValue[n3];
            this.stackTraceValues = new InstructionOffsetValue[n3];
            this.branchOriginValues = new InstructionOffsetValue[n3];
            this.branchTargetValues = new InstructionOffsetValue[n3];
            this.vars = new TracedVariables[n3];
            this.stacks = new TracedStack[n3];
            this.evaluationCounts = new int[n3];
            this.initialization = new boolean[n3];
            this.isNecessary = new boolean[n3];
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                this.varTraceValues[n2] = null;
                this.stackTraceValues[n2] = null;
                this.branchOriginValues[n2] = null;
                this.branchTargetValues[n2] = null;
                this.evaluationCounts[n2] = 0;
                this.initialization[n2] = false;
                this.isNecessary[n2] = false;
                if (this.vars[n2] != null) {
                    this.vars[n2].reset(codeAttrInfo.u2maxLocals);
                }
                if (this.stacks[n2] == null) continue;
                this.stacks[n2].reset(codeAttrInfo.u2maxStack);
            }
        }
        this.variables.reset(codeAttrInfo.u2maxLocals);
        this.stack.reset(codeAttrInfo.u2maxStack);
        this.variables.initialize(this.parameters);
        this.evaluateInstructionBlock(classFile, methodInfo, codeAttrInfo, this.variables, this.stack, this.branchUnit, 0);
        do {
            this.evaluateExceptions = false;
            codeAttrInfo.exceptionsAccept(classFile, methodInfo, this);
        } while (this.evaluateExceptions);
        codeAttrInfo.exceptionsAccept(classFile, methodInfo, this.classFileCleaner);
        codeAttrInfo.instructionsAccept(classFile, methodInfo, this);
        if (methodInfo.getName(classFile).equals("<init>")) {
            this.isNecessary[0] = true;
        }
        n2 = 0;
        do {
            Instruction instruction2;
            if (!this.isTraced(n2) || !this.sideEffectInstructionChecker.hasSideEffects(classFile, methodInfo, codeAttrInfo, n2, instruction2 = InstructionFactory.create(codeAttrInfo.code, n2))) continue;
            this.isNecessary[n2] = true;
        } while (++n2 < n3);
        int n4 = n3;
        n2 = n3 - 1;
        do {
            n = n2 - 1;
            if (this.isNecessary[n2]) {
                n4 = n2;
            }
            n = this.markStraddlingBranches(n2, this.branchTargetValues[n2], true, n4, n);
            n = this.markDependencies(n2, n);
            if (this.isNecessary[n2]) {
                n4 = n2;
            }
            n = this.markStraddlingBranches(n2, this.branchOriginValues[n2], false, n4, n);
            if (!this.isNecessary[n2]) continue;
            n4 = n2;
        } while ((n2 = n) >= 0);
        n2 = n3 - 1;
        do {
            if (!this.isTraced(n2) || this.isNecessary[n2]) continue;
            this.fixStackConsistency(classFile, codeAttrInfo, n2);
        } while (--n2 >= 0);
        n2 = 0;
        do {
            if (!this.isNecessary[n2]) continue;
            this.fixDupInstruction(codeAttrInfo, n2);
        } while (++n2 < n3);
        n4 = n3;
        n2 = n3 - 1;
        do {
            n = n2 - 1;
            if (this.isNecessary[n2]) {
                n4 = n2;
            }
            n = this.markAndSimplifyStraddlingBranches(n2, this.branchTargetValues[n2], n4, n);
            if (this.isNecessary[n2]) {
                n4 = n2;
            }
            n = this.markAndSimplifyStraddlingBranches(this.branchOriginValues[n2], n2, n4, n);
            if (!this.isNecessary[n2]) continue;
            n4 = n2;
        } while ((n2 = n) >= 0);
        n2 = 0;
        do {
            if (!this.initialization[n2] || this.isNecessary[n2]) continue;
            n = this.stackTraceValues[n2].instructionOffset(0);
            int n5 = this.stacks[n].getTop(0).computationalType();
            this.increaseStackSize(n2, n5, false);
        } while (++n2 < n3);
        n = 0;
        do {
            instruction = InstructionFactory.create(codeAttrInfo.code, n);
            if (this.isNecessary[n]) continue;
            this.codeAttrInfoEditor.replaceInstruction(n, null);
            this.codeAttrInfoEditor.replaceInstruction2(n, null);
        } while ((n += instruction.length(n)) < n3);
        this.codeAttrInfoEditor.visitCodeAttrInfo(classFile, methodInfo, codeAttrInfo);
    }

    private int markDependencies(int n, int n2) {
        if (this.isNecessary[n] && !this.codeAttrInfoEditor.isModified(n)) {
            n2 = this.markDependencies(this.varTraceValues[n], n2);
            n2 = this.markDependencies(this.stackTraceValues[n], n2);
        }
        return n2;
    }

    private int markDependencies(InstructionOffsetValue instructionOffsetValue, int n) {
        if (instructionOffsetValue != null) {
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = instructionOffsetValue.instructionOffset(i);
                if (this.isNecessary[n3]) continue;
                this.isNecessary[n3] = true;
                if (n >= n3) continue;
                n = n3;
            }
        }
        return n;
    }

    private int markStraddlingBranches(int n, InstructionOffsetValue instructionOffsetValue, boolean bl, int n2, int n3) {
        if (instructionOffsetValue != null) {
            int n4 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n4; ++i) {
                int n5 = instructionOffsetValue.instructionOffset(i);
                n3 = bl ? this.markStraddlingBranch(n, n5, n2, n3) : this.markStraddlingBranch(n5, n, n2, n3);
            }
        }
        return n3;
    }

    private int markStraddlingBranch(int n, int n2, int n3, int n4) {
        if (!this.isNecessary[n] && this.isStraddlingBranch(n, n2, n3)) {
            this.isNecessary[n] = true;
            if (n4 < n) {
                n4 = n;
            }
        }
        return n4;
    }

    private int markAndSimplifyStraddlingBranches(int n, InstructionOffsetValue instructionOffsetValue, int n2, int n3) {
        int n4;
        if (instructionOffsetValue != null && !this.isNecessary[n] && (n4 = instructionOffsetValue.instructionOffsetCount()) > 0) {
            for (int i = 0; i < n4; ++i) {
                int n5 = instructionOffsetValue.instructionOffset(i);
                if (this.isStraddlingBranch(n, n5, n2)) continue;
                return n3;
            }
            n3 = this.markAndSimplifyStraddlingBranch(n, instructionOffsetValue.instructionOffset(0), n2, n3);
        }
        return n3;
    }

    private int markAndSimplifyStraddlingBranches(InstructionOffsetValue instructionOffsetValue, int n, int n2, int n3) {
        if (instructionOffsetValue != null) {
            int n4 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n4; ++i) {
                int n5 = instructionOffsetValue.instructionOffset(i);
                n3 = this.markAndSimplifyStraddlingBranch(n5, n, n2, n3);
            }
        }
        return n3;
    }

    private int markAndSimplifyStraddlingBranch(int n, int n2, int n3, int n4) {
        if (!this.isNecessary[n] && this.isStraddlingBranch(n, n2, n3)) {
            this.isNecessary[n] = true;
            Instruction instruction = new BranchInstruction(-56, n2 - n).shrink();
            this.codeAttrInfoEditor.replaceInstruction(n, instruction);
            if (n4 < n) {
                n4 = n;
            }
        }
        return n4;
    }

    private boolean isStraddlingBranch(int n, int n2, int n3) {
        return n <= n3 ^ n2 <= n3;
    }

    private void fixStackConsistency(ClassFile classFile, CodeAttrInfo codeAttrInfo, int n) {
        Instruction instruction = InstructionFactory.create(codeAttrInfo.code, n);
        byte by = instruction.opcode;
        int n2 = instruction.stackPopCount(classFile);
        if (n2 > 0 && by != 89 && by != 90 && by != 91 && by != 92 && by != 93 && by != 94 && by != 95) {
            InstructionOffsetValue instructionOffsetValue = this.stackTraceValues[n];
            int n3 = instructionOffsetValue.instructionOffsetCount();
            if (n2 <= 4 && this.isAllNecessary(instructionOffsetValue)) {
                if (by == 87 || by == 88) {
                    this.isNecessary[n] = true;
                } else {
                    this.decreaseStackSize(n, n2, true, true);
                }
            } else if (this.isAnyNecessary(instructionOffsetValue)) {
                for (int i = 0; i < n3; ++i) {
                    int n4 = instructionOffsetValue.instructionOffset(i);
                    if (!this.isNecessary[n4]) continue;
                    Instruction instruction2 = InstructionFactory.create(codeAttrInfo.code, n4);
                    int n5 = this.lastPopInstructionOffset(n4, n, n4);
                    this.decreaseStackSize(n5, instruction2.stackPushCount(classFile), false, false);
                }
            }
        }
    }

    private int lastPopInstructionOffset(int n, int n2, int n3) {
        int n4 = n;
        for (int i = n; i < n2; ++i) {
            if (!this.isNecessary[i] || !this.stackTraceValues[i].contains(n3)) continue;
            n4 = i;
        }
        return n4;
    }

    private void increaseStackSize(int n, int n2, boolean bl) {
        this.isNecessary[n] = true;
        int n3 = n2 == 1 ? 3 : (n2 == 2 ? 9 : (n2 == 3 ? 11 : (n2 == 4 ? 14 : (n2 == 5 ? 1 : 0))));
        SimpleInstruction simpleInstruction = new SimpleInstruction((byte)n3);
        this.codeAttrInfoEditor.insertBeforeInstruction(n, simpleInstruction);
        if (bl) {
            this.codeAttrInfoEditor.deleteInstruction(n);
        }
    }

    private void decreaseStackSize(int n, int n2, boolean bl, boolean bl2) {
        SimpleInstruction simpleInstruction;
        byte by;
        boolean bl3;
        boolean bl4 = bl3 = !bl;
        if (bl2 && n2 > 2) {
            bl = true;
            bl3 = true;
        }
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException("Unsupported stack size reduction [" + n2 + "]");
        }
        this.isNecessary[n] = true;
        if (bl) {
            by = n2 == 1 || n2 == 3 ? (byte)87 : 88;
            simpleInstruction = new SimpleInstruction(by);
            this.codeAttrInfoEditor.insertBeforeInstruction(n, simpleInstruction);
        }
        if (bl3) {
            by = n2 == 1 ? (byte)87 : 88;
            simpleInstruction = new SimpleInstruction(by);
            this.codeAttrInfoEditor.insertAfterInstruction(n, simpleInstruction);
        }
        if (bl2) {
            this.codeAttrInfoEditor.deleteInstruction(n);
        }
    }

    private void fixDupInstruction(CodeAttrInfo codeAttrInfo, int n) {
        int n2 = 0;
        switch (codeAttrInfo.code[n]) {
            case 90: {
                if (this.isStackEntryPresent(n, 1)) break;
                n2 = 89;
                break;
            }
            case 91: {
                if (this.isStackEntryPresent(n, 1) && this.isStackEntryPresent(n, 2)) break;
                if (this.isStackEntryPresent(n, 1) || this.isStackEntryPresent(n, 2)) {
                    n2 = 90;
                    break;
                }
                n2 = 89;
                break;
            }
            case 93: {
                if (this.isStackEntryPresent(n, 2)) break;
                n2 = 92;
                break;
            }
            case 94: {
                if (this.isStackEntryPresent(n, 2) && this.isStackEntryPresent(n, 3)) break;
                if (this.isStackEntryPresent(n, 2) || this.isStackEntryPresent(n, 3)) {
                    n2 = 93;
                    break;
                }
                n2 = 92;
                break;
            }
            case 95: {
                if (this.isStackEntryPresent(n, 0)) break;
                this.isNecessary[n] = false;
            }
        }
        if (n2 != 0) {
            SimpleInstruction simpleInstruction = new SimpleInstruction((byte)n2);
            this.codeAttrInfoEditor.replaceInstruction(n, simpleInstruction);
        }
    }

    private boolean isStackEntryPresent(int n, int n2) {
        return this.isAnyNecessary(this.stacks[n].getTopTraceValue(n2).instructionOffsetValue());
    }

    public void visitExceptionInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, ExceptionInfo exceptionInfo) {
        if (this.isTraced(exceptionInfo.u2startpc, exceptionInfo.u2endpc)) {
            this.variables.reset(codeAttrInfo.u2maxLocals);
            this.generalizeVariables(exceptionInfo.u2startpc, exceptionInfo.u2endpc, this.variables);
            TracedVariables tracedVariables = (TracedVariables)exceptionInfo.getVisitorInfo();
            if (tracedVariables == null) {
                tracedVariables = new TracedVariables(codeAttrInfo.u2maxLocals);
                exceptionInfo.setVisitorInfo(tracedVariables);
            } else if (tracedVariables.equals(this.variables)) {
                return;
            }
            tracedVariables.initialize(this.variables);
            this.variables.reset(codeAttrInfo.u2maxLocals);
            this.stack.reset(codeAttrInfo.u2maxStack);
            InstructionOffsetValue instructionOffsetValue = InstructionOffsetValueFactory.create();
            this.variables.setStoreValue(instructionOffsetValue);
            this.stack.setStoreValue(instructionOffsetValue);
            this.variables.initialize(tracedVariables);
            this.stack.push(ReferenceValueFactory.create(false));
            this.evaluateInstructionBlock(classFile, methodInfo, codeAttrInfo, this.variables, this.stack, this.branchUnit, exceptionInfo.u2handlerpc);
            this.evaluateExceptions = true;
        }
    }

    private boolean isTraced(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this.isTraced(i)) continue;
            return true;
        }
        return false;
    }

    private void generalizeVariables(int n, int n2, TracedVariables tracedVariables) {
        for (int i = n; i < n2; ++i) {
            if (!this.isTraced(i)) continue;
            tracedVariables.generalize(this.vars[i]);
        }
    }

    private void evaluateInstructionBlock(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, TracedVariables tracedVariables, TracedStack tracedStack, TracedBranchUnit tracedBranchUnit, int n) {
        byte[] byArray = codeAttrInfo.code;
        Processor processor = new Processor(tracedVariables, tracedStack, tracedBranchUnit);
        while (true) {
            int n2;
            int n3;
            int n4 = n;
            this.evaluationCounts[n4] = this.evaluationCounts[n4] + 1;
            if (n3 == 0) {
                this.varTraceValues[n] = InstructionOffsetValueFactory.create();
                this.stackTraceValues[n] = InstructionOffsetValueFactory.create();
            }
            InstructionOffsetValue instructionOffsetValue = InstructionOffsetValueFactory.create(n);
            tracedVariables.setStoreValue(instructionOffsetValue);
            tracedStack.setStoreValue(instructionOffsetValue);
            InstructionOffsetValue instructionOffsetValue2 = InstructionOffsetValueFactory.create();
            tracedVariables.setTraceValue(instructionOffsetValue2);
            tracedStack.setTraceValue(instructionOffsetValue2);
            tracedVariables.resetInitialization();
            Instruction instruction = InstructionFactory.create(byArray, n);
            int n5 = n + instruction.length(n);
            InstructionOffsetValue instructionOffsetValue3 = InstructionOffsetValueFactory.create(n5);
            tracedBranchUnit.resetCalled();
            tracedBranchUnit.setTraceBranchTargets(instructionOffsetValue3);
            try {
                instruction.accept(classFile, methodInfo, codeAttrInfo, n, processor);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Unexpected error while performing partial evaluation:");
                System.err.println("  ClassFile   = [" + classFile.getName() + "]");
                System.err.println("  Method      = [" + methodInfo.getName(classFile) + methodInfo.getDescriptor(classFile) + "]");
                System.err.println("  Instruction = " + instruction.toString(n));
                throw runtimeException;
            }
            InstructionOffsetValue instructionOffsetValue4 = tracedVariables.getTraceValue().instructionOffsetValue();
            InstructionOffsetValue instructionOffsetValue5 = tracedStack.getTraceValue().instructionOffsetValue();
            this.varTraceValues[n] = this.varTraceValues[n].generalize(instructionOffsetValue4).instructionOffsetValue();
            this.stackTraceValues[n] = this.stackTraceValues[n].generalize(instructionOffsetValue5).instructionOffsetValue();
            this.initialization[n] = this.initialization[n] || tracedVariables.wasInitialization();
            InstructionOffsetValue instructionOffsetValue6 = tracedBranchUnit.getTraceBranchTargets();
            int n6 = instructionOffsetValue6.instructionOffsetCount();
            tracedVariables.setTraceValue(instructionOffsetValue2);
            tracedStack.setTraceValue(instructionOffsetValue2);
            tracedBranchUnit.setTraceBranchTargets(instructionOffsetValue2);
            if (this.vars[n] == null) {
                this.vars[n] = new TracedVariables(tracedVariables);
                this.stacks[n] = new TracedStack(tracedStack);
            } else if (n3 == 0) {
                this.vars[n].initialize(tracedVariables);
                this.stacks[n].copy(tracedStack);
            } else {
                boolean bl = this.vars[n].generalize(tracedVariables);
                n2 = this.stacks[n].generalize(tracedStack);
                if (!bl && n2 == 0 && instructionOffsetValue6.equals(this.branchTargetValues[n])) break;
                tracedVariables.initialize(this.vars[n]);
                tracedStack.copy(this.stacks[n]);
            }
            if (tracedBranchUnit.wasCalled()) {
                InstructionOffsetValue instructionOffsetValue7 = this.branchTargetValues[n] = this.branchTargetValues[n] == null ? instructionOffsetValue6 : this.branchTargetValues[n].generalize(instructionOffsetValue6).instructionOffsetValue();
                if (n6 == 0) break;
                InstructionOffsetValue instructionOffsetValue8 = InstructionOffsetValueFactory.create(n);
                for (n2 = 0; n2 < n6; ++n2) {
                    int n7 = instructionOffsetValue6.instructionOffset(n2);
                    this.branchOriginValues[n7] = this.branchOriginValues[n7] == null ? instructionOffsetValue8 : this.branchOriginValues[n7].generalize(instructionOffsetValue8).instructionOffsetValue();
                }
                if (n6 > 1) {
                    for (n2 = 0; n2 < n6; ++n2) {
                        this.evaluateInstructionBlock(classFile, methodInfo, codeAttrInfo, new TracedVariables(tracedVariables), new TracedStack(tracedStack), tracedBranchUnit, instructionOffsetValue6.instructionOffset(n2));
                    }
                    break;
                }
            }
            n = instructionOffsetValue6.instructionOffset(0);
        }
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
        if (this.isTraced(n)) {
            switch (simpleInstruction.opcode) {
                case -128: 
                case -126: 
                case -120: 
                case -117: 
                case -114: 
                case -111: 
                case -110: 
                case -109: 
                case 46: 
                case 51: 
                case 52: 
                case 53: 
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 116: 
                case 120: 
                case 122: 
                case 124: 
                case 126: {
                    this.replaceIntegerPushInstruction(n, simpleInstruction);
                    break;
                }
                case -127: 
                case -125: 
                case -123: 
                case -116: 
                case -113: 
                case 47: 
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 117: 
                case 121: 
                case 123: 
                case 125: 
                case 127: {
                    this.replaceLongPushInstruction(n, simpleInstruction);
                    break;
                }
                case -122: 
                case -119: 
                case -112: 
                case 48: 
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 114: 
                case 118: {
                    this.replaceFloatPushInstruction(n, simpleInstruction);
                    break;
                }
                case -121: 
                case -118: 
                case -115: 
                case 49: 
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: 
                case 119: {
                    this.replaceDoublePushInstruction(n, simpleInstruction);
                    break;
                }
                case 50: {
                    this.replaceReferencePushInstruction(n, simpleInstruction);
                }
            }
        }
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
        if (this.isTraced(n)) {
            switch (variableInstruction.opcode) {
                case 21: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    this.replaceIntegerPushInstruction(n, variableInstruction);
                    break;
                }
                case 22: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    this.replaceLongPushInstruction(n, variableInstruction);
                    break;
                }
                case 23: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    this.replaceFloatPushInstruction(n, variableInstruction);
                    break;
                }
                case 24: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    this.replaceDoublePushInstruction(n, variableInstruction);
                    break;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    this.replaceReferencePushInstruction(n, variableInstruction);
                }
            }
        }
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        if (this.isTraced(n) && cpInstruction.opcode == -73) {
            classFile.constantPoolEntryAccept(this, cpInstruction.cpIndex);
            if (this.isInitializer) {
                int n2 = n - 1;
                while (!this.isTraced(n2)) {
                    --n2;
                }
                int n3 = this.stacks[n].size();
                int n4 = this.stacks[n2].getBottomTraceValue(n3).instructionOffsetValue().instructionOffset(0);
                this.stackTraceValues[n4] = this.stackTraceValues[n4].generalize(InstructionOffsetValueFactory.create(n)).instructionOffsetValue();
            }
        }
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        this.replaceBranchInstruction(n, branchInstruction);
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
        this.replaceBranchInstruction(n, tableSwitchInstruction);
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        this.replaceBranchInstruction(n, lookUpSwitchInstruction);
    }

    private void replaceIntegerPushInstruction(int n, Instruction instruction) {
        int n2;
        TracedStack tracedStack = this.stacks[n];
        Value value = tracedStack.getTop(0);
        if (value.isSpecific() && (n2 = value.integerValue().value()) << 16 >> 16 == n2) {
            this.replacePushInstruction(n, (byte)17, n2);
        }
    }

    private void replaceLongPushInstruction(int n, Instruction instruction) {
        long l;
        TracedStack tracedStack = this.stacks[n];
        Value value = tracedStack.getTop(0);
        if (value.isSpecific() && ((l = value.longValue().value()) == 0L || l == 1L)) {
            this.replacePushInstruction(n, (byte)(9L + l), 0);
        }
    }

    private void replaceFloatPushInstruction(int n, Instruction instruction) {
        float f;
        TracedStack tracedStack = this.stacks[n];
        Value value = tracedStack.getTop(0);
        if (value.isSpecific() && ((f = value.floatValue().value()) == 0.0f || f == 1.0f || f == 2.0f)) {
            this.replacePushInstruction(n, (byte)(11.0f + f), 0);
        }
    }

    private void replaceDoublePushInstruction(int n, Instruction instruction) {
        double d;
        TracedStack tracedStack = this.stacks[n];
        Value value = tracedStack.getTop(0);
        if (value.isSpecific() && ((d = value.doubleValue().value()) == 0.0 || d == 1.0)) {
            this.replacePushInstruction(n, (byte)(14.0 + d), 0);
        }
    }

    private void replaceReferencePushInstruction(int n, Instruction instruction) {
        ReferenceValue referenceValue;
        TracedStack tracedStack = this.stacks[n];
        Value value = tracedStack.getTop(0);
        if (value.isSpecific() && (referenceValue = value.referenceValue()).isNull() == 1) {
            this.replacePushInstruction(n, (byte)1, 0);
        }
    }

    private void replacePushInstruction(int n, byte by, int n2) {
        Instruction instruction = new SimpleInstruction(by, n2).shrink();
        this.codeAttrInfoEditor.replaceInstruction(n, instruction);
    }

    private void replaceBranchInstruction(int n, Instruction instruction) {
        InstructionOffsetValue instructionOffsetValue;
        if (this.isTraced(n) && (instructionOffsetValue = this.branchTargetValues[n]) != null && instructionOffsetValue.instructionOffsetCount() == 1 && instruction.opcode != -89 && instruction.opcode != -56 && instruction.opcode != -88 && instruction.opcode != -55) {
            int n2 = instructionOffsetValue.instructionOffset(0) - n;
            if (n2 == instruction.length(n)) {
                this.codeAttrInfoEditor.deleteInstruction(n);
            } else {
                Instruction instruction2 = new BranchInstruction(-56, n2).shrink();
                this.codeAttrInfoEditor.replaceInstruction2(n, instruction2);
            }
        }
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        this.isInitializer = methodrefCpInfo.getName(classFile).equals("<init>");
    }

    private boolean isAnyNecessary(InstructionOffsetValue instructionOffsetValue) {
        int n = instructionOffsetValue.instructionOffsetCount();
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (!this.isNecessary[instructionOffsetValue.instructionOffset(i)]) continue;
            return true;
        }
        return false;
    }

    private boolean isAllNecessary(InstructionOffsetValue instructionOffsetValue) {
        int n = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n; ++i) {
            if (this.isNecessary[instructionOffsetValue.instructionOffset(i)]) continue;
            return false;
        }
        return true;
    }

    private boolean isTraced(int n) {
        return this.evaluationCounts[n] > 0;
    }
}

