/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.RefCpInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.optimize.evaluation.BranchUnit;
import proguard.optimize.evaluation.Stack;
import proguard.optimize.evaluation.Variables;
import proguard.optimize.evaluation.value.DoubleValue;
import proguard.optimize.evaluation.value.DoubleValueFactory;
import proguard.optimize.evaluation.value.FloatValue;
import proguard.optimize.evaluation.value.FloatValueFactory;
import proguard.optimize.evaluation.value.InstructionOffsetValue;
import proguard.optimize.evaluation.value.InstructionOffsetValueFactory;
import proguard.optimize.evaluation.value.IntegerValue;
import proguard.optimize.evaluation.value.IntegerValueFactory;
import proguard.optimize.evaluation.value.LongValueFactory;
import proguard.optimize.evaluation.value.ReferenceValue;
import proguard.optimize.evaluation.value.ReferenceValueFactory;
import proguard.optimize.evaluation.value.Value;
import proguard.optimize.evaluation.value.ValueFactory;

public class Processor
implements InstructionVisitor,
CpInfoVisitor {
    private Variables variables;
    private Stack stack;
    private BranchUnit branchUnit;
    private int parameterCount;
    private Value cpValue;
    private ClassFile referencedClassFile;
    private int referencedTypeDimensionCount;

    public Processor(Variables variables, Stack stack, BranchUnit branchUnit) {
        this.variables = variables;
        this.stack = stack;
        this.branchUnit = branchUnit;
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 0: {
                break;
            }
            case 1: {
                this.stack.push(ReferenceValueFactory.createNull());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                this.stack.push(IntegerValueFactory.create(simpleInstruction.constant));
                break;
            }
            case 9: 
            case 10: {
                this.stack.push(LongValueFactory.create(simpleInstruction.constant));
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.stack.push(FloatValueFactory.create(simpleInstruction.constant));
                break;
            }
            case 14: 
            case 15: {
                this.stack.push(DoubleValueFactory.create(simpleInstruction.constant));
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                this.stack.ipop();
                this.stack.apop();
                this.stack.push(IntegerValueFactory.create());
                break;
            }
            case 47: {
                this.stack.ipop();
                this.stack.apop();
                this.stack.push(LongValueFactory.create());
                break;
            }
            case 48: {
                this.stack.ipop();
                this.stack.apop();
                this.stack.push(FloatValueFactory.create());
                break;
            }
            case 49: {
                this.stack.ipop();
                this.stack.apop();
                this.stack.push(DoubleValueFactory.create());
                break;
            }
            case 50: {
                this.stack.ipop();
                this.stack.apop();
                this.stack.push(ReferenceValueFactory.create(true));
                break;
            }
            case 79: 
            case 84: 
            case 85: 
            case 86: {
                this.stack.ipop();
                this.stack.ipop();
                this.stack.apop();
                break;
            }
            case 80: {
                this.stack.lpop();
                this.stack.ipop();
                this.stack.apop();
                break;
            }
            case 81: {
                this.stack.fpop();
                this.stack.ipop();
                this.stack.apop();
                break;
            }
            case 82: {
                this.stack.dpop();
                this.stack.ipop();
                this.stack.apop();
                break;
            }
            case 83: {
                this.stack.apop();
                this.stack.ipop();
                this.stack.apop();
                break;
            }
            case 87: {
                this.stack.pop1();
                break;
            }
            case 88: {
                this.stack.pop2();
                break;
            }
            case 89: {
                this.stack.dup();
                break;
            }
            case 90: {
                this.stack.dup_x1();
                break;
            }
            case 91: {
                this.stack.dup_x2();
                break;
            }
            case 92: {
                this.stack.dup2();
                break;
            }
            case 93: {
                this.stack.dup2_x1();
                break;
            }
            case 94: {
                this.stack.dup2_x2();
                break;
            }
            case 95: {
                this.stack.swap();
                break;
            }
            case 96: {
                this.stack.push(this.stack.ipop().add(this.stack.ipop()));
                break;
            }
            case 97: {
                this.stack.push(this.stack.lpop().add(this.stack.lpop()));
                break;
            }
            case 98: {
                this.stack.push(this.stack.fpop().add(this.stack.fpop()));
                break;
            }
            case 99: {
                this.stack.push(this.stack.dpop().add(this.stack.dpop()));
                break;
            }
            case 100: {
                this.stack.push(this.stack.ipop().subtractFrom(this.stack.ipop()));
                break;
            }
            case 101: {
                this.stack.push(this.stack.lpop().subtractFrom(this.stack.lpop()));
                break;
            }
            case 102: {
                this.stack.push(this.stack.fpop().subtractFrom(this.stack.fpop()));
                break;
            }
            case 103: {
                this.stack.push(this.stack.dpop().subtractFrom(this.stack.dpop()));
                break;
            }
            case 104: {
                this.stack.push(this.stack.ipop().multiply(this.stack.ipop()));
                break;
            }
            case 105: {
                this.stack.push(this.stack.lpop().multiply(this.stack.lpop()));
                break;
            }
            case 106: {
                this.stack.push(this.stack.fpop().multiply(this.stack.fpop()));
                break;
            }
            case 107: {
                this.stack.push(this.stack.dpop().multiply(this.stack.dpop()));
                break;
            }
            case 108: {
                try {
                    this.stack.push(this.stack.ipop().divideOf(this.stack.ipop()));
                }
                catch (ArithmeticException arithmeticException) {
                    this.stack.push(IntegerValueFactory.create());
                }
                break;
            }
            case 109: {
                this.stack.push(this.stack.lpop().divideOf(this.stack.lpop()));
                break;
            }
            case 110: {
                this.stack.push(this.stack.fpop().divideOf(this.stack.fpop()));
                break;
            }
            case 111: {
                this.stack.push(this.stack.dpop().divideOf(this.stack.dpop()));
                break;
            }
            case 112: {
                try {
                    this.stack.push(this.stack.ipop().remainderOf(this.stack.ipop()));
                }
                catch (ArithmeticException arithmeticException) {
                    this.stack.push(IntegerValueFactory.create());
                }
                break;
            }
            case 113: {
                this.stack.push(this.stack.lpop().remainderOf(this.stack.lpop()));
                break;
            }
            case 114: {
                this.stack.push(this.stack.fpop().remainderOf(this.stack.fpop()));
                break;
            }
            case 115: {
                this.stack.push(this.stack.dpop().remainderOf(this.stack.dpop()));
                break;
            }
            case 116: {
                this.stack.push(this.stack.ipop().negate());
                break;
            }
            case 117: {
                this.stack.push(this.stack.lpop().negate());
                break;
            }
            case 118: {
                this.stack.push(this.stack.fpop().negate());
                break;
            }
            case 119: {
                this.stack.push(this.stack.dpop().negate());
                break;
            }
            case 120: {
                this.stack.push(this.stack.ipop().shiftLeftOf(this.stack.ipop()));
                break;
            }
            case 121: {
                this.stack.push(this.stack.ipop().shiftLeftOf(this.stack.lpop()));
                break;
            }
            case 122: {
                this.stack.push(this.stack.ipop().shiftRightOf(this.stack.ipop()));
                break;
            }
            case 123: {
                this.stack.push(this.stack.ipop().shiftRightOf(this.stack.lpop()));
                break;
            }
            case 124: {
                this.stack.push(this.stack.ipop().unsignedShiftRightOf(this.stack.ipop()));
                break;
            }
            case 125: {
                this.stack.push(this.stack.ipop().unsignedShiftRightOf(this.stack.lpop()));
                break;
            }
            case 126: {
                this.stack.push(this.stack.ipop().and(this.stack.ipop()));
                break;
            }
            case 127: {
                this.stack.push(this.stack.lpop().and(this.stack.lpop()));
                break;
            }
            case -128: {
                this.stack.push(this.stack.ipop().or(this.stack.ipop()));
                break;
            }
            case -127: {
                this.stack.push(this.stack.lpop().or(this.stack.lpop()));
                break;
            }
            case -126: {
                this.stack.push(this.stack.ipop().xor(this.stack.ipop()));
                break;
            }
            case -125: {
                this.stack.push(this.stack.lpop().xor(this.stack.lpop()));
                break;
            }
            case -123: {
                this.stack.push(this.stack.ipop().convertToLong());
                break;
            }
            case -122: {
                this.stack.push(this.stack.ipop().convertToFloat());
                break;
            }
            case -121: {
                this.stack.push(this.stack.ipop().convertToDouble());
                break;
            }
            case -120: {
                this.stack.push(this.stack.lpop().convertToInteger());
                break;
            }
            case -119: {
                this.stack.push(this.stack.lpop().convertToFloat());
                break;
            }
            case -118: {
                this.stack.push(this.stack.lpop().convertToDouble());
                break;
            }
            case -117: {
                this.stack.push(this.stack.fpop().convertToInteger());
                break;
            }
            case -116: {
                this.stack.push(this.stack.fpop().convertToLong());
                break;
            }
            case -115: {
                this.stack.push(this.stack.fpop().convertToDouble());
                break;
            }
            case -114: {
                this.stack.push(this.stack.dpop().convertToInteger());
                break;
            }
            case -113: {
                this.stack.push(this.stack.dpop().convertToLong());
                break;
            }
            case -112: {
                this.stack.push(this.stack.dpop().convertToFloat());
                break;
            }
            case -111: {
                this.stack.push(this.stack.ipop().convertToByte());
                break;
            }
            case -110: {
                this.stack.push(this.stack.ipop().convertToCharacter());
                break;
            }
            case -109: {
                this.stack.push(this.stack.ipop().convertToShort());
                break;
            }
            case -108: {
                this.stack.push(this.stack.lpop().compareReverse(this.stack.lpop()));
                break;
            }
            case -107: {
                FloatValue floatValue = this.stack.fpop();
                FloatValue floatValue2 = this.stack.fpop();
                this.stack.push(floatValue2.compare(floatValue));
                break;
            }
            case -106: {
                this.stack.push(this.stack.fpop().compareReverse(this.stack.fpop()));
                break;
            }
            case -105: {
                DoubleValue doubleValue = this.stack.dpop();
                DoubleValue doubleValue2 = this.stack.dpop();
                this.stack.push(doubleValue2.compare(doubleValue));
                break;
            }
            case -104: {
                this.stack.push(this.stack.dpop().compareReverse(this.stack.dpop()));
                break;
            }
            case -84: {
                this.branchUnit.returnFromMethod(this.stack.ipop());
                break;
            }
            case -83: {
                this.branchUnit.returnFromMethod(this.stack.lpop());
                break;
            }
            case -82: {
                this.branchUnit.returnFromMethod(this.stack.fpop());
                break;
            }
            case -81: {
                this.branchUnit.returnFromMethod(this.stack.dpop());
                break;
            }
            case -80: {
                this.branchUnit.returnFromMethod(this.stack.apop());
                break;
            }
            case -79: {
                this.branchUnit.returnFromMethod(null);
                break;
            }
            case -68: {
                this.stack.ipop();
                this.stack.push(ReferenceValueFactory.create(false));
                break;
            }
            case -66: {
                this.stack.apop();
                this.stack.push(IntegerValueFactory.create());
                break;
            }
            case -65: {
                ReferenceValue referenceValue = this.stack.apop();
                this.stack.clear();
                this.stack.push(referenceValue);
                this.branchUnit.throwException();
                break;
            }
            case -62: 
            case -61: {
                this.stack.apop();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown simple instruction [" + simpleInstruction.opcode + "]");
            }
        }
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        int n2 = cpInstruction.cpIndex;
        switch (cpInstruction.opcode) {
            case -78: 
            case 18: 
            case 19: 
            case 20: {
                this.stack.push(this.cpValue(classFile, n2));
                break;
            }
            case -77: {
                this.stack.pop();
                break;
            }
            case -76: {
                this.stack.apop();
                this.stack.push(this.cpValue(classFile, n2));
                break;
            }
            case -75: {
                this.stack.pop();
                this.stack.apop();
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                Value value = this.cpValue(classFile, n2);
                int n3 = this.parameterCount(classFile, n2);
                for (int i = 0; i < n3; ++i) {
                    this.stack.pop();
                }
                if (cpInstruction.opcode != -72) {
                    this.stack.apop();
                }
                if (value == null) break;
                this.stack.push(value);
                break;
            }
            case -69: {
                this.stack.push(this.cpValue(classFile, n2));
                break;
            }
            case -67: {
                this.stack.ipop();
                this.stack.push(ReferenceValueFactory.create(this.referencedClassFile(classFile, n2), 1, false));
                break;
            }
            case -64: {
                this.stack.push(this.stack.apop());
                break;
            }
            case -63: {
                int n4 = this.stack.apop().instanceOf(this.referencedClassFile(classFile, n2), this.referencedTypeDimensionCount(classFile, n2));
                this.stack.push(n4 == -1 ? IntegerValueFactory.create(0) : (n4 == 1 ? IntegerValueFactory.create(1) : IntegerValueFactory.create()));
                break;
            }
            case -59: {
                int n5 = cpInstruction.constant;
                for (int i = 0; i < n5; ++i) {
                    this.stack.ipop();
                }
                this.stack.push(this.cpValue(classFile, n2));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown constant pool instruction [" + cpInstruction.opcode + "]");
            }
        }
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
        int n2 = variableInstruction.variableIndex;
        switch (variableInstruction.opcode) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.stack.push(this.variables.iload(n2));
                break;
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.stack.push(this.variables.lload(n2));
                break;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.stack.push(this.variables.fload(n2));
                break;
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.stack.push(this.variables.dload(n2));
                break;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.stack.push(this.variables.aload(n2));
                break;
            }
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.variables.store(n2, this.stack.ipop());
                break;
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.variables.store(n2, this.stack.lpop());
                break;
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.variables.store(n2, this.stack.fpop());
                break;
            }
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.variables.store(n2, this.stack.dpop());
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.variables.store(n2, this.stack.pop());
                break;
            }
            case -124: {
                this.variables.store(n2, this.variables.iload(n2).add(IntegerValueFactory.create(variableInstruction.constant)));
                break;
            }
            case -87: {
                InstructionOffsetValue instructionOffsetValue = this.variables.oload(n2);
                this.branchUnit.branch(classFile, codeAttrInfo, n, instructionOffsetValue.instructionOffset(instructionOffsetValue.instructionOffsetCount() - 1));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown variable instruction [" + variableInstruction.opcode + "]");
            }
        }
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        int n2 = n + branchInstruction.branchOffset;
        switch (branchInstruction.opcode) {
            case -103: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, this.stack.ipop().equal(IntegerValueFactory.create(0)));
                break;
            }
            case -102: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, this.stack.ipop().notEqual(IntegerValueFactory.create(0)));
                break;
            }
            case -101: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, this.stack.ipop().lessThan(IntegerValueFactory.create(0)));
                break;
            }
            case -100: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, this.stack.ipop().greaterThanOrEqual(IntegerValueFactory.create(0)));
                break;
            }
            case -99: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, this.stack.ipop().greaterThan(IntegerValueFactory.create(0)));
                break;
            }
            case -98: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, this.stack.ipop().lessThanOrEqual(IntegerValueFactory.create(0)));
                break;
            }
            case -97: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, this.stack.ipop().equal(this.stack.ipop()));
                break;
            }
            case -96: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, this.stack.ipop().notEqual(this.stack.ipop()));
                break;
            }
            case -95: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, -this.stack.ipop().lessThan(this.stack.ipop()));
                break;
            }
            case -94: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, -this.stack.ipop().greaterThanOrEqual(this.stack.ipop()));
                break;
            }
            case -93: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, -this.stack.ipop().greaterThan(this.stack.ipop()));
                break;
            }
            case -92: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, -this.stack.ipop().lessThanOrEqual(this.stack.ipop()));
                break;
            }
            case -91: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, this.stack.apop().equal(this.stack.apop()));
                break;
            }
            case -90: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, this.stack.apop().notEqual(this.stack.apop()));
                break;
            }
            case -89: 
            case -56: {
                this.branchUnit.branch(classFile, codeAttrInfo, n, n2);
                break;
            }
            case -88: 
            case -55: {
                this.stack.push(InstructionOffsetValueFactory.create(n + branchInstruction.length(n)));
                this.branchUnit.branch(classFile, codeAttrInfo, n, n2);
                break;
            }
            case -58: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, this.stack.apop().isNull());
                break;
            }
            case -57: {
                this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n2, this.stack.apop().isNotNull());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown branch instruction [" + branchInstruction.opcode + "]");
            }
        }
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
        IntegerValue integerValue = this.stack.ipop();
        this.branchUnit.branch(classFile, codeAttrInfo, n, n + tableSwitchInstruction.defaultOffset);
        for (int i = 0; i < tableSwitchInstruction.jumpOffsetCount; ++i) {
            int n2 = integerValue.equal(IntegerValueFactory.create(tableSwitchInstruction.lowCase + i));
            this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n + tableSwitchInstruction.jumpOffsets[i], n2);
            if (n2 == 1) break;
        }
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        IntegerValue integerValue = this.stack.ipop();
        this.branchUnit.branch(classFile, codeAttrInfo, n, n + lookUpSwitchInstruction.defaultOffset);
        for (int i = 0; i < lookUpSwitchInstruction.jumpOffsetCount; ++i) {
            int n2 = integerValue.equal(IntegerValueFactory.create(lookUpSwitchInstruction.cases[i]));
            this.branchUnit.branchConditionally(classFile, codeAttrInfo, n, n + lookUpSwitchInstruction.jumpOffsets[i], n2);
            if (n2 == 1) break;
        }
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
        this.cpValue = IntegerValueFactory.create(integerCpInfo.getValue());
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
        this.cpValue = LongValueFactory.create(longCpInfo.getValue());
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
        this.cpValue = FloatValueFactory.create(floatCpInfo.getValue());
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
        this.cpValue = DoubleValueFactory.create(doubleCpInfo.getValue());
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
        this.cpValue = ReferenceValueFactory.create(false);
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
        this.cpValue = ValueFactory.create(fieldrefCpInfo.getType(classFile));
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
        this.visitRefCpInfo(classFile, interfaceMethodrefCpInfo);
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
        this.visitRefCpInfo(classFile, methodrefCpInfo);
    }

    private void visitRefCpInfo(ClassFile classFile, RefCpInfo refCpInfo) {
        String string = refCpInfo.getType(classFile);
        this.parameterCount = ClassUtil.internalMethodParameterCount(string);
        this.cpValue = ValueFactory.create(ClassUtil.internalMethodReturnType(string));
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        String string = classCpInfo.getName(classFile);
        this.referencedClassFile = classCpInfo.referencedClassFile;
        this.referencedTypeDimensionCount = ClassUtil.internalArrayTypeDimensionCount(string);
        this.cpValue = ReferenceValueFactory.create(this.referencedClassFile, this.referencedTypeDimensionCount, false);
    }

    private Value cpValue(ClassFile classFile, int n) {
        classFile.constantPoolEntryAccept(this, n);
        return this.cpValue;
    }

    private ClassFile referencedClassFile(ClassFile classFile, int n) {
        classFile.constantPoolEntryAccept(this, n);
        return this.referencedClassFile;
    }

    private int referencedTypeDimensionCount(ClassFile classFile, int n) {
        return this.referencedTypeDimensionCount;
    }

    private int parameterCount(ClassFile classFile, int n) {
        return this.parameterCount;
    }
}

